#ifndef MYASSERT_H_INCLUDED
#define MYASSERT_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

void _myassert(const char *exp, const char *file, const char *function, int line);
void _tag(const char *file, const char *function, int line);

#ifdef __cplusplus
}
#endif

#define myassert(exp) (void)( (exp) || (_myassert(#exp, __FILE__, __FUNCTION__, __LINE__), 0) )
#define tag() (void)( (_tag(__FILE__, __FUNCTION__, __LINE__)) )

#endif
