/* mesh class */
/* SoopaDoopa 2002 */

#include <tamtypes.h>
#include <sifcmd.h>
#include <kernel.h>
#include <sifrpc.h>

#include "mesh.h"
#include "malloc.h"
#include "gif.h"
#include "dma.h"
#include "main.h"

#include "myassert.h"

#define ZBUF_MULTIPLIER 25000.0f

extern unsigned int mesh_vucodebegin  __attribute__((section(".vudata")));
extern unsigned int mesh_vucodeend  __attribute__((section(".vudata")));
extern unsigned int mesh_vudatabegin  __attribute__((section(".vudata")));
extern unsigned int mesh_vudataend  __attribute__((section(".vudata")));

extern int128 mesh_e_giftag_texture,mesh_e_giftag_textureflat  __attribute__((section(".vudata")));

#ifdef __cplusplus
inline static int max(int a, int b){if(a>b)return a;return b;}
inline static int min(int a, int b){if(a<b)return a;return b;}
#endif

void mesh::init()
{
  nfac=0;
  flist=0;
  nvec=0;
  vlist=0;
}


void mesh::init(int nvec, int nfac)
{
  this->nfac=nfac;
  this->nvec=nvec;

  flist=(face*)malloc(nfac*sizeof(face));
  myassert(flist);
  vlist=(fvec*)malloc(nvec*sizeof(fvec));
  myassert(vlist);
}


void mesh::tetrahedron()
{
  nfac=4;
  nvec=4;
  flist=(face*)malloc(nfac*sizeof(face));
  myassert(flist);
  vlist=(fvec*)malloc(nvec*sizeof(fvec));
  myassert(vlist);
  
  vlist[0]=fvec_(1,0,1);
  vlist[1]=fvec_(-1,0,1);
  vlist[2]=fvec_(0,1,-1);
  vlist[3]=fvec_(0,-1,-1);
  
  flist[0]=face(0,1,2,0x909060);
  flist[1]=face(0,3,1,0x906080);
  flist[2]=face(2,1,3,0x608090);
  flist[3]=face(0,2,3,0x809090);
}


void mesh::draw(fmatrix *m)
{
  int maxfac=100;
  gif_env;
  //using vif
  
#define drawMaxVertexNum 18000
  //	static fvec tlist[240];
  static fvec tlist[drawMaxVertexNum];
  
  myassert(nvec<=drawMaxVertexNum);
  transformf(m,vlist,tlist,nvec);
  
  //	if(nfac>1500)nfac=1500;
  
  int j=0;
  while(j<nfac)
    {
      dma01_beginp();
      vif_nop();
      vif_nop();
      vif_nop();
      vif_direct_begin();
      
      {
	gif_tag(0xe,1,0,0,0);
	
	gPRMODECONT(1);				// refer to prim attributes
	gCOLCLAMP(1);
	gDTHE(0);				// Dither off
	gCLAMP_1(0);
	gPABE(0);
	gTEST_1(0x70000);//zbufon
	gPRIM(PRIMtriangle+PRIMtexture+PRIMuv);
	//		gRGBAQ(0x3F80000000908060);		// Background RGBA
	
	int J=min(j+maxfac,nfac);
	//			for(int t=0;t<nfac;t++)
	for(int t=j;t<J;t++)
	  {
	    int a=flist[t].a;
	    int b=flist[t].b;
	    int c=flist[t].c;
	    
	    int x1=(int)(tlist[a].x/tlist[a].z);
	    int y1=(int)(tlist[a].y/tlist[a].z);
	    int z1=3000-(int)(tlist[a].z);
	    int t1=((ivec*)vlist)[a].w;
	    
	    int x2=(int)(tlist[b].x/tlist[b].z);
	    int y2=(int)(tlist[b].y/tlist[b].z);
	    int z2=3000-(int)(tlist[b].z);
	    int t2=((ivec*)vlist)[b].w;
	    
	    int x3=(int)(tlist[c].x/tlist[c].z);
	    int y3=(int)(tlist[c].y/tlist[c].z);
	    int z3=3000-(int)(tlist[c].z);
	    int t3=((ivec*)vlist)[c].w;
	    
	    //t1=a*0x00200030;
	    //t2=b*0x00200030;
	    //				t3=c*0x00200030;
	    
	    
	    //			if(t<110)		
	    //{
	    gUV(t1);
	    gXYZ2(wwd(hhw(x1,y1),z1));
	    gUV(t2);
	    gXYZ2(wwd(hhw(x2,y2),z2));
	    gRGBAQ(0x3F80000000000000+flist[t].col);		// Background RGBA
	    gUV(t3);
	    gXYZ2(wwd(hhw(x3,y3),z3));
	    //}
	  }
	j=J;
      }
      
      gif_endfinal();
      vif_direct_end();
      dma01_endp();
    }
}


#define MAXCLIPFACES 16


int singleClip(fvec *src, fvec *dest, int n, fvec plane)
{
  int m=0;
  for(int i=0;i<n;i++)
    {
      fvec sa=src[i*3];
      fvec sb=src[i*3+1];
      fvec sc=src[i*3+2];

      fvec *pa=&sa;
      fvec *pb=&sb;
      fvec *pc=&sc;

      // sa.w=0;
      // sb.w=0;
      // sc.w=0;

      float A=dot3(sa,plane);
      float B=dot3(sb,plane);
      float C=dot3(sc,plane);

      if(A<0)
	{
	  fvec *temp=pa;
	  float TEMP=A;
	  pa=pb;
	  A=B;
	  pb=temp;
	  B=TEMP;
	}
      if(B<0)
	{
	  fvec *temp=pb;
	  float TEMP=B;
	  pb=pc;
	  B=C;
	  pc=temp;
	  C=TEMP;
	}
      if(A<0)
	{
	  fvec *temp=pa;
	  float TEMP=A;
	  pa=pb;
	  A=B;
	  pb=temp;
	  B=TEMP;
	}
      fvec &a=*pa;
      fvec &b=*pb;
      fvec &c=*pc;
      //      myassert(!(A<0) || B<0);
      //      myassert(!(B<0) || C<0);

      if(A<0)
	{
	}
      else if(B<0)
	{
	  float k=(1/(A-B));
	  float k1=k*A;
	  float k2=-k*B;
	  float K=(1/(A-C));
	  float K1=K*A;
	  float K2=-K*C;
	  dest[m*3]=a;
	  dest[m*3+1]=k1*b+k2*a;
	  dest[m*3+2]=K1*c+K2*a;
	  m++;
	}
      else if(C<0)
	{
	  float k=(1/(A-C));
	  float k1=k*A;
	  float k2=-k*C;
	  float K=(1/(B-C));
	  float K1=K*B;
	  float K2=-K*C;
	  dest[m*3]=a;
	  dest[m*3+1]=k1*c+k2*a;
	  dest[m*3+4]=dest[m*3+2]=K1*c+K2*b;
	  m++;
	  dest[m*3]=a;
	  //	  dest[m*3+1]=K1*c+K2*b;
	  dest[m*3+2]=b;
	  m++;
	}
      else
	{
	  int m3=m+m+m;
	  dest[m3]=a;
	  dest[m3+1]=b;
	  dest[m3+2]=c;
	  m++;
	}
      //myassert(m<MAXCLIPFACES);
    }
  return m;
}


static fvec clipList[2][MAXCLIPFACES*3];


void frustumClip(fvec a, fvec b, fvec c, int &n, fvec *&faceList)
{
  int j=0;
  int J=1;

  n=1;

  clipList[j][0]=a;
  clipList[j][1]=b;
  clipList[j][2]=c;


  for(int t=0;t<4;t++)
    {
      fvec v;
      
      switch(t)
	{
	case 0:
	  v=fvec_(0,1,1,0);
	  break;
	case 1:
	  v=fvec_(0,-1,1,0);
	  break;
	case 2:
	  v=fvec_(1,0,1,0);
	  break;
	case 3:
	  v=fvec_(-1,0,1,0);
	  break;
	}
	
      n=singleClip(clipList[j], clipList[J], n, v);
      J=j;
      j=1-J;
    }
  faceList=clipList[j];
}


void frustumClipRel(fvec a, fvec b, fvec c, int &n, fvec *&faceList)
{
  int j=0;
  int J=1;

  n=1;

  clipList[j][0]=fvec_(1,0,0,0);
  clipList[j][1]=fvec_(0,1,0,0);
  clipList[j][2]=fvec_(0,0,1,0);

  for(int t=0;t<4;t++)
    {
      fvec v;
      
      switch(t)
	{
	case 0:
	  v=fvec_(0,1,1,0);
	  break;
	case 1:
	  v=fvec_(0,-1,1,0);
	  break;
	case 2:
	  v=fvec_(1,0,1,0);
	  break;
	case 3:
	  v=fvec_(-1,0,1,0);
	  break;
	}
	
      fvec w;
      w.x=dot(v,a);
      w.y=dot(v,b);
      w.z=dot(v,c);
      n=singleClip(clipList[j], clipList[J], n, w);
      J=j;
      j=1-J;
    }
  faceList=clipList[j];
}


void mesh::draw_zclipRel(fmatrix *m, texture *dest, bool zteston)
{
  fvec noClipFaceList[3];

  noClipFaceList[0]=fvec_(1,0,0,0);
  noClipFaceList[1]=fvec_(0,1,0,0);
  noClipFaceList[2]=fvec_(0,0,1,0);

  float scaleX=320*16;
  float scaleY=128*16;

  if(dest)
    {
      scaleX=dest->width*8;
      scaleY=dest->height*8;
    }


  float offsetX=scaleX+32000;
  float offsetY=scaleY+32000;

  if(1)// to avoid clipping errors at screen boundary
    {
      static fmatrix s;
      s=*m;
      m=&s;
      scalematrixf(m,1/1.02,1/1.02,1);
      scaleY*=1.02;
      scaleX*=1.02;
    }

  //clipping using relative coordinates. XYZ and UV coordinates are computed when drawing

  // the screen matrix has not been applied to m yet???

  int maxfac=100;
  gif_env;
  //using vif
  
  //	static fvec tlist[240];
  static fvec tlist[2400];
  
  myassert(nvec<=2400);
  transformf(m,vlist,tlist,nvec);
  
  //  for(int i=0;i<nvec;i++)printf("%i %i %i %i\n",i,tlist[i].x,tlist[i].y,tlist[i].z);

  //	if(nfac>1500)nfac=1500;
  
  int j=0;
  int clipBufRemaining=0;
  int numberInBuffer=0;
  fvec *faceList=0;
  int color=0;

  fvec tA,tB,tC;
  fvec tAuv,tBuv,tCuv;
  

  while(j<nfac || clipBufRemaining!=0)
    {
      if(clipBufRemaining==0)
	{
	  int a=flist[j].a;
	  int b=flist[j].b;
	  int c=flist[j].c;
	  color=flist[j].col;
	  j++;

	  if((((*(int*)(&tlist[a].z))&(*(int*)(&tlist[b].z)))&((*(int*)(&tlist[c].z))&0x80000000))==0)
	    {

	      float af0=tlist[a].z-tlist[a].x;
	      float af1=tlist[a].z+tlist[a].x;
	      float af2=tlist[a].z-tlist[a].y;
	      float af3=tlist[a].z+tlist[a].y;
	      int af=(8&((*((int*)&af3))>>28))+(4&((*((int*)&af2))>>29))+(2&((*((int*)&af1))>>30))+(1&((*((int*)&af0))>>31));
	      float bf0=tlist[b].z-tlist[b].x;
	      float bf1=tlist[b].z+tlist[b].x;
	      float bf2=tlist[b].z-tlist[b].y;
	      float bf3=tlist[b].z+tlist[b].y;
	      int bf=(8&((*((int*)&bf3))>>28))+(4&((*((int*)&bf2))>>29))+(2&((*((int*)&bf1))>>30))+(1&((*((int*)&bf0))>>31));
	      float cf0=tlist[c].z-tlist[c].x;
	      float cf1=tlist[c].z+tlist[c].x;
	      float cf2=tlist[c].z-tlist[c].y;
	      float cf3=tlist[c].z+tlist[c].y;
	      int cf=(8&((*((int*)&cf3))>>28))+(4&((*((int*)&cf2))>>29))+(2&((*((int*)&cf1))>>30))+(1&((*((int*)&cf0))>>31));

	      if((af&bf&cf)==0)
		if(tlist[a].x*(tlist[b].y*tlist[c].z-tlist[c].y*tlist[b].z)
		   +tlist[a].z*(tlist[b].x*tlist[c].y-tlist[c].x*tlist[b].y)
		   <tlist[a].y*(tlist[b].x*tlist[c].z-tlist[c].x*tlist[b].z))
		  {
		    tA=tlist[a];
		    tB=tlist[b];
		    tC=tlist[c];
		    if(af+bf+cf!=0)
		      frustumClipRel(tlist[a], tlist[b], tlist[c], clipBufRemaining , faceList);
		    else
		      {
			faceList=noClipFaceList;
			clipBufRemaining=1;
		      }

		    if(1)
		      {
			tAuv=fvec_(((*((s32*)&vlist[a].w))&65535)/4096.0f,((*((s32*)&vlist[a].w))>>16)/4096.0f,0);
			tBuv=fvec_(((*((s32*)&vlist[b].w))&65535)/4096.0f,((*((s32*)&vlist[b].w))>>16)/4096.0f,0);
			tCuv=fvec_(((*((s32*)&vlist[c].w))&65535)/4096.0f,((*((s32*)&vlist[c].w))>>16)/4096.0f,0);
		      }
	      
	      
		    /*	      else
			      {
			      tAuv=fvec_(0,0,0);
			      tBuv=fvec_(1,0,0);
			      tCuv=fvec_(0,1,0);
			      }*/
		  }
	    }
	}
      if(clipBufRemaining)
	{
	  if(numberInBuffer==0)
	    {
	      dma01_beginp();
	      vif_nop();
	      vif_nop();
	      vif_nop();
	      vif_direct_begin();

	      {
		gif_tag(0xe,1,0,0,0);
	    
		gPRMODECONT(1);				// refer to prim attributes
		gCOLCLAMP(1);
		gDTHE(0);				// Dither off
		gCLAMP_1(0);
		gPABE(0);
		//		gTEST_1(0x70000);//zbufon
		if(zteston)
		  {
		    gTEST_2(0x70000);//zbufon
		  }
		else
		  {
		    gTEST_2(0x30000);//zbufoff
		  }
		gPRIM(PRIMtriangle+PRIMtexture+0*PRIMuv+PRIMcontext2);
		//		gRGBAQ(0x3F80000000908060);		// Background RGBA
		gCLAMP_2(0);
		gALPHA_2(0x4c);

	      }
	    }
	  clipBufRemaining--;

	  int clip3=clipBufRemaining+clipBufRemaining+clipBufRemaining;

	  fvec A_=faceList[clip3];
	  fvec B_=faceList[clip3+1];
	  fvec C_=faceList[clip3+2];

	  /*fvec A=A_.x*tA+A_.y*tB+A_.z*tC;
	    fvec B=B_.x*tA+B_.y*tB+B_.z*tC;
	    fvec C=C_.x*tA+C_.y*tB+C_.z*tC;
	  
	    vec Auv;Auv.fv=A_.x*tAuv+A_.y*tBuv+A_.z*tCuv;
	    vec Buv;Buv.fv=B_.x*tAuv+B_.y*tBuv+B_.z*tCuv;
	    vec Cuv;Cuv.fv=C_.x*tAuv+C_.y*tBuv+C_.z*tCuv;
	  */
	  fvec A;A.x=A_.x*tA.x+A_.y*tB.x+A_.z*tC.x;A.y=A_.x*tA.y+A_.y*tB.y+A_.z*tC.y;A.z=A_.x*tA.z+A_.y*tB.z+A_.z*tC.z;
	  fvec B;B.x=B_.x*tA.x+B_.y*tB.x+B_.z*tC.x;B.y=B_.x*tA.y+B_.y*tB.y+B_.z*tC.y;B.z=B_.x*tA.z+B_.y*tB.z+B_.z*tC.z;
	  fvec C;C.x=C_.x*tA.x+C_.y*tB.x+C_.z*tC.x;C.y=C_.x*tA.y+C_.y*tB.y+C_.z*tC.y;C.z=C_.x*tA.z+C_.y*tB.z+C_.z*tC.z;
	  
	  vec Auv;Auv.fv.x=A_.x*tAuv.x+A_.y*tBuv.x+A_.z*tCuv.x;Auv.fv.y=A_.x*tAuv.y+A_.y*tBuv.y+A_.z*tCuv.y;Auv.fv.z=A_.x*tAuv.z+A_.y*tBuv.z+A_.z*tCuv.z;
	  vec Buv;Buv.fv.x=B_.x*tAuv.x+B_.y*tBuv.x+B_.z*tCuv.x;Buv.fv.y=B_.x*tAuv.y+B_.y*tBuv.y+B_.z*tCuv.y;Buv.fv.z=B_.x*tAuv.z+B_.y*tBuv.z+B_.z*tCuv.z;
	  vec Cuv;Cuv.fv.x=C_.x*tAuv.x+C_.y*tBuv.x+C_.z*tCuv.x;Cuv.fv.y=C_.x*tAuv.y+C_.y*tBuv.y+C_.z*tCuv.y;Cuv.fv.z=C_.x*tAuv.z+C_.y*tBuv.z+C_.z*tCuv.z;
	  
	  {
	    float invAz=1.0f/A.z;
	    int x1=(int)(A.x*invAz*scaleX+offsetX);
	    int y1=(int)(A.y*invAz*scaleY+offsetY);
	    int z1=(int)(ZBUF_MULTIPLIER*invAz);

	    float invBz=1.0f/B.z;
	    int x2=(int)(B.x*invBz*scaleX+offsetX);
	    int y2=(int)(B.y*invBz*scaleY+offsetY);
	    int z2=(int)(ZBUF_MULTIPLIER*invBz);
			      
	    float invCz=1.0f/C.z;
	    int x3=(int)(C.x*invCz*scaleX+offsetX);
	    int y3=(int)(C.y*invCz*scaleY+offsetY);
	    int z3=(int)(ZBUF_MULTIPLIER*invCz);

	    float z;
	    int q;

	    z=invAz;
	    q=*((int*)&z);
	    Auv.fv.x*=z;
	    Auv.fv.y*=z;
	    gRGBAQ(wwd(color,q));
	    gST(Auv.i128.lo);
	    gXYZ2(wwd(hhw(x1,y1),z1));

	    z=invBz;
	    q=*((int*)&z);
	    Buv.fv.x*=z;
	    Buv.fv.y*=z;
	    gRGBAQ(wwd(color,q));
	    gST(Buv.i128.lo);
	    gXYZ2(wwd(hhw(x2,y2),z2));

	    z=invCz;
	    q=*((int*)&z);
	    Cuv.fv.x*=z;
	    Cuv.fv.y*=z;
	    gRGBAQ(wwd(color,q));
	    gST(Cuv.i128.lo);
	    gXYZ2(wwd(hhw(x3,y3),z3));
	  }
	  numberInBuffer++;
	}
      if(numberInBuffer==maxfac)
	{
	  gif_endfinal();
	  vif_direct_end();
	  dma01_endp();
	  numberInBuffer=0;
	}
    }
  if(numberInBuffer!=0)
    {
      gif_endfinal();
      vif_direct_end();
      dma01_endp();
      numberInBuffer=0;
    }
}

void mesh::draw_zclip(fmatrix *m)
{
  // the screen matrix has not been applied to m yet???

  int maxfac=100;
  gif_env;
  //using vif
  
  //	static fvec tlist[240];
  static fvec tlist[2400];
  
  transformf(m,vlist,tlist,nvec);
  
  //  for(int i=0;i<nvec;i++)printf("%i %i %i %i\n",i,tlist[i].x,tlist[i].y,tlist[i].z);

  //	if(nfac>1500)nfac=1500;
  
  int j=0;
  int clipBufRemaining=0;
  int numberInBuffer=0;
  fvec *faceList=0;
  int color=0;
  while(j<nfac || clipBufRemaining!=0)
    {
      if(clipBufRemaining==0)
	{
	  int a=flist[j].a;
	  int b=flist[j].b;
	  int c=flist[j].c;
	  color=flist[j].col;
	  j++;

	  if(tlist[a].x*(tlist[b].y*tlist[c].z-tlist[c].y*tlist[b].z)
	     -tlist[a].y*(tlist[b].x*tlist[c].z-tlist[c].x*tlist[b].z)
	     +tlist[a].z*(tlist[b].x*tlist[c].y-tlist[c].x*tlist[b].y)>0)
	    frustumClip(tlist[a], tlist[b], tlist[c], clipBufRemaining , faceList);
	}
      if(clipBufRemaining)
	{
	  if(numberInBuffer==0)
	    {
	      dma01_beginp();
	      vif_nop();
	      vif_nop();
	      vif_nop();
	      vif_direct_begin();

	      {
		gif_tag(0xe,1,0,0,0);
	    
		gPRMODECONT(1);				// refer to prim attributes
		gCOLCLAMP(1);
		gDTHE(0);				// Dither off
		gCLAMP_2(0);
		gPABE(0);
		gTEST_2(0x70000);//zbufon
		gPRIM(PRIMtriangle+0*PRIMtexture+PRIMuv+PRIMcontext2);
		//		gRGBAQ(0x3F80000000908060);		// Background RGBA

	      }
	    }
	  clipBufRemaining--;
	  fvec A=faceList[clipBufRemaining*3];
	  fvec B=faceList[clipBufRemaining*3+1];
	  fvec C=faceList[clipBufRemaining*3+2];
	  {
	    int x1=(int)(A.x/A.z*320*16)+32000+320*16;
	    int y1=(int)(A.y/A.z*128*16)+32000+128*16;
	    int z1=(int)(25000/A.z);
	    //	    int z1=40000-(int)(A.z);
	    int t1=0;//uv mapping

	    int x2=(int)(B.x/B.z*320*16)+32000+320*16;
	    int y2=(int)(B.y/B.z*128*16)+32000+128*16;
	    int z2=(int)(25000/B.z);
	    //	    int z2=40000-(int)(B.z);
	    int t2=0;
			      
	    int x3=(int)(C.x/C.z*320*16)+32000+320*16;
	    int y3=(int)(C.y/C.z*128*16)+32000+128*16;
	    int z3=(int)(25000/C.z);
	    //	    int z3=40000-(int)(C.z);
	    int t3=0;

	    t1=hhw(0,0);
	    t2=hhw(255*16,0);
	    t3=hhw(0,255*16);
			      
	    gUV(t1);
	    gXYZ2(wwd(hhw(x1,y1),z1));
	    gUV(t2);
	    gXYZ2(wwd(hhw(x2,y2),z2));
	    gRGBAQ(0x3F80000000000000+color);		// Background RGBA
	    gUV(t3);
	    gXYZ2(wwd(hhw(x3,y3),z3));
	  }
	  numberInBuffer++;
	}
      if(numberInBuffer==maxfac)
	{
	  gif_endfinal();
	  vif_direct_end();
	  dma01_endp();
	  numberInBuffer=0;
	}
    }
  if(numberInBuffer!=0)
    {
      gif_endfinal();
      vif_direct_end();
      dma01_endp();
      numberInBuffer=0;
    }
}

void mesh::setupvif()
{
  gif_env;

  mesh_e_giftag_texture.hi=0x5e5e5e;
  mesh_e_giftag_textureflat.hi=0x51e5e5e;

  mesh_e_giftag_texture.lo=0x6189c00000008000;	//--normal context2 noalpha triangle
  mesh_e_giftag_textureflat.lo=0x7000000000008000+GTP(PRIMtexture+PRIMcontext2+PRIMuv+PRIMtriangle+0*PRIMfog);	//--normal context2 noalpha triangle  use fog
  uploadvucode(&mesh_vucodebegin,&mesh_vucodeend);

  dma01_beginp();

  vif_flusha();
  vif_nop();
  vif_base(0);
  vif_offset(0);

  vif_stcycl(0x101);
  vif_stmask(0);
  vif_unpack(((char*)&mesh_vudataend-(char*)&mesh_vudatabegin)>>4,0);
  dma01_endp();

  dma01_ref(&mesh_vudatabegin,&mesh_vudataend);

  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();

  {
    gif_tag(0xe,1,0,0,0);
    gPRMODECONT(1);
    gCOLCLAMP(1);
    gPABE(0);
    gDTHE(0);
    gTEST_2(0x70000);
    gALPHA_2(0x8000000068);
    gALPHA_2(0x8000000048);
    gRGBAQ(0x3F80000000808080);		// Background RGBA
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();
}

void mesh::vudataalloc(int n)
{
  vudata=(int128*)malloc(n*sizeof(int128));
  myassert(vudata);
}

void mesh::buildvudata()
{
  int index=0;
  int fac=nfac;
  int mfac=35;
  
  int128 *dma01_chainnext=vudata;	//local chainnext!!!!!!!!!!!
  
  while(fac>0)
    {
      int nf=fac;
      if(nf>mfac)nf=mfac;
      
      
      if(nf>0)
	{
	  dma01_beginp();
	  vif_nop();
	  vif_nop();
	  
	  int listlength=3*nf;
	  {
	    ivec n;
	    n.x=nf;
	    
	    vif_nop();
	    vif_unpack(listlength+1,0+0x8000);
	    vif_128(((int128*)&n)[0]);
	    
	    dma01_endp();
	    dma01_ref((vlist+index),(vlist+listlength+index));
	    dma01_beginp();
	    
	    vif_mscal(0x0);
	    vif_nop();
	  }
	  vif_nop();
	  vif_nop();
	  dma01_endp();
	}
      index+=nf*3;
      fac-=nf;
    }
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_nop();
  dma01_endpret();
}

void mesh::draw_vu(fmatrix *m, fmatrix *m2)
{
  static int flip;
  int maxfac=100;
  gif_env;
  //using vu
  
  //	setupvif(); done elsewhere
  
  int index=0;
  int fac=nfac;
  int mfac=30;
  
  fmatrix M2;
  if(!m2)
    {
      resetmatrixf(&M2);
      m2=&M2;
    }
  
  fmatrix &mat=*m;
  mat.dummy1=0;
  mat.dummy2=0;
  mat.dummy3=0;
  mat.dummy4=-128*16*500000*2.2;
  dma01_beginp();
  vif_flusha();
  vif_flushe();
  
  {
    vif_nop();

    vif_unpack(7,0+0x000);
    
    vif_128(((int128*)&mat)[0]);
    vif_128(((int128*)&mat)[1]);
    vif_128(((int128*)&mat)[2]);
    vif_128(((int128*)&mat)[3]);
    
    vif_128(((int128*)m2)[0]);
    vif_128(((int128*)m2)[1]);
    vif_128(((int128*)m2)[2]);

    vif_nop();
    vif_nop();
  }
  vif_base(16);
  vif_offset(40*6);
  dma01_endpcall(vudata);
}




/* 3ds files */

class dschunk
{
  int l,endpos;
  class dsfile  *f;
public:
  int id;
  dschunk(dsfile* f);
  void end();
  void print();
  void print(char *s);
  int in();
};

class dsfile
{
  //   FFILE *f;
  char *f;
public:
  int pos;
  dsfile(char *filename);
  //  ~dsfile();
  float readfloat();
  int readdword();
  int readword();
  int readbyte();
  void readstring(char *string);
};

dschunk::dschunk(dsfile* f)
{
  this->f=f;
  
  id=f->readword();
  l=f->readdword();
  endpos=l+f->pos-6;
}

void dschunk::end()
{
  while(f->pos<endpos)f->readbyte();
}

void dschunk::print()
{
  //	printf("CHUNK: id:%x length:%i endpos:%i\n",id,l,endpos);
}

void dschunk::print(char *s)
{
  //	printf("%s",s);
  //	print();
}

int dschunk::in()
{
  return (endpos>f->pos);
}



dsfile::dsfile(char *file)
{
  f=file;
  //	myassert(f=ffopen(filename,"rb"));
  //	f=fopen(filename,"rb");
  //	assert(f);
  pos=0;
}
/*
  dsfile::~dsfile()
  {
  //	ffclose(f);
  }

*/

int dsfile::readbyte()
{
  unsigned char c;
  
  c=f[pos];
  pos++;
  
  return c;
}

int dsfile::readword()
{
  int a=readbyte();
  int b=readbyte();
  return 256*b+a;
}

int dsfile::readdword()
{
  int a=readword();
  int b=readword();
  return 65536*b+a;
}

float dsfile::readfloat()
{
  float c;
  
  *((int*)&c)=readdword(); //???
  return c;
}


void dsfile::readstring(char *string)
{
  int i=0;
  
  do
    {
      string[i]=(char)readbyte();
      i++;
    }
  while(string[i-1]);
}





void mesh::load(char *filep, char *objectname, float uscale, float vscale)
{
  // uscale=vscale=1 for 256x256 texture
  bool objectFound=false;
  char	objectname2[32];
  dsfile file(filep);
  dschunk level0(&file);
  
  printf("Loading 3ds file\n");
  
  while(level0.in())
    {
      dschunk level1(&file);
      
      switch (level1.id)
	{
	case 0x3d3d:
	  while(level1.in())
	    {
	      dschunk level2(&file);
	      
	      switch(level2.id)
		{
		case 0x4000:
		  file.readstring(objectname2);
		  printf("Found object: %s\n",objectname2);
		  if(!strcmp(objectname2,objectname))
		    while(level2.in())
		      {
			objectFound=true;
			dschunk level3(&file);
			
			switch(level3.id)
			  {
			  case 0x4100:   //Trimesh
			    while(level3.in())
			      {
				dschunk level4(&file);
				
				switch(level4.id)
				  {
				  case 0x4110: /*vertexlist*/
				    
				    printf("Reading coordinates\n",2);
				    //maxver=
				    nvec=file.readword();
				    printf("Number of vertices:   %i\n",nvec);
				    //				vlist=new vertex[maxver];
				    vlist=(fvec*)malloc(nvec*sizeof(fvec));
				    myassert(vlist);
				    //	uvlist=new uvcoords[maxver];
				    int t;
				    for(t=0;t<nvec;t++)
				      {
					vlist[t].x=file.readfloat();
					vlist[t].z=file.readfloat(); //Her byttes om p y og z
					vlist[t].y=file.readfloat();
				      }
				    break;
				  case 0x4120: /*facelist*/
				    
				    nfac=file.readword();
				    printf("Number of faces: \n",nfac);
				    
				    printf("Loading 3d object, name:%s , nver: %i , nfac: %i\n",objectname,nvec,nfac);
				    
				    flist=(face*)malloc(nfac*sizeof(face));
				    myassert(flist);
				    for(t=0;t<nfac;t++)
				      {
					flist[t].a=file.readword();
					flist[t].b=file.readword();
					flist[t].c=file.readword();
					flist[t].col=rgb(128,128,128);
					//flist[t].col=0x80808080;
					//flist[t].col=t*rgb(40,80,120);
					file.readword();
					//		facelist[t].material=0;
				      }
				    while(level4.in())
				      {
					dschunk level5(&file);
					
					switch(level5.id)
					  {
					  case 0x4130: //materiallist
					    {
					      char	  matn[20];
					      int	  nummatfac;//,facnum;
					      
					      file.readstring(matn);
					      nummatfac=file.readword();
					    }
					    break;
					  case 0x4150:	//smoothinggroups
					    break;
					  }
					level5.end();
				      }
				    
				    break;
				  case 0x4140:  //mappingcoordinates  //antag et punkter er indlst
				    { int nver2;
				    printf("Reading mapping coordinates\n");
				    nver2=file.readword();
				    for(t=0;t<nver2;t++)
				      {
					float u=file.readfloat();
					float v=file.readfloat();
					/*					int U=((int)(16*512*(u)))&(65535);
										int V=((int)(16*512*(1-v)))&(65535);
					*/
					int U=((int)(uscale*16*256*(u)))&(65535);
					int V=((int)(vscale*16*256*(1-v)))&(65535);
					((ivec*)vlist)[t].w=(V<<16)+U;
					//			((ivec*)vlist)[t].w=t*0x00200030;
					//					uvlist[t].u=file.readfloat();
					//					uvlist[t].v=-file.readfloat();
				      }
				    }
				    
				    break;
				  }
				level4.end();
			      }
			    break;
			  }
			level3.end();
		      }
		  break;
		}
	      level2.end();
	    }
	  break;
	}
      level1.end();
    }
  level0.end();
  myassert(objectFound);
}


void mesh::planeclip(mesh &source, fvec p)
{
  nvec=0;
  nfac=0;
	
  for(int t=0;t<source.nfac;t++)
    {
      fvec a=source.vlist[source.flist[t].a];
      fvec b=source.vlist[source.flist[t].b];
      fvec c=source.vlist[source.flist[t].c];
      fvec temp,t1,t2;
#define DOT(p,a) (p.x*a.x+p.y*a.y+p.z*a.z+p.w)
#define SWAP(a,b){temp=a;a=b;b=temp;}
#define PUSH(a,b,c){flist[nfac++]=face(nvec,nvec+1,nvec+2,0x808080);vlist[nvec++]=a;vlist[nvec++]=b;vlist[nvec++]=c;}
#define INTERSECT(t,a,b){float A1=DOT(p,a);float B1=DOT(p,b);float A=-A1/(-A1+B1);float B=B1/(-A1+B1);t=B*a+A*b;int auv=((ivec*)&a)->w;int buv=((ivec*)&b)->w;((ivec*)(&t))->w=(int)((B*(auv&65535)+A*(buv&65535)))+((int)((B*(auv>>16)+A*(buv>>16)))<<16);}
      if(DOT(p,b)<0)SWAP(b,c)
	if(DOT(p,a)<0)SWAP(a,b)
	  if(DOT(p,b)<0)SWAP(b,c)
	  // DOT(p,a)<0 => DOT(p,b)<0 => DOT(p,c)<0
	    if(DOT(p,a)<0)
	      {
		// draw nothing
	      }
	    else if(DOT(p,b)<0)
	      {
		// draw single triangle
		INTERSECT(t1,a,b);
		INTERSECT(t2,a,c);
		PUSH(a,t1,t2);
	      }
	    else if(DOT(p,c)<0)
	      {
		// draw two triangles
		INTERSECT(t1,a,c);
		INTERSECT(t2,b,c);
		PUSH(a,b,t1);
		PUSH(b,t2,t1);
	      }
	    else
	      {
		// draw the triangle
		PUSH(a,b,c)
	      }
    }
}


void mesh::removeFaceList()
{
  fvec *vlist2;

  vlist2=(fvec*)malloc(sizeof(fvec)*nfac*3);
  myassert(vlist2);

  for(int i=0;i<nfac;i++)
    {
      ((ivec*)vlist2)[i*3]=((ivec*)vlist)[flist[i].a];
      ((ivec*)vlist2)[i*3+1]=((ivec*)vlist)[flist[i].b];
      ((ivec*)vlist2)[i*3+2]=((ivec*)vlist)[flist[i].c];
    }

  vlist=vlist2;
  nvec=nfac*3;
}
