#ifndef __HWREG_
#define __HWREG_

#include "types.h"

#define DMA_ ((volatile unsigned int*)0x1000E000)
#define DMA02 ((volatile unsigned int*)0x1000A000)

#define D2_CHCR *((volatile unsigned int*)0x1000A000)
#define D2_MADR *((volatile unsigned int*)0x1000A010)
#define D2_QWC *((volatile unsigned int*)0x1000A020)
#define D2_TADR *((volatile unsigned int*)0x1000A030)

#define DMA01 ((volatile unsigned int*)0x10009000)

#define D1_CHCR *((volatile unsigned int*)0x10009000)
#define D1_MADR *((volatile unsigned int*)0x10009010)
#define D1_QWC *((volatile unsigned int*)0x10009020)
#define D1_TADR *((volatile unsigned int*)0x10009030)

#define GIF_ ((volatile unsigned long*)0x12000000)
#define GIF_vsyncreg *((volatile unsigned long*)0x12001000)
#define GIF_CSR GIF_vsyncreg
#define GIF_IMR *((volatile unsigned long*)0x12001010)
#define GIF_BUSDIR *((volatile unsigned long*)0x12001040)

#define vu0_mem ((volatile vec*)0x11004000)
#define vu0_micromem ((volatile vec*)0x11000000)
#define vu1_mem ((volatile vec*)0x1100c000)
#define vu1_micromem ((volatile vec*)0x11008000)

//#define VIF1_STAT *((volatile unsigned long*)0x10003c00)
#define VIF1_STAT *((volatile unsigned int*)0x10003c00)



/* */
#define PRIMpoint 0
#define PRIMline 1
#define PRIMlinestrip 2
#define PRIMtriangle 3
#define PRIMtrianglestrip 4
#define PRIMtrianglefan 5
#define PRIMsprite 6

#define PRIMgouraud 8
#define PRIMtexture 16
#define PRIMfog 32
#define PRIMalpha 64
#define PRIMantialiasing 128
#define PRIMuv 256
#define PRIMcontext2 512
#define PRIMfragmentvalue 1024

#define GTP(a) (((int64)(a)<<47)+(((int64)1)<<46))


#endif
