/* GLOW EFFECTS */
/* SoopaDoopa 2002 */

#include "glow.h"
#include "myassert.h"

static texture scr8;

texture glow_zbuf;

static void setcurrent(texture *screen, int interlace)
{
  gif_env;
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  vif_direct_end_(screen->dmalistframe1(interlace,(int128*)dma01_currentpos));
  dma01_endp();
}

void glow_init()
{
  scr8.init();
  scr8.width=640;
  scr8.height=256;
  scr8.bitsperpixel=8;
  scr8.allocclut();
  scr8.memallocclut();
  for(int t=0;t<256;t++)scr8.clut[t]=rgb(t,t,t);
  scr8.uploadclut();
}

void glow_deinit()
{
}

void glow_extractalpha(texture *source, texture *dest)
{
  gif_env;
  
  scr8.addr=source->addr;
  
  dma01_beginp();
  vif_flusha();
  vif_nop();
  vif_nop();
  vif_nop();
  dma01_endp();
  
  setcurrent(dest,0);

  dma01_beginp();
  vif_flushe();
  vif_flusha();
  vif_nop();
  vif_direct_begin();
  
  {
    int x2=source->width*16,y2=source->height*16;
    
    gif_tag(0xe,1,0,0,0);
    gTEST_1(0x30000);
    gTEX0_1(scr8.TEX0()+1*(8<<20));
    gTEX1_1(1<<5);
    gPRIM(0x116);
    gRGBAQ(0x3F80000000808080);
    gUV(hhw(0,0));
    gXYZ2(hhw(32000,32000));
    gUV(hhw(x2,y2));
    gXYZ2(hhw(32000+x2,32000+y2));
    gTEST_1(0x70000);
    gTEXFLUSH();
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();
}


void glow_copy(texture *source, texture *dest)
{
  gif_env;
  
  dma01_beginp();
  vif_flusha();
  vif_nop();
  vif_nop();
  vif_nop();
  dma01_endp();
  
  setcurrent(dest,0);
  
  dma01_beginp();
  vif_flushe();
  vif_flusha();
  vif_nop();
  vif_direct_begin();
  
  {
    int x2=source->width*16,y2=source->height*16;
    
    gif_tag(0xe,1,0,0,0);
    gZBUF_1(0x100000000);
    gTEST_1(0x30000);
    gTEX0_1(source->TEX0());
    gTEX1_1(1<<5);
    gPRIM(0x116);
    gRGBAQ(0x3F80000000808080);
    gUV(hhw(0,0));
    gXYZ2(hhw(32000,32000));
    gUV(hhw(x2,y2));
    gXYZ2(hhw(32000+x2,32000+y2));
    gTEST_1(0x70000);
    gTEXFLUSH();
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();
}


void glow_singleblur(texture *source, texture *dest, float u1, float v1, float u2, float v2, int a1, int a2)
{
  // a1 og a2 ligger mellem 0 og 255
  // dest= (source *a1 + dest*a2)>>7
  
  u1+=0.5;
  v1+=0.5;
  u2+=0.5;
  v2+=0.5;
  
  v1*=4;
  v2*=4;
  int u1f=*((int*)(&u1));
  int v1f=*((int*)(&v1));
  int u2f=*((int*)(&u2));
  int v2f=*((int*)(&v2));
  float q=1024;
  int qf=*((int*)(&q));
  gif_env;
  
  setcurrent(dest,0);

  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    int x2=source->width*16,y2=source->height*16;
    
    gif_tag(0xe,1,0,0,0);
    gZBUF_1(0x100000000);
    gTEST_1(0x30000);
    gTEX0_1(source->TEX0()+0*(8<<20));
    gTEX1_1(1<<5);
    gPRIM(0x56);
    gALPHA_1(0x0000000029+(((int64)a2)<<32));
    gRGBAQ(wwd(rgb(a1,a1,a1),qf));
    gST(wwd(u1f,v1f));
    gXYZ2(hhw(32000,32000));
    gST(wwd(u2f,v2f));
    gXYZ2(hhw(32000+x2,32000+y2));
    
    gTEST_1(0x70000);
    gif_endfinal();
  }
  vif_direct_end();
  
  dma01_endp();
}


void glow_gaussianblur(texture *source, texture *temp, texture *dest, int n);

void glow_radialblur(texture *source, texture *dest, float cx, float cy, float v, int n, int mix1, int mix2)
{
  // source og dest skal have ens image data
  // passende vrdi for v er 0.5
  // mix1=mix2=64 giver blur uden forgelse af styrke
  
  float scale=v;
  
  for(int t=0;t<n;t++)
    {
      float x1,y1,x2,y2;
      
      x1=scale*(-cx);
      y1=scale*(-cy);
      x2=scale*(source->width-cx);
      y2=scale*(source->height-cy);
      glow_singleblur(dest,source,	cx+x1,cy+y1,cx+x2,cy+y2,mix1,mix2);
      
      scale=sqrt(scale)*sqrt(sqrt(scale));
      
      
      x1=scale*(-cx);
      y1=scale*(-cy);
      x2=scale*(source->width-cx);
      y2=scale*(source->height-cy);
      glow_singleblur(source,dest,	cx+x1,cy+y1,cx+x2,cy+y2,mix1,mix2);

      scale=sqrt(scale)*sqrt(sqrt(scale));
    }
}


void glow_directionalblur(texture *source, texture *temp, texture *dest, float dx, float dy, int n);

void glow_blend(texture *source, texture *dest, int sourceMultiplier, int destMultiplier)
{
  gif_env;

  setcurrent(dest,0);
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    int x2=source->width*16,y2=source->height*16;
    
    gif_tag(0xe,1,0,0,0);
    gZBUF_1(0x100000000);
    gTEST_1(0x30000);
    gTEX0_1(source->TEX0()+0*(8<<20));
    gTEX1_1(1<<5);
    gPRIM(0x156);
    gALPHA_1(0x00000029+(int64(destMultiplier)<<31));
    gRGBAQ(0x3F80000000000000+rgb(sourceMultiplier/2,sourceMultiplier/2,sourceMultiplier/2));
    gUV(hhw(0,0));
    gXYZ2(hhw(32000,32000));
    gUV(hhw(x2,y2));
    gXYZ2(hhw(32000+x2,32000+y2));
    
    gTEST_1(0x70000);
    gif_endfinal();
  }
  vif_direct_end();
  
  dma01_endp();
}


void glow_computealpha(texture *t)
{
  int height=t->height;
  int width=t->width;
  int *image=t->image;

  if(t->bitsperpixel!=32)
    {
      myassert(t->clut);
      image=t->clut;
      height=1;
      width=256;
    }

  for(int y=0;y<height;y++)
    for(int x=0;x<width;x++)
      {
	float r=image[y*t->width+x]&255;
	float g=(image[y*t->width+x]>>8)&255;
	float b=(image[y*t->width+x]>>16)&255;
	
	r/=256;
	g/=256;
	b/=256;
	    
	image[y*t->width+x]&=0xffffff;
	image[y*t->width+x]|=((int)((r*r*r*r+g*g*g*g+b*b*b*b)*(255.0/3)))<<24;
      }
}


void glow_borrowzbuf(texture *screen)
{
  glow_zbuf.init();
  glow_zbuf.width=screen->width;
  glow_zbuf.height=screen->height;
  glow_zbuf.bitsperpixel=32;
  glow_zbuf.addr=screen->zbufaddr;
}
