/* SUPERBONBON */
/* SoopaDoopa 2002 */

#include "bonbon.h"

#include <kernel.h>
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"
#include "glow.h"
#include "timing.h"
#include "mesh.h"

static int SPLITS;

extern unsigned int bonbon_vucodebegin  __attribute__((section(".vudata")));
extern unsigned int bonbon_vucodeend  __attribute__((section(".vudata")));
extern unsigned int bonbon_vudatabegin  __attribute__((section(".vudata")));
extern unsigned int bonbon_vudataend  __attribute__((section(".vudata")));

extern int128 bonbon_e_giftag   __attribute__((section(".vudata")));

extern char binary_phong_start[];
extern char binary_obj01_start[];

extern int PAL;

static texture *tempscreen;
static texture *screen;
static int iframe;
static float frames;

static texture tex1;

static float ypos;

static fvec ver2(float x, float y, float z, float w)
{
  fvec v;
  
  v.x=x;
  v.y=y;
  v.z=z;
  v.w=w;
  
  return v;
}


static void setupvif()
{
  gif_env;
  
  uploadvucode(&bonbon_vucodebegin,&bonbon_vucodeend);
  
  bonbon_e_giftag.hi=0x53;
  bonbon_e_giftag.lo=0x200000000000800d+GTP(PRIMtrianglestrip+PRIMcontext2+PRIMtexture+PRIMuv);
  //  bonbon_e_giftag.lo=0x208a40000000800d;
  
  uploadvudata((char*)&bonbon_vudatabegin,(char*)&bonbon_vudataend);
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    gPRMODECONT(1);			// refer to prim attributes
    gCOLCLAMP(1);
    gPABE(0);
    gDTHE(0);				// Dither off
    gTEST_2(0x70000);
    gALPHA_2(0x8000000068);
    gALPHA_2(0x8000000048);
    gTEX0_2(tex1.TEX0()+((int64)0<<35));
    gTEX1_2(1<<5);			// Bilinear
    gRGBAQ(0x3F80000000808080);
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();
}


static void calltriangle(fvec *a, fvec *b, fvec *c, int s=0)
{
  float div=SPLITS;
  
  if(s)
    {
      fvec *t=a;
      a=b;
      b=t;
    }
  
  fvec d1=(1/div)*(*b-*a);
  fvec d2=(1/div)*(*c-*a);
  fvec A=*a-d1-d2;
  
  dma01_beginp();
  vif_flusha();
  vif_nop();
  {
    vif_nop();
    vif_unpack(3,0+0x8009);
    
    vif_128(((int128*)&A)[0]);
    vif_128(((int128*)&d1)[0]);
    vif_128(((int128*)&d2)[0]);
    
    vif_mscal(0x0);
    vif_nop();
  }
  vif_nop();
  vif_nop();
  dma01_endp();
}


static void calltriangle2(fvec *a, fvec *b, fvec *c, int s=0)
{
  if(s)
    {
      fvec *t=a;
      a=b;
      b=t;
    }
  
  fvec A=0.5*(*b+*c);
  fvec B=0.5*(*a+*c);
  fvec C=0.5*(*b+*a);
  
  calltriangle(a,&C,&B);
  calltriangle(&C,&A,&B);
  calltriangle(c,&B,&A);
  calltriangle(b,&A,&C);
}


typedef struct setting
{
  fvec v[8];
  float amul[8];
  float weight[8];
}setting;


setting getsetting(int num)
{
  setting s;
  num&=7;
  switch(num)
    {
    case 0:
      s.v[0]=ver2(10,0,0,20);		s.amul[0]=1;	s.weight[0]=0.1;
      s.v[1]=ver2(0,3,0,20);		s.amul[1]=3;	s.weight[1]=0.3;
      s.v[2]=ver2(0,0,10,20);		s.amul[2]=3;	s.weight[2]=0.0;
      s.v[3]=ver2(10,0,0,20);		s.amul[3]=3;	s.weight[3]=0.0;
      s.v[4]=ver2(1,0,0,20);		s.amul[4]=3;	s.weight[4]=0.0;
      s.v[5]=ver2(0,1,0,20);		s.amul[5]=3;	s.weight[5]=0.0;
      s.v[6]=ver2(0,0,1,20);		s.amul[6]=3;	s.weight[6]=0.0;
      s.v[7]=ver2(0.5,0.5,0.5,20);	s.amul[7]=3;	s.weight[7]=0.0;
      break;
    case 1:
      s.v[0]=ver2(1,0,0,20);		s.amul[0]=1;	s.weight[0]=0.0;
      s.v[1]=ver2(0,10,0,20);		s.amul[1]=3;	s.weight[1]=0.03;
      s.v[2]=ver2(0,0,10,20);		s.amul[2]=3;	s.weight[2]=0.03;
      s.v[3]=ver2(10,0,0,20);		s.amul[3]=3;	s.weight[3]=0.03;
      s.v[4]=ver2(1,0,0,20);		s.amul[4]=3;	s.weight[4]=0.0;
      s.v[5]=ver2(0,1,0,20);		s.amul[5]=3;	s.weight[5]=0.0;
      s.v[6]=ver2(0,0,1,20);		s.amul[6]=3;	s.weight[6]=0.0;
      s.v[7]=ver2(0.5,0.5,0.5,20);	s.amul[7]=3;	s.weight[7]=0.0;
      break;
    case 2:
      s.v[0]=ver2(1,0,0,20);		s.amul[0]=1;	s.weight[0]=0.0;
      s.v[1]=ver2(0,1,0,20);		s.amul[1]=3;	s.weight[1]=0.03;
      s.v[2]=ver2(0,0,1,20);		s.amul[2]=3;	s.weight[2]=0.03;
      s.v[3]=ver2(10,0,0,20);		s.amul[3]=3;	s.weight[3]=0.03;
      s.v[4]=ver2(1,0,0,20);		s.amul[4]=3;	s.weight[4]=0.0;
      s.v[5]=ver2(0,1,0,20);		s.amul[5]=3;	s.weight[5]=0.0;
      s.v[6]=ver2(0,0,1,20);		s.amul[6]=3;	s.weight[6]=0.0;
      s.v[7]=ver2(0.5,0.5,0.5,20);	s.amul[7]=3;	s.weight[7]=0.0;
      break;
    case 3:
      s.v[0]=ver2(1,0,0,20);		s.amul[0]=1;	s.weight[0]=0.0;
      s.v[1]=ver2(0,10,0,20);		s.amul[1]=3;	s.weight[1]=0.03;
      s.v[2]=ver2(0,0,10,20);		s.amul[2]=3;	s.weight[2]=0.03;
      s.v[3]=ver2(10,0,0,20);		s.amul[3]=3;	s.weight[3]=0.03;
      s.v[4]=ver2(1,0,0,20);		s.amul[4]=3;	s.weight[4]=0.3;
      s.v[5]=ver2(0,1,0,20);		s.amul[5]=3;	s.weight[5]=0.4;
      s.v[6]=ver2(0,0,1,20);		s.amul[6]=3;	s.weight[6]=0.2;
      s.v[7]=ver2(0.5,0.5,0.5,20);	s.amul[7]=3;	s.weight[7]=0.2;
      break;
    case 4:
      s.v[0]=ver2(1,0,0,20);		s.amul[0]=1;	s.weight[0]=0.1;
      s.v[1]=ver2(0,1,0,20);		s.amul[1]=3;	s.weight[1]=0.1;
      s.v[2]=ver2(0,0,1,20);		s.amul[2]=3;	s.weight[2]=0.1;
      s.v[3]=ver2(0.5,0.5,0,20);	s.amul[3]=3;	s.weight[3]=0.1;
      s.v[4]=ver2(0,0.5,0.5,20);	s.amul[4]=3;	s.weight[4]=0.1;
      s.v[5]=ver2(0.5,0,0.5,20);	s.amul[5]=3;	s.weight[5]=0.1;
      s.v[6]=ver2(-1,0,0,20);		s.amul[6]=3;	s.weight[6]=0.1;
      s.v[7]=ver2(0,-1,0,20);		s.amul[7]=3;	s.weight[7]=0.1;
      break;
    case 5:
      s.v[0]=ver2(1,0,0,20);		s.amul[0]=1;	s.weight[0]=0.0;
      s.v[1]=ver2(0,1,0,20);		s.amul[1]=3;	s.weight[1]=0.03;
      s.v[2]=ver2(0,0,1,20);		s.amul[2]=3;	s.weight[2]=0.03;
      s.v[3]=ver2(10,0,0,20);		s.amul[3]=3;	s.weight[3]=0.03;
      s.v[4]=ver2(1,0,0,20);		s.amul[4]=3;	s.weight[4]=0.0;
      s.v[5]=ver2(0,1,0,20);		s.amul[5]=3;	s.weight[5]=0.0;
      s.v[6]=ver2(0,0,1,20);		s.amul[6]=3;	s.weight[6]=0.0;
      s.v[7]=ver2(0.5,0.5,0.5,20);	s.amul[7]=3;	s.weight[7]=0.0;
      break;
    case 6:
      s.v[0]=ver2(1,0,0,20);		s.amul[0]=1;	s.weight[0]=0.0;
      s.v[1]=ver2(0,10,0,20);		s.amul[1]=3;	s.weight[1]=0.03;
      s.v[2]=ver2(0,0,10,20);		s.amul[2]=3;	s.weight[2]=0.03;
      s.v[3]=ver2(10,0,0,20);		s.amul[3]=3;	s.weight[3]=0.03;
      s.v[4]=ver2(1,0,0,20);		s.amul[4]=3;	s.weight[4]=0.0;
      s.v[5]=ver2(0,1,0,20);		s.amul[5]=3;	s.weight[5]=0.0;
      s.v[6]=ver2(0,0,1,20);		s.amul[6]=3;	s.weight[6]=0.0;
      s.v[7]=ver2(0.5,0.5,0.5,20);	s.amul[7]=3;	s.weight[7]=0.0;
      break;
    case 7:
      s.v[0]=ver2(1,0,0,20);		s.amul[0]=1;	s.weight[0]=0.3;
      s.v[1]=ver2(0,2,0,20);		s.amul[1]=3;	s.weight[1]=0.03;
      s.v[2]=ver2(0,0,0,0.25);		s.amul[2]=3;	s.weight[2]=0.03;
      s.v[3]=ver2(10,0,0,20);		s.amul[3]=3;	s.weight[3]=0.0;
      s.v[4]=ver2(1,0,0,20);		s.amul[4]=3;	s.weight[4]=0.0;
      s.v[5]=ver2(0,1,0,20);		s.amul[5]=3;	s.weight[5]=0.0;
      s.v[6]=ver2(0,0,1,20);		s.amul[6]=3;	s.weight[6]=0.0;
      s.v[7]=ver2(0.5,0.5,0.5,20);	s.amul[7]=3;	s.weight[7]=0.0;
      break;
    }
  
  return s;
}


setting mix(setting a, setting b, float m)
{
  // mix two settings - return a if m==0, b if m==1

  m=0.5-0.5*cos(m*3.141592);
  
  setting c;
  
  for(int t=0;t<8;t++)
    {
      c.v[t]=(1-m)*a.v[t]+m*b.v[t];
      c.amul[t]=(1-m)*a.amul[t]+m*b.amul[t];
      c.weight[t]=(1-m)*a.weight[t]+m*b.weight[t];
    }

  return c;
}


static void bonbon(float frames)
{
  static float angle;
  static int framesAdd;
  static float angle2;
  fmatrix M;
  gif_env;

  angle=0.0005*3*4*(frames+framesAdd);

  {
    static float oldTime11; 
    if(timing::gettime(11)!=oldTime11 && timing::getval2(11)>0)
      {
	angle2+=timing::getval2(11);
      }
    oldTime11=timing::gettime(11);
  }

  setupvif();
  
  //  screen->setcurrent_vif(1-iframe);
  //  screen->clear_vif(0,0);
  
  dma01_beginp();
  vif_nop();
  vif_nop();
  vif_nop();
  vif_direct_begin();
  
  {
    gif_tag(0xe,1,0,0,0);
    gPRMODECONT(1);
    gCOLCLAMP(1);
    gDTHE(0);
    gTEST_2(0x70000);
    gALPHA_2(0x8000000068);
    gTEX0_2(tex1.TEX0()+((int64)0<<35));
    gTEX1_2(1<<5);
    gRGBAQ(0x3F80000080808080);
    gif_endfinal();
  }
  vif_direct_end();
  dma01_endp();

  
  {
    vec light;
    light.fv.x=0;
    light.fv.y=0;
    light.fv.z=-7/16.0;

    resetmatrixf(&M);
    scalematrixf(&M,170*2,170*2,170*2);
    frotatematrixzf(&M,0.3*sin(angle*0.08));
    frotatematrixxf(&M,0.15*sin(angle*0.07)*cos2(angle*0.4));
    frotatematrixyf(&M,0.13*sin(angle*0.08));
    frotatematrixxf(&M,angle);
    frotatematrixyf(&M,angle*0.4);

    rotatematrixyf(&M,angle2);

    scalematrixf(&M,1,320.0/256,1);

    movematrixf(&M,0,100,0);
    movematrixf(&M,0,ypos,900-100*timing::get(1));
    screenmatrixf(&M,640*16,256*16,32000,32000);
    
    fmatrix M2;
    resetmatrixf(&M2);
    frotatematrixzf(&M2,0.3*sin(angle*0.08));
    frotatematrixxf(&M2,0.15*sin(angle*0.07)*cos2(angle*0.4));
    frotatematrixyf(&M2,0.13*sin(angle*0.08));
    frotatematrixxf(&M2,angle);
    frotatematrixyf(&M2,angle*0.4);

    rotatematrixyf(&M2,angle2);
    
    dma01_beginp();
    vif_nop();
    vif_nop();
    
    fvec lightcolor;
    {
      static int num;
      static float v;
      if(timing::getval(20))
	{
	  v+=0.01;
	  num++;
	}
      else
	{
	  //	  framesAdd+=3;
	  angle2+=0.02;
	}
      
      fvec v1,v2,v3,v4;
      fvec v5,v6,v7,v8;
      fvec weight1,weight2;
      fvec t1,t2,t3,t4;
      
      setting s;
      {
	int index=num>>8;
	float m=(num-(index<<8))/256.0;
	s=mix(getsetting(index),getsetting(index+1),m);
      }
      for(int t=0;t<8;t++)s.v[t].w+=s.amul[t]*v;	
      v1=s.v[0];
      v2=s.v[1];
      v3=s.v[2];
      v4=s.v[3];
      v5=s.v[4];
      v6=s.v[5];
      v7=s.v[6];
      v8=s.v[7];
      weight1=ver2(s.weight[0],s.weight[1],s.weight[2],s.weight[3]*(1+0*timing::get(9)));
      weight2=ver2(s.weight[4],s.weight[5],s.weight[6],s.weight[7]);
      

      ivec splits;
			
      splits.x=SPLITS;
      
      lightcolor.x=1;
      lightcolor.y=0.6;
      lightcolor.z=0.5;
      
      vif_nop();
      vif_unpack(22,0+0x8000);
      vif_128(((int128*)&M)[0]);
      vif_128(((int128*)&M)[1]);
      vif_128(((int128*)&M)[2]);
      vif_128(((int128*)&M)[3]);
      
      vif_128(((int128*)&M2)[0]);
      vif_128(((int128*)&M2)[1]);
      vif_128(((int128*)&M2)[2]);
      vif_128(((int128*)&M2)[3]);
      
      vif_128(((int128*)&splits)[0]);
      vif_128(((int128*)&splits)[0]);
      vif_128(((int128*)&splits)[0]);
      vif_128(((int128*)&splits)[0]);
      
      t1=ver2(v1.x,v2.x,v3.x,v4.x);
      t2=ver2(v1.y,v2.y,v3.y,v4.y);
      t3=ver2(v1.z,v2.z,v3.z,v4.z);
      t4=ver2(v1.w,v2.w,v3.w,v4.w);
      
      vif_128(((int128*)&t1)[0]);
      vif_128(((int128*)&t2)[0]);
      vif_128(((int128*)&t3)[0]);
      vif_128(((int128*)&t4)[0]);
      
      t1=ver2(v5.x,v6.x,v7.x,v8.x);
      t2=ver2(v5.y,v6.y,v7.y,v8.y);
      t3=ver2(v5.z,v6.z,v7.z,v8.z);
      t4=ver2(v5.w,v6.w,v7.w,v8.w);
      
      vif_128(((int128*)&t1)[0]);
      vif_128(((int128*)&t2)[0]);
      vif_128(((int128*)&t3)[0]);
      vif_128(((int128*)&t4)[0]);
      
      vif_128(((int128*)&weight1)[0]);
      vif_128(((int128*)&weight2)[0]);
      
      vif_nop();
      vif_nop();
    }
    vif_nop();
    vif_nop();
    dma01_endp();
  }
  
  if(1)
    {
      // use ikasohedron
      static fvec v[12];
      float a=0.618033989;
      v[0]=fvec_(1,0,a,0);
      v[1]=fvec_(1,0,-a,0);
      v[2]=fvec_(-1,0,a,0);
      v[3]=fvec_(-1,0,-a,0);
      v[4]=fvec_(a,1,0,0);
      v[5]=fvec_(-a,1,0,0);
      v[6]=fvec_(a,-1,0,0);
      v[7]=fvec_(-a,-1,0,0);
      v[8]=fvec_(0,a,1,0);
      v[9]=fvec_(0,-a,1,0);
      v[10]=fvec_(0,a,-1,0);
      v[11]=fvec_(0,-a,-1,0);
      
      calltriangle2(v,v+4,v+8);
      calltriangle2(v,v+6,v+9,1);
      calltriangle2(v+1,v+4,v+10,1);
      calltriangle2(v+1,v+6,v+11);
      calltriangle2(v+2,v+5,v+8,1);
      calltriangle2(v+2,v+7,v+9);
      calltriangle2(v+3,v+5,v+10);
      calltriangle2(v+3,v+7,v+11,1);
      
      calltriangle2(v,v+1,v+4);
      calltriangle2(v,v+1,v+6,1);
      calltriangle2(v+2,v+3,v+5,1);
      calltriangle2(v+2,v+3,v+7);
      
      calltriangle2(v+4,v+5,v+8);
      calltriangle2(v+4,v+5,v+10,1);
      calltriangle2(v+6,v+7,v+9,1);
      calltriangle2(v+6,v+7,v+11);
      
      calltriangle2(v+8,v+9,v+0);
      calltriangle2(v+8,v+9,v+2,1);
      calltriangle2(v+10,v+11,v+1,1);
      calltriangle2(v+10,v+11,v+3);
    }
  else
    {
      if(0)
	{
	  // use octahedron
	  static fvec v[6];
	  v[0]=fvec_(1,0,0,0);
	  v[1]=fvec_(-1,0,0,0);
	  v[2]=fvec_(0,1,0,0);
	  v[3]=fvec_(0,-1,0,0);
	  v[4]=fvec_(0,0,1,0);
	  v[5]=fvec_(0,0,-1,0);
	  
	  calltriangle2(v+0,v+2,v+4);
	  calltriangle2(v+0,v+2,v+5,1);
	  calltriangle2(v+0,v+3,v+4,1);
	  calltriangle2(v+0,v+3,v+5);
	  calltriangle2(v+1,v+2,v+4,1);
	  calltriangle2(v+1,v+2,v+5);
	  calltriangle2(v+1,v+3,v+4);
	  calltriangle2(v+1,v+3,v+5,1);
	}
      else
	{
	  // use tetrahedron
	  float a=sqrt(2);
	  static fvec v[4];
	  v[0]=fvec_(1,0,a,0);
	  v[1]=fvec_(1,0,-a,0);
	  v[2]=fvec_(-1,a,0,0);
	  v[3]=fvec_(-1,-a,0,0);
	    
	  calltriangle2(v+0,v+1,v+2);
	  calltriangle2(v+1,v+0,v+3);
	  calltriangle2(v+2,v+3,v+0);
	  calltriangle2(v+3,v+2,v+1);
	}
    }
}


static void blur2()
{
  glow_extractalpha(screen,tempscreen);
  glow_borrowzbuf(screen);
  glow_copy(tempscreen,&glow_zbuf);
  
  glow_radialblur(&glow_zbuf,tempscreen,320+100*cos(frames*0.01*0.8),128+50*sin(frames*0.01),sqrt(0.5),6,64,(int)(max(timing::get(0),timing::get(1))*64));

  glow_blend(tempscreen,screen);
}


static void blur3()
{
  glow_extractalpha(screen,tempscreen);
  glow_borrowzbuf(screen);
  glow_copy(tempscreen,&glow_zbuf);
  
  glow_radialblur(&glow_zbuf,tempscreen,320+100*cos(frames*0.01*0.8),128+50*sin(frames*0.01),sqrt(0.8),6,64,64+16);
  
  glow_blend(tempscreen,screen,int(timing::get(9)*256.0),0);
}


void bonbon_init()
{
  tex1.init();
  tex1.load(binary_phong_start);
  glow_computealpha(&tex1);
}


void bonbon_init2()
{
  tex1.allocupload();
}


void bonbon_frame(float frames_, texture *screen_, texture *tempscreen_, int iframe_)
{
  if(PAL)
    SPLITS=27;
  else
    SPLITS=22;

  tempscreen=tempscreen_;
  screen=screen_;
  iframe=iframe_;
  frames=frames_;
  
  ypos=150*timing::get(5);

  switch (timing::getval(21))
    {
    case 0:
      bonbon(frames);
      blur3();
      break;
    case 1:
      bonbon(frames);
      blur2();
      break;
    }
  
  dma01_endchain();
}


void bonbon_deinit()
{
}
