\---------------------------------------------------------------------
\ GEN_FONT.ASM -- Generate font file for Tetris Deluxe
\ Run GEN_FONT.COM to generate TETRIS.FN1
\---------------------------------------------------------------------
\ To construct TETRIS.DAT (TETRIS.FNT must exist):
\   GEN_PCS
\   GEN_FONT
\   COPY /B TETRIS.FN1+TETRIS.PCS TETRIS.DAT
\   DEL TETRIS.FN1
\   DEL TETRIS.PCS
\---------------------------------------------------------------------

O           equ <Offset>;
B           equ <Byte Ptr>;
W           equ <Word Ptr>;

.Model Tiny;
.Code;
Org 100h;

\---------------------------------------------------------------------

Start:
    ax = 3D00h; dx = O(InFile); !21h;       \ open input file
    bx == ax;                               \ bx = handle
    ah = 3Fh; cx = (14*256);                \ read file
    dx = O(Buffer); !21h;
    ah = 3Eh; !21h;                         \ close file

    si = dx; di = O(OutBuf); &ah;           \ SI = in, DI = out
                                            \ zero count = 0
    {
        =*; al?                             \ load and test byte
        <> {                                \ if not zero, then
            ah? <> {                        \ if zeros pending, then
                =ax; &al; **=; ax=;         \ output RLE code
            };
            *=; &ah;                        \ output byte, count = 0
        },{                                 \ otherwise, if zero, then
            ah+; ah - 255?                  \ increment and check count
            == {                            \ if too high, then
                **=; &ah;                   \ output RLE code, count = 0
            };
        };
    }-.;                                    \ loop for 14*256 iterations

    ah? <> {                                \ if zeros pending, then
        &al; **=;                           \ output RLE code
    };

    &ax; **=;                               \ output terminator

    ah = 3Ch; &cx; dx = O(OutFile); !21h;   \ Create the output file
    bx == ax;                               \ BX = handle
    ah = 40h; dx = O(OutBuf);               \ Write out compressed data
    cx = di - dx; !21h;
    ah = 3Eh; !21h; !20h;                   \ Close the file and return

\---------------------------------------------------------------------

InFile      db 'TETRIS.FNT',0;
OutFile     db 'TETRIS.FN1',0;

Buffer      db 3584 dup(?);
OutBuf:

End Start
