;---------------------------------------------------------------------
; GEN_PCS.ASM -- Generate piece file for Tetris Deluxe
; Run GEN_PCS.COM to generate TETRIS.PCS
;---------------------------------------------------------------------
; To construct TETRIS.DAT (TETRIS.FNT must exist):
;   GEN_PCS
;   GEN_FONT
;   COPY /B TETRIS.FN1+TETRIS.PCS TETRIS.DAT
;   DEL TETRIS.FN1
;   DEL TETRIS.PCS
;---------------------------------------------------------------------

.Model Tiny
.Code
Org 100h
Start:      mov cx,offset BufEnd    ;CX = compressed length
            sub cx,offset Buffer
            shr cx,1                ;Cut in half
            mov bp,cx               ;Save value

            mov si,offset Buffer    ;SI = buffer
            mov di,offset BufEnd    ;DI = end of data

EncLoop:    lodsw                   ;Get 2 bytes
            shl ah,4                ;Pack into 1 byte
            and al,0Fh
            or al,ah
            stosb                   ;Store byte
            loop EncLoop            ;Loop back

;---------------------------------------------------------------------

            mov ah,3Ch              ;Create the piece file
            xor cx,cx
            mov dx,offset Filename
            int 21h

            xchg bx,ax              ;BX = handle

            mov ah,40h              ;Write out compressed data
            mov cx,bp
            mov dx,offset BufEnd
            int 21h

            mov ah,3Eh              ;Close the file
            int 21h

            mov ax,4C00h            ;Return
            int 21h

;---------------------------------------------------------------------

Filename    db 'TETRIS.PCS',0

Buffer:

    db  0, 0, 0,-1, 1, 2    ;       0
    db  0, 0, 0, 0, 0, 0    ; X
    db  0, 0, 0,-1, 1, 2
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; 
    db  0, 0, 0, 1,-1,-2    ; Y
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 1,-1,-2

    db  5, 5, 5, 4, 5, 1    ; 
    db 10,10,10, 8,10, 2    ; T
    db  5, 5, 5, 4, 5, 1
    db 10,10,10, 8,10, 2

    db  0, 0, 0,-1, 1, 1    ;        1
    db  0, 0, 0, 0, 0, 1    ; X
    db  0, 0, 0, 1,-1,-1
    db  0, 0, 0, 0, 0,-1

    db  0, 0, 0, 0, 0,-1    ; 
    db  0, 0, 0,-1, 1, 1    ; Y
    db  0, 0, 0, 0, 0, 1
    db  0, 0, 0, 1,-1,-1

    db  5, 5, 5, 4, 9, 2    ; 
    db 10,10,10, 2,12, 1    ; T
    db  5, 5, 5, 1, 6, 8
    db 10,10,10, 8, 3, 4

    db  0, 0, 0, 1,-1,-1    ;        2
    db  0, 0, 0, 0, 0, 1    ; X
    db  0, 0, 0,-1, 1, 1
    db  0, 0, 0, 0, 0,-1

    db  0, 0, 0, 0, 0,-1    ; 
    db  0, 0, 0, 1,-1,-1    ; Y
    db  0, 0, 0, 0, 0, 1
    db  0, 0, 0,-1, 1, 1

    db  5, 5, 5, 1,12, 2    ; 
    db 10,10,10, 8, 6, 1    ; T
    db  5, 5, 5, 4, 3, 8
    db 10,10,10, 2, 9, 4

    db  0, 0, 0,-1, 1, 0    ;        3
    db  0, 0, 0, 0, 0, 1    ; X
    db  0, 0, 0, 1,-1, 0
    db  0, 0, 0, 0, 0,-1

    db  0, 0, 0, 0, 0,-1    ; 
    db  0, 0, 0,-1, 1, 0    ; Y
    db  0, 0, 0, 0, 0, 1
    db  0, 0, 0, 1,-1, 0

    db 13,13,13, 4, 1, 2    ; 
    db 14,14,14, 2, 8, 1    ; T
    db  7, 7, 7, 1, 4, 8
    db 11,11,11, 8, 2, 4

    db  0, 0, 0, 1, 0,-1    ;        4
    db  0, 0, 0, 0, 1, 1    ; X
    db  0, 0, 0, 1, 0,-1
    db  0, 0, 0, 0, 1, 1

    db  0, 0, 0, 0,-1,-1    ; 
    db  0, 0, 0, 1, 0,-1    ; Y
    db  0, 0, 0, 0,-1,-1
    db  0, 0, 0, 1, 0,-1

    db 12,12,12, 1, 3, 4    ; 
    db  6, 6, 6, 8, 9, 2    ; T
    db 12,12,12, 1, 3, 4
    db  6, 6, 6, 8, 9, 2

    db  0, 0, 0,-1, 0, 1    ;        5
    db  0, 0, 0, 0, 1, 1    ; X
    db  0, 0, 0,-1, 0, 1
    db  0, 0, 0, 0, 1, 1

    db  0, 0, 0, 0,-1,-1    ; 
    db  0, 0, 0,-1, 0, 1    ; Y
    db  0, 0, 0, 0,-1,-1
    db  0, 0, 0,-1, 0, 1

    db  9, 9, 9, 4, 6, 1    ; 
    db 12,12,12, 2, 3, 8    ; T
    db  9, 9, 9, 4, 6, 1
    db 12,12,12, 2, 3, 8

    db  0, 0, 0, 1, 0, 1    ;         6
    db  0, 0, 0, 1, 0, 1    ; X
    db  0, 0, 0, 1, 0, 1
    db  0, 0, 0, 1, 0, 1

    db  0, 0, 0, 0,-1,-1    ; 
    db  0, 0, 0, 0,-1,-1    ; Y
    db  0, 0, 0, 0,-1,-1
    db  0, 0, 0, 0,-1,-1

    db 12,12,12, 9, 6, 3    ; 
    db 12,12,12, 9, 6, 3    ; T
    db 12,12,12, 9, 6, 3
    db 12,12,12, 9, 6, 3

    db  0, 0, 0,-1,-1, 1    ;        7
    db  0, 0, 0, 0, 0, 0    ; X
    db  0, 0, 0,-1,-1, 1
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; 
    db  0, 0, 0,-1,-1, 1    ; Y
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0,-1,-1, 1

    db  5, 5, 5, 4, 4, 1    ; 
    db 10,10,10, 2, 2, 8    ; T
    db  5, 5, 5, 4, 4, 1
    db 10,10,10, 2, 2, 8

    db  0, 0, 0, 0, 0, 1    ;         8
    db  0, 0, 0, 0, 0, 1    ; X
    db  1, 1, 1, 1, 1, 0
    db  1, 1, 1, 1, 1, 0

    db  0, 0, 0,-1,-1, 0    ; 
    db -1,-1,-1, 0, 0,-1    ; Y
    db -1,-1,-1, 0, 0,-1
    db  0, 0, 0,-1,-1, 0

    db 12,12,12, 2, 2, 1    ; 
    db  6, 6, 6, 8, 8, 1    ; T
    db  3, 3, 3, 8, 8, 4
    db  9, 9, 9, 2, 2, 4

    db  0, 0, 0, 0, 0, 1    ;         9
    db  0, 0, 0, 0, 0, 0    ; X
    db  0, 0, 0, 0, 0, 1
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; 
    db  0, 0, 0, 0, 0,-1    ; Y
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0,-1

    db  0, 0, 0, 0, 4, 1    ; 
    db  0, 0, 0, 0, 8, 2    ; T
    db  0, 0, 0, 0, 4, 1
    db  0, 0, 0, 0, 8, 2

    db  0, 0,-1,-1, 1, 2    ;       10
    db  0, 0, 0, 1, 0, 0    ; X
    db  0, 0, 1, 1,-1,-2
    db  0, 0, 0,-1, 0, 0

    db  0, 0, 0,-1, 0, 0    ; 
    db  0, 0,-1,-1, 1, 2    ; Y
    db  0, 0, 0, 1, 0, 0
    db  0, 0, 1, 1,-1,-2

    db  5, 5,12, 2, 5, 1    ; 
    db 10,10, 6, 1,10, 8    ; T
    db  5, 5, 3, 8, 5, 4
    db 10,10, 9, 4,10, 2

    db  0, 0, 1, 1,-1,-2    ;       11
    db  0, 0, 0, 1, 0, 0    ; X
    db  0, 0,-1,-1, 1, 2
    db  0, 0, 0,-1, 0, 0

    db  0, 0, 0,-1, 0, 0    ; 
    db  0, 0, 1, 1,-1,-2    ; Y
    db  0, 0, 0, 1, 0, 0
    db  0, 0,-1,-1, 1, 2

    db  5, 5, 9, 2, 5, 4    ; 
    db 10,10,12, 1,10, 2    ; T
    db  5, 5, 6, 8, 5, 1
    db 10,10, 3, 4,10, 8

    db  0, 0,-1, 0, 1, 2    ;       12
    db  0, 0, 0, 1, 0, 0    ; X
    db  0, 0, 1, 0,-1,-2
    db  0, 0, 0,-1, 0, 0

    db  0, 0, 0,-1, 0, 0    ; 
    db  0, 0,-1, 0, 1, 2    ; Y
    db  0, 0, 0, 1, 0, 0
    db  0, 0, 1, 0,-1,-2

    db 13,13, 4, 2, 5, 1    ; 
    db 14,14, 2, 1,10, 8    ; T
    db  7, 7, 1, 8, 5, 4
    db 11,11, 8, 4,10, 2

    db  0, 0, 1, 0,-1,-2    ;       13
    db  0, 0, 0, 1, 0, 0    ; X
    db  0, 0,-1, 0, 1, 2
    db  0, 0, 0,-1, 0, 0

    db  0, 0, 0,-1, 0, 0    ; 
    db  0, 0, 1, 0,-1,-2    ; Y
    db  0, 0, 0, 1, 0, 0
    db  0, 0,-1, 0, 1, 2

    db 13,13, 1, 2, 5, 4    ; 
    db 14,14, 8, 1,10, 2    ; T
    db  7, 7, 4, 8, 5, 1
    db 11,11, 2, 4,10, 8

    db  0, 0, 0, 0, 0, 0    ;          14
    db  0, 0, 0, 0, 0, 0    ; X
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; 
    db  0, 0, 0, 0, 0, 0    ; Y
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; 
    db  0, 0, 0, 0, 0, 0    ; T
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0, 0

    db  0, 0,-1,-1, 0, 1    ;        15
    db  0, 0, 0, 1, 1, 0    ; X
    db  0, 0, 1, 1, 0,-1
    db  0, 0, 0,-1,-1, 0

    db  0, 0, 0,-1,-1, 0    ; 
    db  0, 0,-1,-1, 0, 1    ; Y
    db  0, 0, 0, 1, 1, 0
    db  0, 0, 1, 1, 0,-1

    db 13,13,12, 6, 3, 1    ; 
    db 14,14, 6, 3, 9, 8    ; T
    db  7, 7, 3, 9,12, 4
    db 11,11, 9,12, 6, 2

    db  0, 0, 1, 1, 0,-1    ;        16
    db  0, 0, 0, 1, 1, 0    ; X
    db  0, 0,-1,-1, 0, 1
    db  0, 0, 0,-1,-1, 0

    db  0, 0, 0,-1,-1, 0    ; 
    db  0, 0, 1, 1, 0,-1    ; Y
    db  0, 0, 0, 1, 1, 0
    db  0, 0,-1,-1, 0, 1

    db 13,13, 9, 3, 6, 4    ; 
    db 14,14,12, 9, 3, 2    ; T
    db  7, 7, 6,12, 9, 1
    db 11,11, 3, 6,12, 8

    db  0, 0,-1, 0, 1, 0    ;        17
    db  0, 0,-1,-1,-1, 1    ;  
    db  0, 0, 1, 0,-1, 0    ; X
    db  0, 0, 1, 1, 1,-1

    db  0, 0, 1, 1, 1,-1    ; 
    db  0, 0,-1, 0, 1, 0    ;  
    db  0, 0,-1,-1,-1, 1    ; Y
    db  0, 0, 1, 0,-1, 0

    db 10,10, 4,13, 1, 2    ; 
    db  5, 5, 2,14, 8, 1    ;  
    db 10,10, 1, 7, 4, 8    ; T
    db  5, 5, 8,11, 2, 4

    db -1,-1,-1,-1, 0, 1    ;        18
    db -1,-1, 0, 1,-1,-1    ; 
    db  1, 1, 1, 1, 0,-1    ; X
    db  1, 1, 0,-1, 1, 1

    db  1, 1, 0,-1, 1, 1    ; 
    db -1,-1,-1,-1, 0, 1    ; 
    db -1,-1, 0, 1,-1,-1    ; Y
    db  1, 1, 1, 1, 0,-1

    db 12,12,10, 2, 5, 1    ; 
    db  6, 6, 5, 1,10, 8    ; 
    db  3, 3,10, 8, 5, 4    ; T
    db  9, 9, 5, 4,10, 2

    db  0, 0, 0,-1, 1, 2    ;       19
    db  0, 0, 1, 1, 0, 0    ; X
    db  0, 0, 0, 1,-1,-2
    db  0, 0,-1,-1, 0, 0

    db  0, 0,-1,-1, 0, 0    ; 
    db  0, 0, 0,-1, 1, 2    ; Y
    db  0, 0, 1, 1, 0, 0
    db  0, 0, 0, 1,-1,-2

    db 12,12, 3, 4, 5, 1    ; 
    db  6, 6, 9, 2,10, 8    ; T
    db  3, 3,12, 1, 5, 4
    db  9, 9, 6, 8,10, 2

    db  0, 0, 0, 1,-1,-2    ;       20
    db  0, 0, 1, 1, 0, 0    ; X
    db  0, 0, 0,-1, 1, 2
    db  0, 0,-1,-1, 0, 0

    db  0, 0,-1,-1, 0, 0    ; 
    db  0, 0, 0, 1,-1,-2    ; Y
    db  0, 0, 1, 1, 0, 0
    db  0, 0, 0,-1, 1, 2

    db  9, 9, 6, 1, 5, 4    ; 
    db 12,12, 3, 8,10, 2    ; T
    db  6, 6, 9, 4, 5, 1
    db  3, 3,12, 2,10, 8

    db  0, 0,-1, 1,-1, 1    ;        21
    db  0, 0, 0, 0,-1, 1    ;   
    db  0, 0, 1,-1, 1,-1    ; X
    db  0, 0, 0, 0, 1,-1

    db  0, 0, 0, 0, 1,-1    ; 
    db  0, 0,-1, 1,-1, 1    ;   
    db  0, 0, 0, 0,-1, 1    ; Y
    db  0, 0, 1,-1, 1,-1

    db  5, 5, 6, 9, 8, 2    ; 
    db 10,10, 3,12, 4, 1    ;   
    db  5, 5, 9, 6, 2, 8    ; T
    db 10,10,12, 3, 1, 4

    db  0, 0, 1,-1, 1,-1    ;        22
    db  0, 0, 0, 0,-1, 1    ; 
    db  0, 0,-1, 1,-1, 1    ; X
    db  0, 0, 0, 0, 1,-1

    db  0, 0, 0, 0, 1,-1    ; 
    db  0, 0, 1,-1, 1,-1    ; 
    db  0, 0, 0, 0,-1, 1    ; Y
    db  0, 0,-1, 1,-1, 1

    db  5, 5, 3,12, 8, 2    ; 
    db 10,10, 9, 6, 4, 1    ; 
    db  5, 5,12, 3, 2, 8    ; T
    db 10,10, 6, 9, 1, 4

    db  0, 0, 0,-1, 1,-1    ;        23
    db  0, 0,-1, 0,-1, 1    ; 
    db  0, 0, 0, 1,-1, 1    ; X
    db  0, 0, 1, 0, 1,-1

    db  0, 0, 1, 0, 1,-1    ; 
    db  0, 0, 0,-1, 1,-1    ; 
    db  0, 0,-1, 0,-1, 1    ; Y
    db  0, 0, 0, 1,-1, 1

    db  3, 3,12,12, 1, 2    ; 
    db  9, 9, 6, 6, 8, 1    ; 
    db 12,12, 3, 3, 4, 8    ; T
    db  6, 6, 9, 9, 2, 4

    db  0, 0, 0, 1,-1,-1    ;        24
    db  0, 0, 1, 0, 0,-1    ;  
    db  0, 0, 0,-1, 1, 1    ; X
    db  0, 0,-1, 0, 0, 1

    db  0, 0,-1, 0, 0, 1    ; 
    db  0, 0, 0, 1,-1,-1    ;  
    db  0, 0, 1, 0, 0,-1    ; Y
    db  0, 0, 0,-1, 1, 1

    db 13,13, 2, 1, 6, 8    ; 
    db 14,14, 1, 8, 3, 4    ;  
    db  7, 7, 8, 4, 9, 2    ; T
    db 11,11, 4, 2,12, 1

    db  0, 0, 0,-1, 1, 1    ;        25
    db  0, 0, 1, 0, 0,-1    ;  
    db  0, 0, 0, 1,-1,-1    ; X
    db  0, 0,-1, 0, 0, 1

    db  0, 0,-1, 0, 0, 1    ; 
    db  0, 0, 0,-1, 1, 1    ;  
    db  0, 0, 1, 0, 0,-1    ; Y
    db  0, 0, 0, 1,-1,-1

    db 13,13, 2, 4, 3, 8    ; 
    db 14,14, 1, 2, 9, 4    ;  
    db  7, 7, 8, 1,12, 2    ; T
    db 11,11, 4, 8, 6, 1

    db  0, 0, 0, 0, 1,-1    ;        26
    db  0, 0, 0, 0, 1,-1    ;  
    db  0, 0, 0, 0, 1,-1    ; X
    db  0, 0, 0, 0, 1,-1

    db  0, 0, 1,-1, 0, 0    ; 
    db  0, 0, 1,-1, 0, 0    ;  
    db  0, 0, 1,-1, 0, 0    ; Y
    db  0, 0, 1,-1, 0, 0

    db 15,15, 8, 2, 1, 4    ; 
    db 15,15, 8, 2, 1, 4    ;  
    db 15,15, 8, 2, 1, 4    ; T
    db 15,15, 8, 2, 1, 4

    db  0, 0, 1, 1,-1,-1    ;        27
    db  0, 0, 0, 1, 0, 1    ; X
    db  0, 0,-1,-1, 1, 1
    db  0, 0, 0,-1, 0,-1

    db  0, 0, 0,-1, 0,-1    ; 
    db  0, 0, 1, 1,-1,-1    ; Y
    db  0, 0, 0, 1, 0, 1
    db  0, 0,-1,-1, 1, 1

    db  5, 5, 9, 2,12, 2    ; 
    db 10,10,12, 1, 6, 1    ; T
    db  5, 5, 6, 8, 3, 8
    db 10,10, 3, 4, 9, 4

    db -1, 0, 1, 2, 0, 1    ;       28
    db  0, 0, 0, 0, 1, 1    ; X
    db -1, 0, 1, 2, 0, 1
    db  1, 1, 1, 1, 0, 0

    db  0, 0, 0, 0,-1,-1    ; 
    db -2,-1, 0, 1,-1, 0    ; Y
    db -1,-1,-1,-1, 0, 0
    db -2,-1, 0, 1,-1, 0

    db  4,13,13, 1, 6, 3    ; 
    db  2,14,14, 8, 3, 9    ; T
    db  4, 7, 7, 1,12, 9
    db  2,11,11, 8, 6,12

    db -1, 0, 1,-1, 0,-1    ;        29
    db -1,-1,-1, 0, 0, 1    ; 
    db  1, 0,-1, 1, 0, 1    ; X
    db  1, 1, 1, 0, 0,-1

    db  1, 1, 1, 0, 0,-1    ; 
    db -1, 0, 1,-1, 0,-1    ; 
    db -1,-1,-1, 0, 0, 1    ; Y
    db  1, 0,-1, 1, 0, 1

    db 12,13, 1,14, 3, 2    ; 
    db  6,14, 8, 7, 9, 1    ; 
    db  3, 7, 4,11,12, 8    ; T
    db  9,11, 2,13, 6, 4

    db -1, 0, 1,-1, 0, 0    ;        30
    db -1,-1,-1, 0, 0, 1    ;  
    db  1, 0,-1, 1, 0, 0    ; X
    db  1, 1, 1, 0, 0,-1

    db  1, 1, 1, 0, 0,-1    ; 
    db -1, 0, 1,-1, 0, 0    ;  
    db -1,-1,-1, 0, 0, 1    ; Y
    db  1, 0,-1, 1, 0, 0

    db 12,13, 1, 6,11, 2    ; 
    db  6,14, 8, 3,13, 1    ;  
    db  3, 7, 4, 9,14, 8    ; T
    db  9,11, 2,12, 7, 4

    db -1, 0, 1, 0, 1, 0    ;        31
    db -1,-1,-1, 0, 0, 1    ;  
    db  1, 0,-1, 0,-1, 0    ; X
    db  1, 1, 1, 0, 0,-1

    db  1, 1, 1, 0, 0,-1    ; 
    db -1, 0, 1, 0, 1, 0    ;  
    db -1,-1,-1, 0, 0, 1    ; Y
    db  1, 0,-1, 0,-1, 0

    db  4,13, 9,14, 3, 2    ; 
    db  2,14,12, 7, 9, 1    ;  
    db  1, 7, 6,11,12, 8    ; T
    db  8,11, 3,13, 6, 4

    db -2,-1, 0,-1, 0, 1    ;       32
    db -1,-1,-1, 0, 0, 0    ; X
    db -2,-1, 0,-1, 0, 1
    db -1,-1,-1, 0, 0, 0

    db  0, 0, 0,-1,-1,-1    ; 
    db -2,-1, 0,-1, 0, 1    ; Y
    db  0, 0, 0,-1,-1,-1
    db -2,-1, 0,-1, 0, 1

    db  4,13, 9, 6, 7, 1    ; 
    db  2,14,12, 3,11, 8    ; T
    db  4,13, 9, 6, 7, 1
    db  2,14,12, 3,11, 8

    db  2, 1, 0, 1, 0,-1    ;       33
    db  1, 1, 1, 0, 0, 0    ; X
    db  2, 1, 0, 1, 0,-1
    db  1, 1, 1, 0, 0, 0

    db  0, 0, 0,-1,-1,-1    ; 
    db -2,-1, 0,-1, 0, 1    ; Y
    db  0, 0, 0,-1,-1,-1
    db -2,-1, 0,-1, 0, 1

    db  1,13,12, 3, 7, 4    ; 
    db  2,11, 9, 6,14, 8    ; T
    db  1,13,12, 3, 7, 4
    db  2,11, 9, 6,14, 8

    db -1, 0, 1,-1, 0, 1    ;        34
    db -1, 0,-1, 0,-1, 0    ; X
    db -1, 0, 1,-1, 0, 1
    db -1, 0,-1, 0,-1, 0

    db  0, 0, 0,-1,-1,-1    ; 
    db  0, 0,-1,-1,-2,-2    ; Y
    db  0, 0, 0,-1,-1,-1
    db  0, 0,-1,-1,-2,-2

    db 12,13, 9, 6, 7, 3    ; 
    db 12, 9,14,11, 6, 3    ; T
    db 12,13, 9, 6, 7, 3
    db 12, 9,14,11, 6, 3

    db  0, 0, 0, 0, 0, 0    ; Special   35
    db  0, 0, 0, 0, 0, 0    ; X
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; Special
    db  0, 0, 0, 0, 0, 0    ; Y
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; Special
    db  0, 0, 0, 0, 0, 0    ; T
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; Special   36
    db  0, 0, 0, 0, 0, 0    ; X
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; Special
    db  0, 0, 0, 0, 0, 0    ; Y
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0, 0

    db  0, 0, 0, 0, 0, 0    ; Special
    db  0, 0, 0, 0, 0, 0    ; T
    db  0, 0, 0, 0, 0, 0
    db  0, 0, 0, 0, 0, 0

BufEnd:

End Start
