; From         Andrew Kennedy
; isdesk.asm   Determine if deskview is present
;              Returns in AH/AL deskview major/minor versions
;              Returns 0 in ax if deskview is NOT present.
;
.model       small
.stack       200h

public       dv_get_version

.data

in_div       db           ?
notthere     db           'Deskview not present.$'
there        db           'Deskview present.$'

.code

dv_get_version proc

             mov          ax,@data
             mov          ds,ax

             push         bx
             push         cx
             push         dx
             mov          cx,'DE'
             mov          dx,'SQ'
             mov          ax,2b01h           ; DOS set date function
             int          21h
             cmp          al,0ffh
             je           no_deskview
             mov          ax,bx
             mov          dx,offset there
             mov          ah,9
             int          21h

             jmp          short dvgv_x
no_deskview:
             sub          ax,ax              ; return a 0 since no deskview
             mov          dx,offset notthere
             mov          ah,9
             int          21h
dvgv_x:
             pop          dx
             pop          cx
             pop          bx
ret

dv_get_version            endp

end
