;Robert Piontek

; Program to display color spread on VGA mode 13h

.model small
.stack

.data

red     db 0            ; Red color value
green   db 0            ; Green color value
blue    db 0            ; Blue color value

.code

mov     ax,@data
mov     ds,ax           ; Set DS to point to data segment
mov     ax,0A000h
mov     es,ax           ; Set ES to point to video segment
mov     ax,13h
int     10h             ; Set 320x200 256 color mode

set_pal:

; * The Palette registers are programmed one of two ways. A BIOS call or
; setting them directly through the ports. BIOS is easier but slower.
; Direct programming of the palette registers is accomplished by first
; sending the number of the palette register you wish to set to port 03c8h.
; This is a single byte in the range of 0-255 ( the number of registers ).
; If you are going to be setting all the palette registers you would send a
; 0 to port 03c8 indicating you wish to start at register 0.
; After you send the register number you can set the color by sending 3
; consecutive bytes to port 03c9. 1-red,2-green,3-blue ( in that order ).
; Once you have sent the color information, the palette register auto-
; increments to the next palette register. So the next 3 bytes you send to
; 03c9 automatically determine the next palette. This allows quick programming
; of the palette registers.
; Here is an example-

mov     dx,03C8h        ; Set DX to palette index register
mov     al,0            ; Load AL with first palette register to set
out     dx,al           ; Setup port for first palette register
inc     dx              ; Sets DX to palette color register

mov     cx,256          ; Set CX to number of registers to set
pal_set:
mov     al,red          ; Load AL with red color value
out     dx,al           ; Set red amount
mov     al,green        ; Load AL with green color value
out     dx,al           ; Set green amount
mov     al,blue         ; Load AL with blue color value
out     dx,al           ; Set blue amount
inc     red             ; Increment red value
inc     green           ; Increment green value
;inc    blue            ; Increment blue value
;^ INCLUDE ; OR REMOVE TO NOT DISPLAY THAT COLOR
loop    pal_set         ; Continue to next register

xor     ax,ax           ; Zero out AX
xor     di,di           ; Zero out DI
fill_screen:
stosb                   ; Stores AL into ES:[DI] and increments DI
inc     al              ; Advance to next color
cmp     di,64000        ; Have we reached last pixel?
jne     fill_screen     ; If not continue to next pixel

quit:
mov     ah,0            ; This function waits until a key is struck
int     16h             ; before continuing thus eliminating the loop.
mov     ax,3
int     10h             ; Restore text mode
mov     ax,4C00h
int     21h             ; Terminate program

end
