;-----------------------------------------------------
; init com2 - Initialize modem to 14400,8,N,1
;  by James Vahn, into the Public Domain

cseg segment
assume cs:cseg
org 100h                        ;.COM format

Port    EQU 02F8h               ;03F8h for Com1

Begin:

        call    Drop            ;Drop DTR in case we are online.
        call    Init            ;Setup for 14400,8,N,1

        push    ax
        mov     cx,1
        call    delay
        call    Reset           ;Send ATZ to the modem.
        pop     ax
        test    al,10000000b    ;Test for carrier detect and if
        jz      exit            ; found, try again to disconnect.
        dec     cntr
        jnz     Begin
 exit:
        call    Init            ;Repeat it for good measure.
        call    Reset
        cmp     cntr,0
        jne     bye
        mov     dx,offset error
        mov     ah,9
        int     21h
 bye:
        mov     ax,4C00h        ;Exit to DOS.
        int     21h
;*******************************************
 cntr   db 3                    ;Try three times.
 error  db 'I/O error, try reseting machine',36

;*******************************************
 Drop proc near      ; Raise and lower DTR.

        call    Disable         ;Disable IRQ's.
        mov     dx,Port+4       ;Access modem control port.
        in      al,dx
        or      al,00000001b    ;Raise DTR
        out     dx,al
        mov     cx,1
        call    Delay
        in      al,dx
        and     al,00000000b    ;Drop dtr & rts.
        or      al,00001100b
        out     dx,al
        mov     cx,1
        call    Delay
        call    Enable          ;Enable IRQ's.
        mov     al,20h          ;Signal 8259 that other
        out     20h,al          ;  interrupts are okay.
        ret
 Drop endp
;**************************************************
 Init proc near
  ;Sets modem to 14400,N,8,1

        mov     dx,Port + 3
        mov     al,10000000b    ;Enable baud rate divisor.
        out     dx,al
        mov     dx,Port
        mov     al,8            ;
        out     dx,al           ;Set modem for 14400
        mov     al,0            ;
        inc     dx              ;
        out     dx,al           ;
        mov     dx,Port + 3
        mov     al,00000011b    ;Set for 8,N,1
        out     dx,al
        ret

 Init endp
;**************************************************
 Delay proc near     ; Simple BIOS delay
  ;Requires number of reiterations in CX on entry.

        push    ds
        mov     ax,0040h
        mov     ds,ax
        mov     bx,6Ch          ;BIOS timer, 40:6C
  d1:   mov     al,[bx]
DelayLoop:
        cmp     al,[bx]         ;Is it the same?
        je      DelayLoop       ;Yes, try again.
        loop    d1              ;Nope, loop and decrement CX.
        pop     ds              ;Restore registers and exit.
        ret
 Delay endp
;**************************************************
Reset proc near      ;Send ATZ to the modem.

        mov     dx, Port
        mov     al, 'A'
        out     dx,al
        mov     cx,1
        call    delay
        mov     al, 'T'
        out     dx,al
        mov     cx,1
        call    delay
        mov     al, 'Z'
        out     dx,al
        mov     cx,1
        call    delay
        mov     al, 0Dh
        out     dx,al
        mov     cx,10
        call    delay
        ret

Reset endp
;**************************************************
 Disable proc near
        in      al,21h
        or      al,00001000b    ;Disable IRQ3 (com2)
        or      al,00010000b    ;Disable IRQ4 (com1)
        out     21h,al
        ret
 Disable endp

;**************************************************
 Enable proc near
        in      al,21h
        and     al,11110111b    ;Enable IRQ3 (com2)
        and     al,11101111b    ;Enable IRQ4 (com1)
        out     21h,al
        ret
 Enable endp

cseg ends
end Begin
