#include "SM_DemoEffect.h"
#include "SM_Slider.h"

class FilterFX : public SM_DemoEffect
{
public:              
  FilterFX(char const* pcName);
  virtual ~FilterFX();
  
  int           Init              (const char* pcCommand);

  int           Shutdown          ();  

  int           Start             (float fTime);
  
  int           Stop              ();
  int           Reset             ();
  
  int           Run               (float fTime);
  void          RunPreStartFrame  (float fTime);           
  void          RunPreRender      (float fTime);           
  void          RunPostRender     (float fTime);           
  void          RunPostEndFrame   (float fTime);           
  void          RunPreLayer       (int iLayer, float fTime); 
  void          RunPostLayer      (int iLayer, float fTime);
  

  
  int           Command  (float fTime, const char* pcCommand);
  int           ParseShaderCommand(float fTime);
  
  void          RenderRadialBlur(float x, float y, float scale);
  void          RenderNormal(float fTime);
  void          RenderHorizontalNoise(float fAmplitude);
  void          RenderLens(float fAmplitude);
  void          RenderWobble(float fTime);
  void          RenderUnderwater(float fTime, float fAmplitude);
  void          RenderTransparent(float fAlpha);
  void          RenderMotionBlur();
  void          RenderComponent();
  void          RenderPlasma(float fTime, float fLerp);
  void          RenderMDMABackground(float fTime);

  unsigned      GetBackColor();

  bool          m_bInterceptRender;

  bool          m_bHorizontalNoise;
  ExpSlider     m_HorizontalNoiseSlider;
  float         m_fHorizontalAmplitude;

  bool          m_bLens;
  bool          m_bLensFadeIn;
  LinearSlider  m_LensSlider;
  float         m_fLensStrength;
  float         m_fLensFrequency;


  bool          m_bBlur;
  LinearSlider  m_BlurSlider;
  bool          m_bBlurFadeIn;
  float         m_fBlurStrength;

  bool          m_bRadialBlur;
  LinearSlider  m_RadialBlurSlider;
  bool          m_bRadialBlurFadeIn;
  float         m_fRadialBlurStrength;

  bool          m_bPlasma;

  bool          m_bUnderwater;
  ExpSlider     m_UnderwaterSlider;
  bool          m_bUnderwaterFadeIn;
  float         m_fUnderwaterFrecuency;
  float         m_fUnderwaterAmplitude;

  bool          m_bQualityBlur;
  
  bool          m_bWobble;

  bool          m_bTransition;

  float         m_fComponentAmplitude[3], m_fComponentFrequency[3], m_fComponentOffset[3];
  bool          m_bComponent;
  LinearSlider  m_ComponentSlider;  


  unsigned      m_uBackGround;


  bool          m_bMDMABackgroundAndBeat;


  bool          m_bNoClear;
  
  // Fade
  bool          m_bFadeIn;
  bool          m_bFadeOut;
  float         m_fStartTime;
  float         m_fDuration;
  float         m_fr,m_fg,m_fb;
  float         m_fFadeLimit;

  // Fade 2
  bool          m_bSecondaryFadeIn;
  bool          m_bSecondaryFadeOut;
  float         m_fSecondaryStartTime;
  float         m_fSecondaryDuration;
  float         m_fSecondaryr,m_fSecondaryg,m_fSecondaryb;
  float         m_fSecondaryFadeLimit;



  // layers
  float          m_fMotionBlurFactor;
  int            m_iBlurTexture[2];
  int            m_iMotionBlurTexture[2];
  int            m_iMotionBlurStartLayer;
  int            m_iMotionBlurEndLayer;
  bool           m_bMotionBlur;
  bool           m_bMotionBlurFadeIn;
  LinearSlider   m_MotionBlurSlider;  


  float          m_fBeatStartTime;
  


  bool           m_bTransparentTransition;
  int            m_iTransparentTexture;
  float          m_fTransparentStart;
  float          m_fTransparentEnd;
  LinearSlider   m_TransparentSlider;

  int            m_iTransparentStartLayer;
  int            m_iTransparentEndLayer;
  
  void          GenerateMips();
  

  int           GetAuxDepthBufferID()
  {
    return m_iFakeDepthBufferID;
  }

  virtual int           LoadArgumentsHelp     (Helper*& pHelpers);
  virtual int           CommandArgumentsHelp  (Helper*& pHelpers);


protected:
  void          ResetStatus();

  int           m_iFakeBufferID;
  int           m_iFakeDepthBufferID;  
  bool          m_bInit;  
};

extern FilterFX* g_SceneFilter;

extern int SIZEWIDTH;  
extern int SIZEHEIGHT; 

