#ifndef __DEMOEFFECT

#define __DEMOEFFECT

#include "SM_Leaks.h"


#define MAX_LAYERS 16

class SM_DemoEffect
{
public:              
                    SM_DemoEffect    (char const* pcName);
  virtual          ~SM_DemoEffect    ();

  virtual int      Init              ();                      // 0: OK ; -1: ERROR
  virtual int      Shutdown          ();                      // 0: OK ; -1: ERROR

  virtual int      Start             (float fTime);           // Tiempo en segundos
  virtual int      Stop              ()           ;


  void             SetLayer          (int iLayer);

  virtual int      SetParent         (SM_DemoEffect* pDemoEffect);

  virtual void     RunPreStartFrame  (float fTime);           
  virtual void     RunPreRender      (float fTime);           
  virtual int      Run               (float fTime);             // 1: Vuelve a llamarme ; 0: Stop() y no me llames mas
  virtual void     RunPostRender     (float fTime);           
  virtual void     RunPostEndFrame   (float fTime);           
  virtual void     RunPreLayer       (int iLayer, float fTime); 
  virtual void     RunPostLayer      (int iLayer, float fTime);
  

  virtual int      Command           (float fTime, const char* pcCommand); // Procesa un commando mandado desde script





  SM_DemoEffect*   m_pNextEffect;    // No tocar!. Se usa para las autoenumeraciones  
  char const*      m_pcInstanceName; 
  int              m_iLayer;
  SM_DemoEffect*   m_pParent;
  static int       m_iRandCount;
};

#define DEFINE_EFFECT(Efecto) void EnumeraLinka##Efecto##() {}

extern SM_DemoEffect* EffectInstances;

SM_DemoEffect* GetEffect(const char* pcName);


// Datos accesibles desde un efecto
namespace SM_DEData
{
  struct CVideoBuffer
  {
	unsigned m_uBPP;
	unsigned m_uRMask;
	unsigned m_uGMask;
	unsigned m_uBMask;
	unsigned m_uRShiftLeft;
	unsigned m_uGShiftLeft;
	unsigned m_uBShiftLeft;
	unsigned m_uRShiftRight;
	unsigned m_uGShiftRight;
	unsigned m_uBShiftRight;
	unsigned m_uWidth;
	unsigned m_uHeight;  
	unsigned m_uByteStride;
  void*    m_pVideo;

  void* GetSurfacePointer();
  void* GetSurfacePointer(unsigned x, unsigned y);
  };  

  extern CVideoBuffer VideoBuffer;  
}


extern void EnumerateFx();
#endif


