
// lgfxvsam.cpp
//
// Copyright (c) 1995 by Toshiaki Tsuji, all rights reserved.

#include "stdgfx.h"
#include "lgfxvsa.h"

LONG ScreenWd;
LONG ScreenHt;
LONG ScreenLen;
LONG BankNumber;

LONG vesaSrcWd;
LONG vesaSrcHt;

// EDX = Bank Number

#define SetBank __asm \
{ \
  __asm push AX \
  __asm push BX \
  __asm push EDX \
  __asm xor  BX, BX \
  __asm mov  EDX, BankNumber \
  __asm mov  AX, 0x4F05 \
  __asm int  0x10 \
  __asm pop  EDX \
  __asm pop  BX \
  __asm pop  AX \
}

// VOID SetVESASelector ( SHORT Selector )
// EAX = Selector

VOID SetVESASelector ( SHORT Selector )
{
  if (Selector)
    {}    
} // End of SetVESASelector


// VOID SetVESAData ( LONG SrcWidth, LONG SrcHeight, LONG SrcLen )
// EAX = SrcWidth, EDX = Srcheight, EBX = SrcLen

VOID SetVESAData ( LONG SrcWidth, LONG SrcHeight, LONG SrcLen )
{
__asm {
  pushad

  mov  EAX, SrcWidth
  mov  EDX, SrcHeight
  mov  EBX, SrcLen
  mov  ScreenWd, EAX
  mov  ScreenHt, EDX
  mov  ScreenLen, EBX

  popad
} // End asm
} // End of SetVESAData 

// VOID VESACopy256To256 ( BYTE *Src, LONG AddSrc, LONG vesaSrcWd, LONG vesaSrcHt,
//                         LONG DestCx, LONG DestCy )
//
// EAX = Src, EDX = AddSrc, EBX = vesaSrcWd, ECX = vesaSrcHt

VOID VESACopy256To256 ( BYTE *Src, LONG AddSrc, LONG SrcWidth, LONG SrcHeight,
                        LONG DestCx, LONG DestCy )
{
__asm {
  pushad

  mov  EAX, Src
  mov  EDX, AddSrc
  mov  EBX, SrcWidth
  mov  ECX, SrcHeight

  mov  ESI, EAX   ; ESI = Src
  mov  vesaSrcWd, EBX
  mov  vesaSrcHt, ECX
  
  sub  EDX, EBX
  mov  EBX, EDX   ; EBX = AddSrc - vesaSrcWd

  mov  EDI, 0A0000h
  mov  EAX, DestCy
  mov  EDX, ScreenLen
  mul  DX  
  add  EAX, DestCx
  adc  EDX, 0        ; EDX is the Bank Number
  and  EAX, 0FFFFh
  mov  BankNumber, EDX
  
  SetBank 
  
  add  EDI, EAX
  
  mov  EDX, ScreenLen
  sub  EDX, vesaSrcWd
  cld

  Copy256OutLoop :
    mov ECX, vesaSrcWd
    mov EAX, ECX
    and EAX, 03h
    shr ECX, 2
    rep movsd
    mov ECX, EAX
    rep movsb
    add ESI, EBX
    add EDI, EDX
    cmp EDI, 0AFFFFh
    jle DoNext
      inc BankNumber
      SetBank
      and EDI, 0AFFFFh

    DoNext :
      dec vesaSrcHt
    jnz Copy256OutLoop

  popad
} // End asm
} // End of VESACopy256To256

// VOID VESAClear256 ( BYTE Color )
//
// EAX = Color

VOID VESAClear256 ( BYTE Color )
{
__asm {
  pushad

  mov  AL, Color

  mov  AH, AL
  mov  CX, AX
  shl  EAX, 16  
  mov  AX, CX
  
  mov  EDI, 0A0000h
  mov  BankNumber, 0
  
  SetBank 
  
  mov  EDX, ScreenLen
  sub  EDX, ScreenWd
  mov  ESI, ScreenHt
  cld

  Clear256OutLoop :
    mov ECX, ScreenWd
    mov EBX, ECX
    and EBX, 03h
    shr ECX, 2
    rep stosd
    mov ECX, EBX
    rep stosb
    add EDI, EDX
    cmp EDI, 0AFFFFh
    jle DoNextClear
      inc BankNumber
      SetBank 
      and EDI, 0AFFFFh
    
    DoNextClear :
      dec ESI
    jnz Clear256OutLoop

  popad
} // End asm
} // End of VESAClear256

