
; lg3drasw.asm
;
; Copyright (c) 1996 by Toshiaki Tsuji, all rights reserved.

; Functions
PUBLIC _SetViewPortData_

PUBLIC _DrawSolidNoHorz_, _DrawSolidGrdHorz_
PUBLIC _DrawTextureNoHorz_, _DrawTextureFlatHorz_, _DrawTextureGrdHorz_

PUBLIC _DrawSolidNoTransHorz_, _DrawSolidGrdTransHorz_
PUBLIC _DrawTextureNoTransHorz_, _DrawTextureFlatTransHorz_
PUBLIC _DrawTextureGrdTransHorz_

PUBLIC _DrawSolidNoHazeHorz_, _DrawSolidGrdHazeHorz_
PUBLIC _DrawTextureNoHazeHorz_, _DrawTextureFlatHazeHorz_, _DrawTextureGrdHazeHorz_

; Data
PUBLIC __LeftX, __LeftY, __LeftU, __LeftV, __LeftI, __LeftH, __LeftZ
PUBLIC __RightX, __RightY, __RightU, __RightV, __RightI, __RightH, __RightZ
PUBLIC __LeftDx, __LeftDy, __LeftDu, __LeftDv, __LeftDI, __LeftDh, __LeftDz 
PUBLIC __RightDx, __RightDy, __RightDu, __RightDv, __RightDI, __RightDh, __RightDz 
PUBLIC __DestBuffer, __AddDest, __ShadeBuffer, __TextureBuffer, __BlendBuffer
PUBLIC __HazeBuffer
PUBLIC __DivTable

.DATA
  __LeftX    DD 0 
  __LeftY    DD 0 
  __LeftU    DD 0 
  __LeftV    DD 0 
  __LeftI    DD 0 
  __LeftZ    DD 0
  __LeftH    DD 0
  
  __RightX   DD 0 
  __RightY   DD 0 
  __RightU   DD 0 
  __RightV   DD 0 
  __RightI   DD 0 
  __RightZ   DD 0
  __RightH   DD 0
  
  __LeftDx    DD 0 
  __LeftDy    DD 0 
  __LeftDu    DD 0 
  __LeftDv    DD 0 
  __LeftDI    DD 0 
  __LeftDz    DD 0
  __LeftDh    DD 0
  
  __RightDx   DD 0 
  __RightDy   DD 0 
  __RightDu   DD 0 
  __RightDv   DD 0 
  __RightDI   DD 0 
  __RightDz   DD 0
  __RightDh   DD 0
    
  __DestBuffer  DD 0
  __TextureBuffer  DD 0
  __AddDest     DD 0
  __ShadeBuffer DD 0
  __BlendBuffer DD 0
  __HazeBuffer  DD 0
  __DivTable    DD 0

  Color     DD 0  
  LoopCount DD 0 
  VMinX     DD 0
  VMaxX     DD 0
  VMinY     DD 0
  VMaxY     DD 0
  TempLen   DD 0  ; Before Clipped
  TempVal   DD 0 
  
  ; Inner Loop Delta
  InDeltaDI DD 0
  InDeltaDu DD 0
  InDeltaDv DD 0
  InDeltaDh DD 0

  DummyFloat DD 0
  InLoopCount DW 0

  DvD0   DD 0
  D0Du   DW 0
  DID0   DD 0

.CODE
.486

; _SetViewPortData ( LONG MinX, LONG MinY, LONG MaxX, LONG MaxY )
;
; EAX = MinX, EDX = MinY, EBX = MaxX, ECX = MaxY

_SetViewPortData_ PROC C
  mov  VMinX, EAX
  mov  VMinY, EDX
  mov  VMaxX, EBX
  mov  VMaxY, ECX
  ret
_SetViewPortData_ ENDP 


; _DrawSolidNoHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawSolidNoHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidNoHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedSolidNoHorz :
    cmp  ECX, 0
    jne  DrawSolidNoHorzClip

  DrawSolidNoHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidNoHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
      cmp  ECX, 0
      jle  NextRowSolidNoHorzNoClip 

      mov  EAX, Color         ; U
      mov  EDX, ECX           ; V
    
      shr  ECX, 2             ; U
      and  EDX, 3             ; V
      rep  stosd
      mov  ECX, EDX
      rep  stosb

      NextRowSolidNoHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidNoHorz
      jmp  EndLoopOutSolidNoHorz

  DrawSolidNoHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidNoHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidNoHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidNoHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidNoHorz
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightSolidNoHorz :
        cmp  ECX, VMaxX
        jle  StartSolidNoHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidNoHorz :
      sub  ECX, EAX
      inc  ECX
      cmp  ECX, 0
      jle  NextRowSolidNoHorz

      add  EDI, EAX           

      mov  EAX, Color         
      mov  EDX, ECX           
    
      shr  ECX, 2             
      and  EDX, 3             
      rep  stosd
      mov  ECX, EDX
      rep  stosb
    
      NextRowSolidNoHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidNoHorz

  EndLoopOutSolidNoHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawSolidNoHorz_ ENDP


; _DrawSolidGrdHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawSolidGrdHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidGrdHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDI
    imul  EBX
    add  __LeftI, EAX

    mov  EAX, __RightDI
    imul  EBX
    add  __RightI, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedSolidGrdHorz :
    cmp  ECX, 0
    jne  DrawSolidGrdHorzClip

  DrawSolidGrdHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidGrdHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V
      
      mov  EBX, __LeftI    ; U
      mov  EAX, EBX        ; U     EAX is the Left I
      add  EBX, __LeftDI   ; V
      mov  __LeftI, EBX    ; V
      
      mov  EBX, __RightI   ; U
      mov  EDX, EBX        ; U     EDX is the Right I
      add  EBX, __RightDI  ; V
      mov  __RightI, EBX   ; V
      
      cmp  ECX, 0
      jle  NextRowSolidGrdHorzNoClip

      mov  EBX, EAX        ; EBX is the Left I
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EBP, EBX
      mov  EAX, Color        
      mov  EDX, InDeltaDI 
      push ESI
      mov  ESI, __ShadeBuffer
      
        InLoopSolidGrdHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          add  EBP, EDX
          mov  AH, [EBX+ESI]
          mov  [EDI], AH
          inc  EDI
          loop InLoopSolidGrdHorz

      pop  ESI

      NextRowSolidGrdHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidGrdHorz
      jmp  EndLoopOutSolidGrdHorz

  DrawSolidGrdHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidGrdHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidGrdHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidGrdHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidGrdHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightSolidGrdHorz :
          cmp  ECX, VMaxX
          jle  StartSolidGrdHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidGrdHorz :  ; Clipped
      sub  ECX, EAX
      inc  ECX

      add  EDI, EAX

      mov  EBP, TempLen    ; EBP is the loop count before clipped
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EBX, __LeftI    ; U
      mov  EAX, EBX        ; U   EAX is the Left I
      add  EBX, __LeftDI   ; V
      mov  __LeftI, EBX    ; V
      
      mov  EBX, __RightI   ; U
      mov  EDX, EBX        ; U   EDX is the Right I
      add  EBX, __RightDI  ; V
      mov  __RightI, EBX   ; V
            
      cmp  ECX, 0
      jle  NextRowSolidGrdHorz

      mov  EBX, EAX        ; EAX is Left I
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDI, EAX

      ; Add Delta for Skipped pixel
      mov  EBP, EBX
      mov  EAX, InDeltaDI
      imul TempLen 
      add  EBP, EAX

      mov  EAX, Color        
      mov  EDX, InDeltaDI 
      push ESI
      mov  ESI, __ShadeBuffer
      
        InLoopClippedSolidGrdHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          mov  AH, [EBX+ESI]
          add  EBP, EDX
          mov  [EDI], AH
          inc  EDI
          loop InLoopClippedSolidGrdHorz
    
      pop  ESI
      NextRowSolidGrdHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidGrdHorz

  EndLoopOutSolidGrdHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawSolidGrdHorz_ ENDP


; _DrawTextureNoHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawTextureNoHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureNoHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDu
    imul  EBX
    add  __LeftU, EAX

    mov  EAX, __RightDu
    imul  EBX
    add  __RightU, EAX

    mov  EAX, __LeftDv
    imul  EBX
    add  __LeftV, EAX

    mov  EAX, __RightDv
    imul  EBX
    add  __RightV, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedTextureNoHorz :
    cmp  ECX, 0
    jne  DrawTextureNoHorzClip

  DrawTextureNoHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureNoHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
            
      cmp  ECX, 0
      jle  NextRowTextureNoHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP] 
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, __LeftU
      sar  ECX, 8
      mov  EDX, __LeftV
      sar  EDX, 8
      mov  ESI, __TextureBuffer
      mov  EBX, 0

        InLoopTextureNoHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  AL, [EBX+ESI]
          add  EDX, InDeltaDv
          mov  [EDI], AL
          inc  EDI
          dec  EBP
          jnz  InLoopTextureNoHorz

      pop  ESI

      NextRowTextureNoHorzNoClip :

      mov  EAX, __LeftU
      mov  EBX, __LeftV
      add  EAX, __LeftDu
      add  EBX, __LeftDv
      mov  __LeftU, EAX
      mov  __LeftV, EBX

      mov  EAX, __RightU
      mov  EBX, __RightV
      add  EAX, __RightDu
      add  EBX, __RightDv
      mov  __RightU, EAX
      mov  __RightV, EBX

      dec  ESI
      jnz  LoopOutTextureNoHorz
      jmp  EndLoopOutTextureNoHorz

  DrawTextureNoHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureNoHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureNoHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureNoHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureNoHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightTextureNoHorz :
        cmp  ECX, VMaxX
        jle  StartTextureNoHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureNoHorz :
      sub  ECX, EAX
      inc  ECX

      cmp  ECX, 0
      jle  NextRowTextureNoHorz

      add  EDI, EAX

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop
      mov  TempLen, EBX

      mov  EAX, __LeftU
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp  DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, __LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, __LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  ESI, __TextureBuffer
      mov  EBX, 0

        InLoopClippedTextureNoHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  AL, [EBX+ESI]
          add  EDX, InDeltaDv
          mov  [EDI], AL
          inc  EDI
          dec  EBP
          jnz  InLoopClippedTextureNoHorz

      pop  ESI

      NextRowTextureNoHorz : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        dec  ESI
      jnz  LoopOutClippedTextureNoHorz

  EndLoopOutTextureNoHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawTextureNoHorz_ ENDP


; _DrawTextureFlatHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawTextureFlatHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureFlatHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDu
    imul  EBX
    add  __LeftU, EAX

    mov  EAX, __RightDu
    imul  EBX
    add  __RightU, EAX

    mov  EAX, __LeftDv
    imul  EBX
    add  __LeftV, EAX

    mov  EAX, __RightDv
    imul  EBX
    add  __RightV, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedTextureFlatHorz :
    cmp  ECX, 0
    jne  DrawTextureFlatHorzClip

  DrawTextureFlatHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureFlatHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureFlatHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, __LeftU
      mov  EDX, __LeftV
      sar  ECX, 8
      sar  EDX, 8

      mov  EAX, __LeftI
      sar  EAX, 8
      mov  ESI, __ShadeBuffer
      
        InLoopTextureFlatHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  BL, [ESI+EAX]
          mov  [EDI], BL
          inc  EDI
          dec  EBP
          jnz  InLoopTextureFlatHorz
    
      pop  ESI

      NextRowTextureFlatHorzNoClip : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        dec  ESI
      jnz  LoopOutTextureFlatHorz
      jmp  EndLoopOutTextureFlatHorz

  DrawTextureFlatHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureFlatHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureFlatHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureFlatHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureFlatHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureFlatHorz :
          cmp  ECX, VMaxX
          jle  StartTextureFlatHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureFlatHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureFlatHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, __LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, __LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  EAX, __LeftI
      sar  EAX, 8
      mov  ESI, __ShadeBuffer
      
        InLoopClippedTextureFlatHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  BL, [ESI+EAX]
          mov  [EDI], BL
          inc  EDI
          dec  EBP
          jnz  InLoopClippedTextureFlatHorz
    
      pop  ESI

      NextRowTextureFlatHorz : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        dec  ESI
      jnz  LoopOutClippedTextureFlatHorz

  EndLoopOutTextureFlatHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawTextureFlatHorz_ ENDP


; _DrawTextureGrdHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawTextureGrdHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureGrdHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDu
    imul  EBX
    add  __LeftU, EAX

    mov  EAX, __RightDu
    imul  EBX
    add  __RightU, EAX

    mov  EAX, __LeftDv
    imul  EBX
    add  __LeftV, EAX

    mov  EAX, __RightDv
    imul  EBX
    add  __RightV, EAX

    mov  EAX, __LeftDI
    imul  EBX
    add  __LeftI, EAX

    mov  EAX, __RightDI
    imul  EBX
    add  __RightI, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedTextureGrdHorz :
    cmp  ECX, 0
    jne  DrawTextureGrdHorzClip

  DrawTextureGrdHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureGrdHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureGrdHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, __LeftI    ; U
      mov  EDX, __RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, __LeftU
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, __LeftU
      mov  EDX, __LeftV
      mov  ESI, __LeftI
      sar  ECX, 8
      sar  EDX, 8
      sar  ESI, 8
     
        InLoopTextureGrdHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, __ShadeBuffer
          mov  BL, [EAX]
          add  ESI, InDeltaDI
          mov  [EDI], BL
          inc  EDI
          dec  EBP
          jnz  InLoopTextureGrdHorz
   
      pop  ESI

      NextRowTextureGrdHorzNoClip :
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        mov  EAX, __LeftI
        mov  EBX, __RightI
        add  EAX, __LeftDI
        add  EBX, __RightDI
        mov  __LeftI, EAX
        mov  __RightI, EBX

        dec  ESI
      jnz  LoopOutTextureGrdHorz
      jmp  EndLoopOutTextureGrdHorz

  DrawTextureGrdHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureGrdHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureGrdHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureGrdHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureGrdHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureGrdHorz :
          cmp  ECX, VMaxX
          jle  StartTextureGrdHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureGrdHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureGrdHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, __LeftI    ; U
      mov  EDX, __RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, __LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDI
      imul TempLen
      mov  ESI, __LeftI
      sar  ESI, 8
      add  ESI, EAX
      
      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, __LeftV
      sar  EDX, 8
      add  EDX, EAX

        InLoopClippedTextureGrdHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, __ShadeBuffer
          mov  BL, [EAX]
          add  ESI, InDeltaDI
          mov  [EDI], BL
          inc  EDI
          dec  EBP
          jnz  InLoopClippedTextureGrdHorz
    
      pop  ESI

      NextRowTextureGrdHorz : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX
   
        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        mov  EAX, __LeftI
        mov  EBX, __RightI
        add  EAX, __LeftDI
        add  EBX, __RightDI
        mov  __LeftI, EAX
        mov  __RightI, EBX

        dec  ESI
      jnz  LoopOutClippedTextureGrdHorz

  EndLoopOutTextureGrdHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawTextureGrdHorz_ ENDP

;***************************************************
;
;  Transparent Routines
;
;***************************************************

; _DrawSolidNoTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawSolidNoTransHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidNoTransHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedSolidNoTransHorz :
    cmp  ECX, 0
    jne  DrawSolidNoTransHorzClip

  DrawSolidNoTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidNoTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
      cmp  ECX, 0
      jle  NextRowSolidNoTransHorzNoClip 

      mov  EAX, Color         
      and  EAX, 0000FF00h
      mov  EBP, __BlendBuffer
      
        InLoopSolidNoTransHorz :
          mov  AL, [EDI]
          mov  AL, [EBP+EAX]
          mov  [EDI], AL
          inc  EDI
          loop InLoopSolidNoTransHorz
          
      NextRowSolidNoTransHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidNoTransHorz
      jmp  EndLoopOutSolidNoTransHorz

  DrawSolidNoTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidNoTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidNoTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidNoTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidNoTransHorz
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightSolidNoTransHorz :
        cmp  ECX, VMaxX
        jle  StartSolidNoTransHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidNoTransHorz :
      sub  ECX, EAX
      inc  ECX
      cmp  ECX, 0
      jle  NextRowSolidNoTransHorz

      add  EDI, EAX           

      mov  EAX, Color         
      and  EAX, 0000FF00h
      mov  EBP, __BlendBuffer
      
        InLoopClippedSolidNoTransHorz :
          mov  AL, [EDI]
          mov  AL, [EBP+EAX]
          mov  [EDI], AL
          inc  EDI
          loop InLoopClippedSolidNoTransHorz
          
      NextRowSolidNoTransHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidNoTransHorz

  EndLoopOutSolidNoTransHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawSolidNoTransHorz_ ENDP


; _DrawSolidGrdTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawSolidGrdTransHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidGrdTransHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDI
    imul  EBX
    add  __LeftI, EAX

    mov  EAX, __RightDI
    imul  EBX
    add  __RightI, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedSolidGrdTransHorz :
    cmp  ECX, 0
    jne  DrawSolidGrdTransHorzClip

  DrawSolidGrdTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidGrdTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V
      
      mov  EBX, __LeftI    ; U
      mov  EAX, EBX        ; U     EAX is the Left I
      add  EBX, __LeftDI   ; V
      mov  __LeftI, EBX    ; V
      
      mov  EBX, __RightI   ; U
      mov  EDX, EBX        ; U     EDX is the Right I
      add  EBX, __RightDI  ; V
      mov  __RightI, EBX   ; V
      
      cmp  ECX, 0
      jle  NextRowSolidGrdTransHorzNoClip

      mov  EBX, EAX        ; EBX is the Left I
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EBP, EBX
      mov  EAX, Color        
      mov  EDX, __BlendBuffer 
      push ESI
      mov  ESI, __ShadeBuffer
      
        InLoopSolidGrdTransHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          add  EBP, InDeltaDI
          mov  BH, [EBX+ESI]
          mov  BL, [EDI]
          mov  AH, [EDX+EBX]
          mov  [EDI], AH
          inc  EDI
          loop InLoopSolidGrdTransHorz

      pop  ESI

      NextRowSolidGrdTransHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidGrdTransHorz
      jmp  EndLoopOutSolidGrdTransHorz

  DrawSolidGrdTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidGrdTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidGrdTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidGrdTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidGrdTransHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightSolidGrdTransHorz :
          cmp  ECX, VMaxX
          jle  StartSolidGrdTransHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidGrdTransHorz :  ; Clipped
      sub  ECX, EAX
      inc  ECX

      add  EDI, EAX

      mov  EBP, TempLen    ; EBP is the loop count before clipped
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EBX, __LeftI    ; U
      mov  EAX, EBX        ; U   EAX is the Left I
      add  EBX, __LeftDI   ; V
      mov  __LeftI, EBX    ; V
      
      mov  EBX, __RightI   ; U
      mov  EDX, EBX        ; U   EDX is the Right I
      add  EBX, __RightDI  ; V
      mov  __RightI, EBX   ; V
            
      cmp  ECX, 0
      jle  NextRowSolidGrdTransHorz

      mov  EBX, EAX        ; EAX is Left I
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDI, EAX

      ; Add Delta for Skipped pixel
      mov  EBP, EBX
      mov  EAX, InDeltaDI
      imul TempLen 
      add  EBP, EAX

      mov  EAX, Color        
      mov  EDX, __BlendBuffer
      push ESI
      mov  ESI, __ShadeBuffer
      
        InLoopClippedSolidGrdTransHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          add  EBP, InDeltaDI
          mov  BH, [EBX+ESI]
          mov  BL, [EDI]
          mov  AH, [EDX+EBX]
          mov  [EDI], AH
          inc  EDI
          loop InLoopClippedSolidGrdTransHorz
    
      pop  ESI
      NextRowSolidGrdTransHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidGrdTransHorz

  EndLoopOutSolidGrdTransHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawSolidGrdTransHorz_ ENDP


; _DrawTextureNoTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawTextureNoTransHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureNoTransHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDu
    imul  EBX
    add  __LeftU, EAX

    mov  EAX, __RightDu
    imul  EBX
    add  __RightU, EAX

    mov  EAX, __LeftDv
    imul  EBX
    add  __LeftV, EAX

    mov  EAX, __RightDv
    imul  EBX
    add  __RightV, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedTextureNoTransHorz :
    cmp  ECX, 0
    jne  DrawTextureNoTransHorzClip

  DrawTextureNoTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureNoTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
            
      cmp  ECX, 0
      jle  NextRowTextureNoTransHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP] 
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, __LeftU
      sar  ECX, 8
      mov  EDX, __LeftV
      sar  EDX, 8
      mov  ESI, __TextureBuffer
      mov  EBX, 0
      mov  EAX, 0
      mov  InLoopCount, BP
      mov  EBP, __BlendBuffer

        InLoopTextureNoTransHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  AL, [EDI]
          mov  AH, [EBX+ESI]
          add  EDX, InDeltaDv
          mov  AL, [EBP+EAX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureNoTransHorz

      pop  ESI

      NextRowTextureNoTransHorzNoClip :

      mov  EAX, __LeftU
      mov  EBX, __LeftV
      add  EAX, __LeftDu
      add  EBX, __LeftDv
      mov  __LeftU, EAX
      mov  __LeftV, EBX

      mov  EAX, __RightU
      mov  EBX, __RightV
      add  EAX, __RightDu
      add  EBX, __RightDv
      mov  __RightU, EAX
      mov  __RightV, EBX

      dec  ESI
      jnz  LoopOutTextureNoTransHorz
      jmp  EndLoopOutTextureNoTransHorz

  DrawTextureNoTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureNoTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureNoTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureNoTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureNoTransHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightTextureNoTransHorz :
        cmp  ECX, VMaxX
        jle  StartTextureNoTransHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureNoTransHorz :
      sub  ECX, EAX
      inc  ECX

      cmp  ECX, 0
      jle  NextRowTextureNoTransHorz

      add  EDI, EAX

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop
      mov  TempLen, EBX

      mov  EAX, __LeftU
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp  DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, __LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, __LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  ESI, __TextureBuffer
      mov  EBX, 0
      mov  EAX, 0
      mov  InLoopCount, BP
      mov  EBP, __BlendBuffer

        InLoopClippedTextureNoTransHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  AL, [EDI]
          mov  AH, [EBX+ESI]
          add  EDX, InDeltaDv
          mov  AL, [EBP+EAX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureNoTransHorz

      pop  ESI

      NextRowTextureNoTransHorz : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        dec  ESI
      jnz  LoopOutClippedTextureNoTransHorz

  EndLoopOutTextureNoTransHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawTextureNoTransHorz_ ENDP


; _DrawTextureFlatTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawTextureFlatTransHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureFlatTransHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDu
    imul  EBX
    add  __LeftU, EAX

    mov  EAX, __RightDu
    imul  EBX
    add  __RightU, EAX

    mov  EAX, __LeftDv
    imul  EBX
    add  __LeftV, EAX

    mov  EAX, __RightDv
    imul  EBX
    add  __RightV, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedTextureFlatTransHorz :
    cmp  ECX, 0
    jne  DrawTextureFlatTransHorzClip

  DrawTextureFlatTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureFlatTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureFlatTransHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, __LeftU
      mov  EDX, __LeftV
      sar  ECX, 8
      sar  EDX, 8

      mov  EAX, __LeftI
      sar  EAX, 8
      mov  ESI, __ShadeBuffer
      mov  InLoopCount, BP
      mov  EBP, __BlendBuffer
      
        InLoopTextureFlatTransHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  BL, [EDI]
          mov  BH, [ESI+EAX]
          and  EBX, 0FFFFh
          mov  AL, [EBP+EBX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureFlatTransHorz
    
      pop  ESI

      NextRowTextureFlatTransHorzNoClip : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        dec  ESI
      jnz  LoopOutTextureFlatTransHorz
      jmp  EndLoopOutTextureFlatTransHorz

  DrawTextureFlatTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureFlatTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureFlatTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureFlatTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureFlatTransHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureFlatTransHorz :
          cmp  ECX, VMaxX
          jle  StartTextureFlatTransHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureFlatTransHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureFlatTransHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, __LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, __LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  EAX, __LeftI
      sar  EAX, 8
      mov  ESI, __ShadeBuffer
      mov  InLoopCount, BP
      mov  EBP, __BlendBuffer
      
        InLoopClippedTextureFlatTransHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  BL, [EDI]
          mov  BH, [ESI+EAX]
          and  EBX, 0FFFFh
          mov  AL, [EBP+EBX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureFlatTransHorz
    
      pop  ESI

      NextRowTextureFlatTransHorz : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        dec  ESI
      jnz  LoopOutClippedTextureFlatTransHorz

  EndLoopOutTextureFlatTransHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawTextureFlatTransHorz_ ENDP


; _DrawTextureGrdTransHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawTextureGrdTransHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureGrdTransHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDu
    imul  EBX
    add  __LeftU, EAX

    mov  EAX, __RightDu
    imul  EBX
    add  __RightU, EAX

    mov  EAX, __LeftDv
    imul  EBX
    add  __LeftV, EAX

    mov  EAX, __RightDv
    imul  EBX
    add  __RightV, EAX

    mov  EAX, __LeftDI
    imul  EBX
    add  __LeftI, EAX

    mov  EAX, __RightDI
    imul  EBX
    add  __RightI, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedTextureGrdTransHorz :
    cmp  ECX, 0
    jne  DrawTextureGrdTransHorzClip

  DrawTextureGrdTransHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureGrdTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureGrdTransHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, __LeftI    ; U
      mov  EDX, __RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, __LeftU
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, __LeftU
      mov  EDX, __LeftV
      mov  ESI, __LeftI
      sar  ECX, 8
      sar  EDX, 8
      sar  ESI, 8
      mov  InLoopCount, BP
      mov  EBP, __BlendBuffer
     
        InLoopTextureGrdTransHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, __ShadeBuffer
          mov  BL, [EDI]
          mov  BH, [EAX]
          and  EBX, 0FFFFh
          add  ESI, InDeltaDI
          mov  AL, [EBP+EBX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureGrdTransHorz
   
      pop  ESI

      NextRowTextureGrdTransHorzNoClip :
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        mov  EAX, __LeftI
        mov  EBX, __RightI
        add  EAX, __LeftDI
        add  EBX, __RightDI
        mov  __LeftI, EAX
        mov  __RightI, EBX

        dec  ESI
      jnz  LoopOutTextureGrdTransHorz
      jmp  EndLoopOutTextureGrdTransHorz

  DrawTextureGrdTransHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdTransHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureGrdTransHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureGrdTransHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureGrdTransHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureGrdTransHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureGrdTransHorz :
          cmp  ECX, VMaxX
          jle  StartTextureGrdTransHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureGrdTransHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureGrdTransHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, __LeftI    ; U
      mov  EDX, __RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, __LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDI
      imul TempLen
      mov  ESI, __LeftI
      sar  ESI, 8
      add  ESI, EAX
      
      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, __LeftV
      sar  EDX, 8
      add  EDX, EAX
      mov  InLoopCount, BP
      mov  EBP, __BlendBuffer

        InLoopClippedTextureGrdTransHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, __ShadeBuffer
          mov  BL, [EDI]
          mov  BH, [EAX]
          and  EBX, 0FFFFh
          add  ESI, InDeltaDI
          mov  AL, [EBP+EBX]
          mov  [EDI], AL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureGrdTransHorz
    
      pop  ESI

      NextRowTextureGrdTransHorz : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX
   
        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        mov  EAX, __LeftI
        mov  EBX, __RightI
        add  EAX, __LeftDI
        add  EBX, __RightDI
        mov  __LeftI, EAX
        mov  __RightI, EBX

        dec  ESI
      jnz  LoopOutClippedTextureGrdTransHorz

  EndLoopOutTextureGrdTransHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawTextureGrdTransHorz_ ENDP


;***************************************************
;
;  Hazing Routines
;
;***************************************************

; _DrawSolidNoHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawSolidNoHazeHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidNoHazeHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDh
    imul  EBX
    add  __LeftH, EAX

    mov  EAX, __RightDh
    imul  EBX
    add  __RightH, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedSolidNoHazeHorz :
    cmp  ECX, 0
    jne  DrawSolidNoHazeHorzClip

  DrawSolidNoHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidNoHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V
      
      mov  EBX, __LeftH    ; U
      mov  EAX, EBX        ; U   EAX is the Left Haze
      add  EBX, __LeftDh   ; V
      mov  __LeftH, EBX    ; V
      
      mov  EBX, __RightH   ; U
      mov  EDX, EBX        ; U   EDX is the Right Haze
      add  EBX, __RightDh  ; V
      mov  __RightH, EBX   ; V
            
      cmp  ECX, 0
      jle  NextRowSolidNoHazeHorzNoClip
      
      mov  EBX, EAX        ; EBX is the Left Haze
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EBP, __LeftH
      mov  EAX, Color        
      mov  EDX, InDeltaDh
      push ESI
      mov  ESI, __HazeBuffer
      
        InLoopSolidNoHazeHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          add  EBP, EDX
          mov  AH, [EBX+ESI]
          mov  [EDI], AH
          inc  EDI
          loop InLoopSolidNoHazeHorz

      pop  ESI

      NextRowSolidNoHazeHorzNoClip :
        dec  ESI
        jnz  LoopOutSolidNoHazeHorz
      jmp  EndLoopOutSolidNoHazeHorz

  DrawSolidNoHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidNoHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidNoHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidNoHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidNoHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidNoHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightSolidNoHazeHorz :
          cmp  ECX, VMaxX
          jle  StartSolidNoHazeHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidNoHazeHorz :  ; Clipped
      sub  ECX, EAX
      inc  ECX

      add  EDI, EAX

      mov  EBP, TempLen    ; EBP is the loop count before clipped
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EBX, __LeftH    ; U
      mov  EAX, EBX        ; U   EAX is the Left Haze
      add  EBX, __LeftDh   ; V
      mov  __LeftH, EBX    ; V
      
      mov  EBX, __RightH   ; U
      mov  EDX, EBX        ; U   EDX is the Right Haze
      add  EBX, __RightDh  ; V
      mov  __RightH, EBX   ; V
            
      cmp  ECX, 0
      jle  NextRowSolidNoHazeHorz

      mov  EBX, EAX        ; EAX is Left Haze
      sub  EDX, EAX
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDh, EAX

      ; Add Delta for Skipped pixel
      mov  EBP, __LeftH
      mov  EAX, InDeltaDh
      imul TempLen 
      add  EBP, EAX

      mov  EAX, Color        
      mov  EDX, InDeltaDh 
      push ESI
      mov  ESI, __HazeBuffer
      
        InLoopClippedSolidNoHazeHorz :
          mov  EBX, EBP
          shr  EBX, 8
          mov  BL, AL
          mov  AH, [EBX+ESI]
          add  EBP, EDX
          mov  [EDI], AH
          inc  EDI
          loop InLoopClippedSolidNoHazeHorz
    
      pop  ESI
      NextRowSolidNoHazeHorz : 
        dec  ESI
      jnz  LoopOutClippedSolidNoHazeHorz

  EndLoopOutSolidNoHazeHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawSolidNoHazeHorz_ ENDP


; _DrawSolidGrdHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawSolidGrdHazeHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedSolidGrdHazeHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDI
    imul  EBX
    add  __LeftI, EAX

    mov  EAX, __RightDI
    imul  EBX
    add  __RightI, EAX

    mov  EAX, __LeftDh
    imul  EBX
    add  __LeftH, EAX

    mov  EAX, __RightDh
    imul  EBX
    add  __RightH, EAX

    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedSolidGrdHazeHorz :
    cmp  ECX, 0
    jne  DrawSolidGrdHazeHorzClip

  DrawSolidGrdHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutSolidGrdHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V
      
      cmp  ECX, 0
      jle  NextRowSolidGrdHazeHorzNoClip

      mov  EAX, __LeftI    ; U     EAX is the Left I
      mov  EDX, __RightI   ; U     EDX is the Right I      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, __LeftH    ; U     EAX is the Left Haze
      mov  EDX, __RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EBP, __LeftI
      sar  EBP, 8
      mov  EAX, Color        
      mov  EDX, __HazeBuffer
      push ESI
      mov  ESI, __ShadeBuffer
      mov  InLoopCount, CX
      mov  ECX, __LeftH
      sar  ECX, 8
      
        InLoopSolidGrdHazeHorz :
          mov  EBX, EBP
          mov  BL, AL
          add  EBP, InDeltaDI
          mov  AH, [EBX+ESI]
          mov  EBX, ECX
          mov  BL, AH
          add  ECX, InDeltaDh
          mov  AH, [EBX+EDX]
          mov  [EDI], AH
          inc  EDI
          dec  InLoopCount
          jnz  InLoopSolidGrdHazeHorz

      pop  ESI

      NextRowSolidGrdHazeHorzNoClip :
        mov  EAX, __LeftI
        mov  EBX, __RightI
        add  EAX, __LeftDI
        add  EBX, __RightDI
        mov  __LeftI, EAX
        mov  __RightI, EBX

        mov  EAX, __LeftH
        mov  EBX, __RightH
        add  EAX, __LeftDh
        add  EBX, __RightDh
        mov  __LeftH, EAX
        mov  __RightH, EBX

        dec  ESI
        jnz  LoopOutSolidGrdHazeHorz
      jmp  EndLoopOutSolidGrdHazeHorz

  DrawSolidGrdHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutSolidGrdHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedSolidGrdHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowSolidGrdHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowSolidGrdHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightSolidGrdHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightSolidGrdHazeHorz :
          cmp  ECX, VMaxX
          jle  StartSolidGrdHazeHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartSolidGrdHazeHorz :  ; Clipped
      sub  ECX, EAX
      inc  ECX
      cmp  ECX, 0
      jle  NextRowSolidGrdHazeHorz

      add  EDI, EAX
      
      mov  EBP, TempLen    ; EBP is the loop count before clipped
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, __LeftI    ; U     EAX is the Left I
      mov  EDX, __RightI   ; U     EDX is the Right I      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDI, EAX

      mov  EAX, __LeftH    ; U     EAX is the Left Haze
      mov  EDX, __RightH   ; U     EDX is the Right Haze            
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDh, EAX

      mov  InLoopCount, CX
      
      ; Add Delta for Skipped pixel
      mov  EBP, __LeftI
      sar  EBP, 8
      mov  EAX, InDeltaDI
      imul TempLen 
      add  EBP, EAX

      mov  ECX, __LeftH
      sar  ECX, 8
      mov  EAX, InDeltaDh
      imul TempLen 
      add  ECX, EAX
      
      mov  EAX, Color        
      mov  EDX, __HazeBuffer
      push ESI
      mov  ESI, __ShadeBuffer
      
        InLoopClippedSolidGrdHazeHorz :
          mov  EBX, EBP
          mov  BL, AL
          add  EBP, InDeltaDI
          mov  AH, [EBX+ESI]
          mov  EBX, ECX
          mov  BL, AH
          add  ECX, InDeltaDh
          mov  AH, [EBX+EDX]
          mov  [EDI], AH
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedSolidGrdHazeHorz
    
      pop  ESI
      
      NextRowSolidGrdHazeHorz : 
        mov  EAX, __LeftI
        mov  EBX, __RightI
        add  EAX, __LeftDI
        add  EBX, __RightDI
        mov  __LeftI, EAX
        mov  __RightI, EBX

        mov  EAX, __LeftH
        mov  EBX, __RightH
        add  EAX, __LeftDh
        add  EBX, __RightDh
        mov  __LeftH, EAX
        mov  __RightH, EBX

        dec  ESI
      jnz  LoopOutClippedSolidGrdHazeHorz

  EndLoopOutSolidGrdHazeHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawSolidGrdHazeHorz_ ENDP

; _DrawTextureNoHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawTextureNoHazeHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureNoHazeHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDu
    imul  EBX
    add  __LeftU, EAX

    mov  EAX, __RightDu
    imul  EBX
    add  __RightU, EAX

    mov  EAX, __LeftDv
    imul  EBX
    add  __LeftV, EAX

    mov  EAX, __RightDv
    imul  EBX
    add  __RightV, EAX

    mov  EAX, __LeftDh
    imul  EBX
    add  __LeftH, EAX

    mov  EAX, __RightDh
    imul  EBX
    add  __RightH, EAX
    
    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedTextureNoHazeHorz :
    cmp  ECX, 0
    jne  DrawTextureNoHazeHorzClip

  DrawTextureNoHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureNoHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      sub  ECX, EAX           ; V
      add  EDI, EAX           ; U
      inc  ECX                ; V
            
      cmp  ECX, 0
      jle  NextRowTextureNoHazeHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP] 
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, __LeftH    ; U     EAX is the Left Haze
      mov  EDX, __RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  EAX, __LeftH
      sar  EAX, 8
      mov  ECX, __LeftU
      sar  ECX, 8
      mov  EDX, __LeftV
      sar  EDX, 8
      mov  ESI, __TextureBuffer
      mov  InLoopCount, BP
      mov  EBP, __HazeBuffer
      mov  EBX, 0

        InLoopTextureNoHazeHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  BL, [EBX+ESI]
          mov  BH, AH
          add  EAX, InDeltaDh          
          mov  BL, [EBX+EBP]
          add  EDX, InDeltaDv
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureNoHazeHorz

      pop  ESI

      NextRowTextureNoHazeHorzNoClip :

      mov  EAX, __LeftU
      mov  EBX, __LeftV
      add  EAX, __LeftDu
      add  EBX, __LeftDv
      mov  __LeftU, EAX
      mov  __LeftV, EBX

      mov  EAX, __RightU
      mov  EBX, __RightV
      add  EAX, __RightDu
      add  EBX, __RightDv
      mov  __RightU, EAX
      mov  __RightV, EBX

      mov  EAX, __LeftH
      mov  EBX, __RightH
      add  EAX, __LeftDh
      add  EBX, __RightDh
      mov  __LeftH, EAX
      mov  __RightH, EBX

      dec  ESI
      jnz  LoopOutTextureNoHazeHorz
      jmp  EndLoopOutTextureNoHazeHorz

  DrawTextureNoHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureNoHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureNoHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureNoHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureNoHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureNoHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
      CheckRightTextureNoHazeHorz :
        cmp  ECX, VMaxX
        jle  StartTextureNoHazeHorz
        mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureNoHazeHorz :
      sub  ECX, EAX
      inc  ECX

      cmp  ECX, 0
      jle  NextRowTextureNoHazeHorz

      add  EDI, EAX

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, TempLen
      mov  TempLen, EBX

      mov  EAX, __LeftH    ; U     EAX is the Left Haze
      mov  EDX, __RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv EBP
      mov  InDeltaDh, EAX

      mov  EAX, __LeftU
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp  DummyFloat

      push ESI

      mov  InLoopCount, CX

      mov  EAX, InDeltaDh
      imul TempLen
      mov  EBX, __LeftH
      sar  EBX, 8
      add  EBX, EAX

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, __LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, __LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  EAX, EBX
      mov  EBP, __HazeBuffer      
      mov  ESI, __TextureBuffer
      mov  EBX, 0

        InLoopClippedTextureNoHazeHorz :
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          mov  BL, [EBX+ESI]
          mov  BH, AH
          add  EAX, InDeltaDh          
          mov  BL, [EBX+EBP]
          add  EDX, InDeltaDv
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureNoHazeHorz

      pop  ESI

      NextRowTextureNoHazeHorz : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        mov  EAX, __LeftH
        mov  EBX, __RightH
        add  EAX, __LeftDh
        add  EBX, __RightDh
        mov  __LeftH, EAX
        mov  __RightH, EBX

        dec  ESI
      jnz  LoopOutClippedTextureNoHazeHorz

  EndLoopOutTextureNoHazeHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawTextureNoHazeHorz_ ENDP


; _DrawTextureFlatHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawTextureFlatHazeHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureFlatHazeHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDu
    imul  EBX
    add  __LeftU, EAX

    mov  EAX, __RightDu
    imul  EBX
    add  __RightU, EAX

    mov  EAX, __LeftDv
    imul  EBX
    add  __LeftV, EAX

    mov  EAX, __RightDv
    imul  EBX
    add  __RightV, EAX

    mov  EAX, __LeftDh
    imul  EBX
    add  __LeftH, EAX

    mov  EAX, __RightDh
    imul  EBX
    add  __RightH, EAX
    
    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedTextureFlatHazeHorz :
    cmp  ECX, 0
    jne  DrawTextureFlatHazeHorzClip

  DrawTextureFlatHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureFlatHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureFlatHazeHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, __LeftH    ; U     EAX is the Left Haze
      mov  EDX, __RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, __LeftU
      mov  EDX, __LeftV
      sar  ECX, 8
      sar  EDX, 8

      mov  EAX, __LeftI
      sar  EAX, 8
      mov  ESI, __ShadeBuffer
      mov  InLoopCount, BP
      mov  EBP, __LeftH
      sar  EBP, 8
      
        InLoopTextureFlatHazeHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  EBX, EBP
          mov  BL, [ESI+EAX]
          add  EBX, __HazeBuffer
          add  EBP, InDeltaDh
          mov  BL, [EBX]
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureFlatHazeHorz
    
      pop  ESI

      NextRowTextureFlatHazeHorzNoClip : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        mov  EAX, __LeftH
        mov  EBX, __RightH
        add  EAX, __LeftDh
        add  EBX, __RightDh
        mov  __LeftH, EAX
        mov  __RightH, EBX

        dec  ESI
      jnz  LoopOutTextureFlatHazeHorz
      jmp  EndLoopOutTextureFlatHazeHorz

  DrawTextureFlatHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureFlatHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureFlatHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureFlatHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureFlatHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureFlatHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureFlatHazeHorz :
          cmp  ECX, VMaxX
          jle  StartTextureFlatHazeHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureFlatHazeHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureFlatHazeHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, __LeftH    ; U     EAX is the Left Haze
      mov  EDX, __RightH   ; U     EDX is the Right Haze      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  InLoopCount, BP
      
      mov  EAX, InDeltaDh
      imul TempLen
      mov  EBP, __LeftH
      sar  EBP, 8
      add  EBP, EAX

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, __LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, __LeftV
      sar  EDX, 8
      add  EDX, EAX

      mov  EAX, __LeftI
      sar  EAX, 8
      mov  ESI, __ShadeBuffer
      
        InLoopClippedTextureFlatHazeHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          mov  EBX, EBP
          mov  BL, [ESI+EAX]
          add  EBX, __HazeBuffer
          add  EBP, InDeltaDh
          mov  BL, [EBX]
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureFlatHazeHorz
    
      pop  ESI

      NextRowTextureFlatHazeHorz : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        mov  EAX, __LeftH
        mov  EBX, __RightH
        add  EAX, __LeftDh
        add  EBX, __RightDh
        mov  __LeftH, EAX
        mov  __RightH, EBX

        dec  ESI
      jnz  LoopOutClippedTextureFlatHazeHorz

  EndLoopOutTextureFlatHazeHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawTextureFlatHazeHorz_ ENDP


; _DrawTextureGrdHazeHorz ( LONG Color, LONG LoopCount, LONG SkipRow, LONG SideClipped )
;
; EAX = Color, EDX = LoopCount, EBX = SkipRow, ECX = SideClipped

_DrawTextureGrdHazeHorz_ PROC C
  push EBP
  push EDI
  push ESI  
  
  mov  Color, EAX

  sub  EDX, EBX
  mov  LoopCount, EDX

  cmp  EBX, 0
  je   CheckClippedTextureGrdHazeHorz 

    mov  EAX, __LeftDx
    imul  EBX
    add  __LeftX, EAX

    mov  EAX, __RightDx
    imul  EBX
    add  __RightX, EAX

    mov  EAX, __LeftDu
    imul  EBX
    add  __LeftU, EAX

    mov  EAX, __RightDu
    imul  EBX
    add  __RightU, EAX

    mov  EAX, __LeftDv
    imul  EBX
    add  __LeftV, EAX

    mov  EAX, __RightDv
    imul  EBX
    add  __RightV, EAX

    mov  EAX, __LeftDI
    imul  EBX
    add  __LeftI, EAX

    mov  EAX, __RightDI
    imul  EBX
    add  __RightI, EAX

    mov  EAX, __LeftDh
    imul  EBX
    add  __LeftH, EAX

    mov  EAX, __RightDh
    imul  EBX
    add  __RightH, EAX
    
    mov  EAX, __AddDest
    imul  EBX
    add  __DestBuffer, EAX

  CheckClippedTextureGrdHazeHorz :
    cmp  ECX, 0
    jne  DrawTextureGrdHazeHorzClip

  DrawTextureGrdHazeHorzNoClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutTextureGrdHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      sub  ECX, EAX           ; U

      mov  __DestBuffer, EBX  ; V

      add  EDI, EAX           ; U
      inc  ECX                ; V

      cmp  ECX, 0
      jle  NextRowTextureGrdHazeHorzNoClip

      mov  EBP, ECX
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]
      
      mov  EBP, ECX      ; EBP is the loop

      mov  EAX, __LeftI    ; U
      mov  EDX, __RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, __LeftH    ; U
      mov  EDX, __RightH   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, __LeftU
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  ECX, __LeftU
      mov  EDX, __LeftV
      mov  ESI, __LeftI
      sar  ECX, 8
      sar  EDX, 8
      sar  ESI, 8
      mov  InLoopCount, BP
      mov  EBP, __LeftH
      sar  EBP, 8
     
        InLoopTextureGrdHazeHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, __ShadeBuffer
          mov  EBX, EBP
          mov  BL, [EAX]
          add  EBX, __HazeBuffer
          add  EBP, InDeltaDh
          add  ESI, InDeltaDI
          mov  BL, [EBX]
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopTextureGrdHazeHorz
   
      pop  ESI

      NextRowTextureGrdHazeHorzNoClip :
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX

        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        mov  EAX, __LeftI
        mov  EBX, __RightI
        add  EAX, __LeftDI
        add  EBX, __RightDI
        mov  __LeftI, EAX
        mov  __RightI, EBX

        mov  EAX, __LeftH
        mov  EBX, __RightH
        add  EAX, __LeftDh
        add  EBX, __RightDh
        mov  __LeftH, EAX
        mov  __RightH, EBX

        dec  ESI
      jnz  LoopOutTextureGrdHazeHorz
      jmp  EndLoopOutTextureGrdHazeHorz

  DrawTextureGrdHazeHorzClip :
    cld
    mov  ESI, LoopCount
    cmp  ESI, 0
    jle  EndLoopOutTextureGrdHazeHorz
    adc  EAX, 0        ; Make sure the loop starts with U pipe
    nop          

    LoopOutClippedTextureGrdHazeHorz :
      mov  EBX, __LeftX    ; U
      mov  EAX, EBX        ; U
      add  EBX, __LeftDx   ; V
      sar  EAX, 16         ; U EAX is the Left X
      mov  __LeftX, EBX    ; V

      mov  EDX, __RightX   ; U
      mov  ECX, EDX        ; U
      add  EDX, __RightDx  ; V
      sar  ECX, 16         ; U ECX is the Right X
      mov  __RightX, EDX   ; V

      mov  EBX, __DestBuffer  ; U
      mov  EDI, EBX           ; U
      add  EBX, __AddDest     ; V
      mov  __DestBuffer, EBX  ; U

      mov  TempLen, ECX
      sub  TempLen, EAX
      inc  TempLen
      mov  EBX, 0

        ; Check for Easy reject
        cmp  EAX, VMaxX      ; Left is greater than MaxX
        jg   NextRowTextureGrdHazeHorz
        cmp  ECX, VMinX      ; Right is smaller than MinX
        jl   NextRowTextureGrdHazeHorz

        ; Check for Left
        cmp  EAX, VMinX
        jge  CheckRightTextureGrdHazeHorz
          mov  EBX, VMinX
          sub  EBX, EAX
          mov  EAX, VMinX    ; Set Left to MinX

        ; Check for Right
        CheckRightTextureGrdHazeHorz :
          cmp  ECX, VMaxX
          jle  StartTextureGrdHazeHorz
          mov  ECX, VMaxX    ; Set Right to MaxX

    StartTextureGrdHazeHorz :
      sub  ECX, EAX
      inc  ECX
      add  EDI, EAX

      cmp  ECX, 0
      jle  NextRowTextureGrdHazeHorz

      mov  EBP, TempLen
      shl  EBP, 2
      add  EBP, __DivTable
      fld  dword ptr [EBP]

      mov  EBP, ECX      ; EBP is the loop

      mov  ECX, TempLen
      mov  TempLen, EBX    ; TempLen is now the skip pixel in x-direction

      mov  EAX, __LeftI    ; U
      mov  EDX, __RightI   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDI, EAX

      mov  EAX, __LeftH    ; U
      mov  EDX, __RightH   ; U      
      sub  EDX, EAX
      sar  EDX, 8
      mov  EAX, EDX
      sar  EDX, 01Fh
      idiv ECX
      mov  InDeltaDh, EAX

      mov  EAX, __LeftU    
      mov  EDX, __RightU         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDu, EDX
      fild InDeltaDu      
      fmul st, st(1)
      fistp InDeltaDu
      
      mov  EAX, __LeftV    
      mov  EDX, __RightV         
      sub  EDX, EAX
      sar  EDX, 8
      mov  InDeltaDv, EDX
      fild InDeltaDv      
      fmul st, st(1)
      fistp InDeltaDv

      fstp DummyFloat

      push ESI

      mov  InLoopCount, BP
      
      mov  EAX, InDeltaDh
      imul TempLen
      mov  EBP, __LeftH
      sar  EBP, 8
      add  EBP, EAX

      mov  EAX, InDeltaDu
      imul TempLen
      mov  ECX, __LeftU
      sar  ECX, 8
      add  ECX, EAX

      mov  EAX, InDeltaDI
      imul TempLen
      mov  ESI, __LeftI
      sar  ESI, 8
      add  ESI, EAX
      
      mov  EAX, InDeltaDv
      imul TempLen
      mov  EDX, __LeftV
      sar  EDX, 8
      add  EDX, EAX
       
        InLoopClippedTextureGrdHazeHorz :
          mov  EBX, 0
          mov  BH, DH
          mov  BL, CH
          add  ECX, InDeltaDu
          add  EBX, __TextureBuffer
          mov  EAX, ESI
          mov  AL, [EBX]
          add  EDX, InDeltaDv
          add  EAX, __ShadeBuffer
          mov  EBX, EBP
          mov  BL, [EAX]
          add  EBX, __HazeBuffer
          add  EBP, InDeltaDh
          add  ESI, InDeltaDI
          mov  BL, [EBX]
          mov  [EDI], BL
          inc  EDI
          dec  InLoopCount
          jnz  InLoopClippedTextureGrdHazeHorz
    
      pop  ESI

      NextRowTextureGrdHazeHorz : 
        mov  EAX, __LeftU
        mov  EBX, __LeftV
        add  EAX, __LeftDu
        add  EBX, __LeftDv
        mov  __LeftU, EAX
        mov  __LeftV, EBX
   
        mov  EAX, __RightU
        mov  EBX, __RightV
        add  EAX, __RightDu
        add  EBX, __RightDv
        mov  __RightU, EAX
        mov  __RightV, EBX

        mov  EAX, __LeftI
        mov  EBX, __RightI
        add  EAX, __LeftDI
        add  EBX, __RightDI
        mov  __LeftI, EAX
        mov  __RightI, EBX

        mov  EAX, __LeftH
        mov  EBX, __RightH
        add  EAX, __LeftDh
        add  EBX, __RightDh
        mov  __LeftH, EAX
        mov  __RightH, EBX

        dec  ESI
      jnz  LoopOutClippedTextureGrdHazeHorz

  EndLoopOutTextureGrdHazeHorz :

  pop  ESI
  pop  EDI
  pop  EBP
  ret
_DrawTextureGrdHazeHorz_ ENDP


END
