include 386video.inc

; _VPix
; _VBlock
; _Scr2Scr
; _View2Act

code32 segment para public use32
       assume cs:code32,ds:code32



        public _Pix
_Pix:
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; cl= color
        
        push edi 
        push eax
        push edx
        push ecx
        push ebx
        mov bl,cl
        mov ecx,eax
        add edi,[edx*4+_RowStart]
        shr eax,PIXSHIFT
        add edi,eax
        
	BLITMODE BLITPLANE
        mov ax,WWP0
        mov dx,SEQUENCER
        and cl,PIXMUP
        inc cl
        rol ah,cl
        out dx,ax
        
        mov [edi],bl
        
        pop ebx
        pop ecx
        pop edx
        pop eax
        pop edi
	ret

; ==========================================================================
;
; BLOCK BLITTING FUNCTIONS
;
; ==========================================================================

        public _Block

_Block:
        ; blit a single color block on screen
        ;edi = screen base offset
        ;eax = x position in nudgets
        ;edx = y position in pixels
        
        ;ecx = block width in BIG nudgets
        ;ebx = block height in pixels
        ;esi = color pattern  (all 4 bytes are used)

        pushad
        
        add edi,eax                   ;
        add edi,[edx*4 + _RowStart]   ; edi = upper-left block corner
        
        BLITMODE BLITPLANE
        WRITEPLANE WPA
        ; eax,edx thrashed
        
        
        mov edx,ecx       ;edx = x width in big nudgets
        neg ecx
        mov eax,esi
        lea esi,[ecx*4+PXWIDTH]
@zblock:
        mov ecx,edx
        rep stosd ; ZOOM! Thundering speed!
        add edi,esi ; next line
        dec ebx
        jne @zblock
        
        popad
	ret


        public _Scr2Scr

_Scr2Scr:
        ; copy a screen rectangle fron a display page to another
        ; eax = x position in nudgets
        ; edx = y position in pixels
        ; ecx = x width in nudgets
        ; ebx = y height in pixels
        ; esi = scr_source base offset
        ; edi = scr_dest base offset
        
        pushad
        
        add eax,[edx*4+_RowStart]
        add esi,eax
        add edi,eax
        
        WRITEPLANE WPA
        BLITMODE BLITBLOCK
        
        mov edx,PXWIDTH
        sub edx,ecx  ;incremento a fine riga
        mov eax,ecx  ; eax = width counter
@zipscr:
        mov ecx,eax
        rep movsb
        add edi,edx
        add esi,edx
        dec ebx
        jne @zipscr
        popad
        ret

;  void View2Act(void)
;  copy visible page to active page (so you can modify it)
;
        public _View2Act

_View2Act:
        pushad
        WRITEPLANE WPA
        BLITMODE BLITBLOCK

        mov edi,_ActiveBase
        mov esi,_ViewBase
        mov ecx,(PXWIDTH*VYHEIGHT)
        rep movsb
        popad
        ret

code32 ends

 END

