(*
                        __
        ___  __________/  |________
        \  \/  / ____/\   __\_  __ \
         >    < <_|  | |  |  |  | \/
        /__/\_ \__   | |__|  |__|
              \/  |__|
----------------------------------------------
   Wordpress Micro Blogging for Mystic BBS   
----------------------------------------------
  This is a MPL Script for almost complete
managing of a Wordpress.com blog. Create new
posts, read them, edit them, add new tags and
categories and all these inside from
MysticBBS software.
  Works under Linux and Raspberry Pi. With
some few alterations can work under Windows
also.
----------------------------------------------
                            .oO0( xqtr )0Oo.

*)

(*
   _            _   _              ___          _    _       
  /_\  _ _  ___| |_| |_  ___ _ _  |   \ _ _ ___(_)__| |               8888
 / _ \| ' \/ _ \  _| ' \/ -_) '_| | |) | '_/ _ \ / _` |            8 888888 8
/_/ \_\_||_\___/\__|_||_\___|_|   |___/|_| \___/_\__,_|            8888888888
                                                                   8888888888
         DoNt Be aNoTHeR DrOiD fOR tHe SySteM                      88 8888 88
                                                                   8888888888
    .o HaM RaDiO    .o ANSi ARt!       .o MySTiC MoDS              "88||||88"
    .o NeWS         .o WeATheR         .o FiLEs                     ""8888""
    .o GaMeS        .o TeXtFiLeS       .o PrEPardNeSS                  88
    .o TuTors       .o bOOkS/PdFs      .o SuRVaViLiSM          8 8 88888888888
    .o FsxNet       .o SurvNet         .o More...            888 8888][][][888
                                                               8 888888##88888
   TeLNeT : andr01d.zapto.org:9999 [UTC 11:00 - 20:00]         8 8888.####.888
   SySoP  : xqtr                   eMAiL: xqtr.xqtr@gmail.com  8 8888##88##888
*)


Uses Cfg;
Uses User;

Const 
  HeaderOffset = 233;
  Sysop           = 's255';
  Max_Items       = 20;
  NewsWidth       = 72;

Type 
  TTDFont = Record
    A         : char;
    typo      : Array[1..18] Of char;
    B         : char;
    fs        : array[1..4] Of byte;
    NameLen   : byte;
    FontName  : array[1..12] Of char;
    nouse     : array[1..4] Of byte;
    FontType  : byte;
    Spacing   : byte;
    BlockSize : word;
    CharAddr  : Array[1..94] Of word;
  End;

Type 
  TFontChar = Record
    width  : byte;
    height : byte;
  End;

Type 
  TMenuItem = Record
    Name : String;
    Id   : Integer;
  End;

Var 
  Ok        : Boolean = True;
  DataPath  : String;
  FileDate  : Longint = -1;
  Data      : Array[1..Max_Items] Of TMenuItem;
  TotalItems: Integer;
  FontFile  : String;
  font    : TTDFont;
  PostSel   : String = '';
  CatSel    : String = '';
  TagSel    : String = '';

  Win_x      : Byte     = 10;
  Win_y      : Byte     = 9;
  Win_w      : Byte     = 61;
  Win_h      : Byte     = 12;
  Win_norm_cl: Byte     = 7;
  Win_high_cl: Byte     = 13;

Procedure GetTDFHeader(f:String);
Var 
  fptr : file;
  i : integer;
Begin
  If Not fileexist(f) Then
    Begin
      writeln('Font file [ '+f+' ]does not exist');
      pause;
      halt;
    End;
  fontfile := f;
  fassign(fptr,f,66);
  freset(fptr);
  fread(fptr,font,sizeof(font));
  fclose(fptr);
End;

Procedure TDFWriteCharBL(x,y:byte;c:char): byte;
Var 
  fptr : file;
  i : integer;
  FChar : TFontChar;
  tbyte : array[1..2] Of byte;
  sx,sy: byte;
  asc: byte;
Begin
  If c=' ' Then
    Begin
      tdfwritecharBL := 1;
      exit;
    End;
  asc := ord(c)-32;
  fassign(fptr,fontfile,66);
  freset(fptr);
  fseek(fptr,headeroffset+font.charaddr[asc]);
  fread(fptr,FChar,sizeof(Fchar));
  tbyte[1] := 32;
  tbyte[2] := 32;
  gotoxy(x,y);
  While tbyte[1]<>0 And Not feof(fptr) Do
    Begin
      fread(fptr,tbyte[1],1);
      If tbyte[1]=13 Then
        Begin
          gotoxy(x,wherey+1);
          If wherey>25 Then break;
        End
      Else
        Begin
          fread(fptr,tbyte[2],1);
          textcolor(tbyte[2] % 16 + tbyte[2] - (tbyte[2] % 16));
          write(chr(tbyte[1]));
          If wherex>79 Then break;
        End;
    End;
  fclose(fptr);
  tdfwritecharbl := fchar.width;
End;

Procedure TDFWriteCharCL(x,y:byte;c:char): byte;
Var 
 fptr : file;
 i : integer;
 FChar : TFontChar;
 tbyte : array[1..2] Of byte;
 sx,sy: byte;
 asc: byte;
Begin
 If c=' ' Then
   Begin
     tdfwritecharcl := 1;
     exit;
   End;
 asc := ord(c)-32;
 fassign(fptr,fontfile,66);
 freset(fptr);
 fseek(fptr,headeroffset+font.charaddr[asc]);
 fread(fptr,FChar,sizeof(Fchar));
 tbyte[1] := 32;
 gotoxy(x,y);
 While tbyte[1]<>0 And Not feof(fptr) Do
   Begin
     fread(fptr,tbyte[1],1);
     If tbyte[1]=13 Then
       Begin
         gotoxy(x,wherey+1);
         If wherey>25 Then break;
       End
     Else
       Begin
         write(chr(tbyte[1]));
         If wherex>79 Then break;
       End;
   End;
 fclose(fptr);
 tdfwritecharcl := fchar.width;
End;

Procedure TDFWrite(x,y:byte; s:String);
Var 
  i: byte;
  sx,sy: byte;
Begin
  gotoxy(x,y);
  sx := x;
  sy := y;
  Case font.fonttype Of 
    2:
       Begin
         For i:=1 To length(s) Do
           Begin
             sx := sx+tdfwritecharBL(sx,y,s[i])+font.spacing;
           End;
       End;
    1:
       Begin
         For i:=1 To length(s) Do
           Begin
             sx := sx+tdfwritecharCL(sx,y,s[i])+font.spacing;
           End;
       End;
  End;
End;

Procedure ClearArea;
Var o: byte;
Begin
  For o:=0 To Win_h Do
    Begin
      GotoXY(Win_x,Win_y+o);
      Write(strrep(' ',Win_w));
    End;
End;

Procedure AddLog(Str: String);
Var 
  Stamp : String;
Begin
  Stamp := '[ '+DateStr(DateTime,1)+' / ';
  Stamp := Stamp + TimeStr(DateTime,False)+' ] ';
  AppendText(cfgsyspath+AddSlash('logs')+'fsxnet.log',Stamp+Str);
End;

Procedure XWindow(H1:String;T,X1,Y1,X2,Y2:Integer);
Var T1,A1,A2,B1,B2  : String;
Begin
  A1 := Int2Str(X1);
  A2 := Int2Str(X2);
  B1 := Int2Str(Y1);
  B2 := Int2Str(Y2);
  T1 := Int2Str(T);
  Write('|#X#'+T1+'#'+H1+'#'+A1+'#'+B1+'#'+A2+'#'+B2+'#');
End;

Procedure Center(s:String; line:byte);
Begin
  GotoXY(40-(length(stripmci(s)) / 2),line);
  Write(s);
End;

Procedure ClearData;
Var 
  i : Integer;
Begin
  For i := 1 To Max_Items Do
    Begin
      Data[i].Name  := '';
      Data[i].id    := 0;
    End;
End;

Function EditFile(FX,Subject:String): Boolean;
Var 
  Lines    : Integer = 10;
  WrapPos  : Integer = 80;
  MaxLines : Integer = 200;
  Forced   : Boolean = False;
  Template : String  = 'msg_editor';
  Count    : Integer;
  i        : Integer;
  S        : String;
  fptr     : file;
  k        : Char;
Begin
  If Not FileExist(FX) Then
    Begin
      For  i := 0 To MaxLines Do
        MsgEditSet(i,'');
    End
  Else
    Begin
      fAssign(fptr,FX,66);
      fReset(fptr);
      i := 1;
      While (Not feof(fptr)) Do
        Begin
          fReadLn(fptr,s);
          MsgEditSet(i,s);
          i := i + 1;
          If i>=MaxLines Then break;
        End;
      fClose(fptr);
      Lines := i+1;
      MaxLines := Lines+200;
    End;
  EditFile := True;

  SetPromptInfo(1, '');

  If MsgEditor(0,Lines,WrapPos,MaxLines,Forced,Template, Subject) Then
    Begin
      MenuCMD('GT','|#V#1#20#10# Actions #S-Save            ,A-Abort          #');
      k := ReadKey;
      If Upper(k)='S' Then
        Begin
          fAssign(fptr,FX,66);
          fReWrite(fptr);
          For Count := 1 To Lines Do
            Begin
              fWriteLn(fptr,MsgEditGet(Count));
            End;
          fClose(fptr);
        End;
    End
  Else EditFile := False;
End;

Function Menu: Integer;
Var 
  Ch : Char;
  Ch2: Char;
  baronc : string = '|23|00';
  baroffc : string = '|16|07';
  TopPage   : byte;
  BarPos    : byte;
  More      : byte;
  LastMore  : byte;
  Temp      : byte;
  Temp2     : byte;
  Done      : Boolean;
  TotalAreas: Byte;
  morecol   : String = '|08|16';

Procedure BarON;
Var 
  d : Byte;
Begin
  d := Length(Data[Barpos].Name) - Length(StripMCI(Data[BarPos].Name));
  WriteXYPipe(Win_x, Win_y + BarPos - TopPage,7,Win_w,baronc+PadRT(Data[BarPos].Name, Win_w + d, ' '
  ));
End;

Procedure BarOFF;
Var 
  d : Byte;
Begin
  d := Length(Data[Barpos].Name) - Length(StripMCI(Data[BarPos].Name));
  WriteXYPipe(Win_x, Win_y + BarPos - TopPage,7,Win_w,baroffc+PadRT(Data[BarPos].Name, Win_w + d,
              ' '));
End;

Procedure DrawPage;
Begin
  Temp2 := BarPos;
  For Temp := 0 To Win_h-1 Do
    Begin
      BarPos := TopPage + Temp;
      BarOFF;
    End;
  BarPos := Temp2;
  BarON;
End

Begin
  TopPage  := 1;
  BarPos   := 1;
  Done     := False;
  More     := 0;
  LastMore := 0;
  TotalAreas := TotalItems;
  ClearArea;
  DrawPage;
  Menu := -1;


  Repeat
    More := 0;
    Ch   := ' ';
    Ch2  := ' ';


    If TopPage > 1 Then
      Begin
        More := 1;
        Ch   := Chr(244);
      End;

    If TopPage + Win_h-1 < TotalAreas Then
      Begin
        Ch2  := Chr(245);
        More := More + 2;
      End;

    If More <> LastMore Then
      Begin
        LastMore := More;
        GotoXY (35, 22);
        Write (morecol+' (' + Ch + Ch2 + ' more) ');
      End;

    Ch := ReadKey;
    If IsArrow Then
      Begin
        //HOME key
        If ch = chr(71) Then
          Begin

            TopPage := 1;
            BarPos  := 1;
            drawpage;
          End;
        //END Key
        If ch = chr(79) Then
          Begin

            If TotalAreas > Win_h Then
              Begin
                TopPage := TotalAreas - Win_h+1;
                BarPos  := TotalAreas;
              End
            Else
              Begin
                BarPos  := TotalAreas ;
              End;
            drawpage;
          End;

        If Ch = Chr(72) Then
          Begin

            If BarPos > TopPage Then
              Begin
                BarOFF;
                BarPos := BarPos - 1;
                BarON;
              End;
            Else
              If TopPage > 1 Then
                Begin
                  TopPage := TopPage - 1;
                  BarPos  := BarPos  - 1;
                  DrawPage;
                End;
          End;

        If Ch = Chr(73) Then
          Begin

            If TopPage - Win_h > 0 Then
              Begin
                TopPage := TopPage - Win_h;
                BarPos  := BarPos  - Win_h;
                DrawPage;
              End
            Else
              Begin
                TopPage := 1;
                BarPos  := 1;
                DrawPage;
              End;
          End;

        If Ch = Chr(80) Then
          Begin

            If BarPos < TotalAreas Then
              If BarPos < TopPage + Win_h-1 Then
                Begin
                  BarOFF;
                  BarPos := BarPos + 1;
                  BarON;
                End
            Else
              If BarPos < TotalAreas Then
                Begin
                  TopPage := TopPage + 1;
                  BarPos  := BarPos  + 1;
                  DrawPage;
                End;
          End;

        If Ch = Chr(81) Then
          Begin

            If TotalAreas > Win_h Then
              If TopPage + Win_h < TotalAreas - Win_h+1 Then
                Begin
                  TopPage := TopPage + Win_h-1;
                  BarPos  := BarPos  + Win_h-1;
                  DrawPage;
                End
            Else
              Begin
                TopPage := TotalAreas - Win_h+1;
                BarPos  := TotalAreas;
                DrawPage;
              End
            Else
              Begin
                BarOFF;
                BarPos := TotalAreas;
                BarON;
              End;
          End;
        //ch:=#0
      End
    Else
      If Ch = Chr(27) Then
        Begin
          Menu := -2;
          Done := True;
        End
    Else
      If Ch = Chr(13) Then
        Begin
          Menu := BarPos;
          Done := True;
        End;
  Until Done;
End;

Function MenuFile(FileName:String; Popup:Boolean; Title:String): String;
Const 
  ItemsCount = 12;

Var 
  Ch : Char;
  Ch2: Char;
  baronc : string = '|23|00';
  baroffc : string = '|16|07';
  TopPage   : Integer;
  BarPos    : Integer;
  More      : Integer;
  LastMore  : Integer;
  Temp      : Integer;
  Temp2     : Integer;
  Items     : Array[1..ItemsCount] Of TMenuItem;
  Total     : Integer;
  Done      : Boolean;
  Index     : Integer;
  TotalAreas: Integer;
  morecol   : String = '|08|16';
  kk        : Char;

Procedure BarON;
Var 
  d : Byte;
Begin
  //GotoXY (Win_x, Win_y + BarPos - TopPage);
  //Write (baronc + PadRT(StripMCI(Data[BarPos].Name), Win_w, ' ') + '|16');
  d := Length(Items[Barpos].Name) - Length(StripMCI(Items[BarPos].Name));
  WriteXYPipe(Win_x, Win_y + BarPos,7,Win_w,baronc+PadRT(Items[BarPos].Name, Win_w + d, ' '));
End;

Procedure BarOFF;
Var 
  d : Byte;
Begin
  //GotoXY (Win_x, Win_y + BarPos - TopPage);
  //Write (baroffc + PadRT(Data[BarPos].Name, Win_w, ' '));
  //Write (StrREP(' ', Win_w - WhereX));
  d := Length(Items[Barpos].Name) - Length(StripMCI(Items[BarPos].Name));
  WriteXYPipe(Win_x, Win_y + BarPos,7,Win_w,baroffc+PadRT(Items[BarPos].Name, Win_w + d, ' '));
End;

Procedure DrawPage;
Begin
  Temp2 := BarPos;
  For Temp := 1 To Win_h Do
    Begin
      BarPos := Temp;
      BarOFF;
    End;
  BarPos := Temp2;
  BarON;
End;

Procedure fClearData;
Var 
  iq : Integer;
Begin
  For iq := 1 To ItemsCount Do
    Begin
      Items[iq].Name  := '';
      Items[iq].id    := 0;
    End;
End;

Function GetTotal: Integer;
Var 
  fpt  : File;
  iw   : Integer;
  Ss    : String;
Begin
  iw := 0;
  fAssign(fpt,Filename,66);
  fReset(fpt);
  While (Not feof(fpt)) Do
    Begin
      fReadln(fpt,Ss);
      iw := iw + 1;
    End;
  fClose(fpt);
  GetTotal := iw;
End;

Procedure GetItems;
Var 
  fpt : File;
  ie    : Integer;
  Ss    : String;
Begin

  fClearData;
  fAssign(fpt,Filename,66);
  fReset(fpt);

  ie := TopPage-1;
  If ie <> 0 Then
    While (Not feof(fpt)) And (ie <> 1) Do
      Begin
        fReadln(fpt,Ss);
        ie := ie -1;
      End;

  ie := 1;
  While (Not feof(fpt)) And (ie <= ItemsCount) Do
    Begin
      fReadLn(fpt,sS);
      If Pos(';',Ss)>0 Then
        Begin
          Items[ie].Name := WordGet(2,Ss,';');
          Items[ie].Id := Str2Int(WordGet(1,Ss,';'));
        End
      Else
        Begin
          Items[ie].Name := Ss;
          Items[ie].Id := TopPage + ie;
        End;
      ie := ie + 1;
    End;
  fClose(fpt);
  Total := ie;
End;

Begin
  If Not FileExist(Filename) Then Exit;

  TopPage  := 1;
  BarPos   := 1;
  Done     := False;
  More     := 0;
  LastMore := 0;
  Index := 0;
  ClearArea;

  TotalAreas := GetTotal;
  MenuFile := '';

  GetItems;
  DrawPage;

  Repeat
    More := 0;
    Ch   := ' ';
    Ch2  := ' ';


    If TopPage > 1 Then
      Begin
        More := 1;
        Ch   := Chr(244);
      End;

    If TopPage + Win_h-1 < TotalAreas Then
      Begin
        Ch2  := Chr(245);
        More := More + 2;
      End;

    If More <> LastMore Then
      Begin
        LastMore := More;
        GotoXY (35, 22);
        Write (morecol+' (' + Ch + Ch2 + ' more) ');
      End;

    Ch := ReadKey;
    If IsArrow Then
      Begin
        //HOME key
        If ch = chr(71) Then
          Begin

            TopPage := 1;
            GetItems;
            BarPos  := 1;
            drawpage;
          End;
        //END Key
        If ch = chr(79) Then
          Begin
            If TotalAreas > TopPage + Win_h - 1 Then
              Begin
                TopPage := TotalAreas - Win_h+1;
                GetItems;
                BarPos  := Total-1;
              End
            Else
              Begin
                BarPos  := Total-1;
              End;
            drawpage;
          End;

        If Ch = Chr(72) Then
          Begin

            If BarPos > 1 Then
              Begin
                BarOFF;
                BarPos := BarPos - 1;
                BarON;
              End;

          End;

        If Ch = Chr(73) Then
          Begin
            //PGUP
            If TopPage - Win_h > 0 Then
              Begin
                TopPage := TopPage - Win_h;
                GetItems;
                //BarPos  := BarPos  - Win_h - TopPage;
                DrawPage;
              End
            Else
              Begin
                TopPage := 1;
                GetItems;
                BarPos  := 1;
                DrawPage;
              End;
          End;

        If Ch = Chr(80) Then
          Begin
            If BarPos < Total - 1 Then
              Begin
                BarOFF;
                BarPos := BarPos + 1;
                BarON;
              End
              DrawPage;
          End;

        If Ch = Chr(81) Then
          Begin
            //PGDN
            If TopPage + Win_h -1  < TotalAreas Then
              Begin
                TopPage := TopPage + Win_h-1;
                GetItems;
                BarPos := Total-1;
              End
            Else
              Begin
                BarOFF;
                BarPos := Total-1;
                BarON;
              End;
            DrawPage;
          End;
      End
    Else
      If Ch = Chr(27) Then
        Begin
          MenuFile := '';
          Done := True;
        End
    Else
      If Ch = Chr(13) Then
        Begin
          If PopUp Then
            Begin
              MenuCMD('GT',
                     '|#V#1#20#10# Actions #V-View            ,D-Download       ,C-Cancel         #'
              );
              kk := ReadKey;
              If Upper(kk)='V' Then
                Begin
                  TextColor(0);
                  ClrScr;
                  Menucmd('GV','ansiviewtxt;ansiviewh;0;'+DataPath+'posts'+PathChar+Int2Str(items[
                          barpos].ID)+'.txt');
                End;
              If Upper(kk)='D' Then
                Begin
                  MenuCMD ('F3', DataPath+'posts'+PathChar+Int2Str(Items[barpos].id)+'.txt');
                End;
            End
          Else
            Begin
              MenuFile := Int2Str(Items[barpos].id) +';'+ Items[barpos].Name;
              Done := True;
            End;
          TextColor(0);
          ClrScr;
          DispFile(DataPath+'bg.ans');
          gettdfheader(datapath+'font34.tdf');
          font.spacing := 1;
          tdfwrite(2,2,Title);
          DrawPage;
          //Done := True;
        End;
  Until Done;
End;

Procedure AddNewTag;
Var 
  Cat : String;
Begin
  Center('|16|15Enter new tag name, leave blank to do nothing...',22);
  XWindow(' Tag ' ,1,40,12,60,14);
  GotoXY(42,13);
  Cat := '';
  Cat := Input(17,30,11, Cat);
  If Cat <> '' Then
    menucmd('DE',DataPath+'wpcli.py -nt "'+Cat+'"');
End;

Procedure Find;
Var 
  Cat,Ss : String;
  fpt  : File;
Begin
  Center('|16|15Enter string to search on Title',22);
  XWindow(' Search ',1,40,10,60,12);
  GotoXY(42,11);
  Cat := '';
  Cat := Input(17,30,11, Cat);
  If Cat = '' Then Exit;
  If FileExist(DataPath+'found.txt') Then FileErase(DataPath+'found.txt');
  fAssign(fpt,DataPath+'index.txt',66);
  fReset(fpt);
  While Not fEOF(fpt) Do
    Begin
      fReadLn(fpt,Ss);
      If Pos(Upper(Cat),Upper(sS)) > 0 Then
        AppendText(DataPath+'found.txt',sS);
    End;
  fClose(fpt);
  If FileExist(DataPath+'found.txt') Then
    Begin
      TextColor(0);
      ClrScr;
      DispFile(DataPath+'bg.ans');
      gettdfheader(datapath+'font34.tdf');
      font.spacing := 1;
      tdfwrite(2,2,'Results');
      MenuFile(DataPath+'found.txt',True,'Results');
    End;
End;

Procedure SelectCategories;
Var 
  Sel : String;
Begin
  If FileExist(DataPath+'categories.txt') Then
    Begin
      TextColor(0);
      ClrScr;
      DispFile(DataPath+'bg.ans');
      gettdfheader(datapath+'font34.tdf');
      font.spacing := 1;
      tdfwrite(2,2,'Categories');
      Center(' |15|16ENTER to Select / ESC to go Back ',25);
      Sel := MenuFile(DataPath+'categories.txt',False,'Categories');
      If Sel <> '' Then CatSel := WordGet(2,Sel,';') +';'+ CatSel ;
    End;
End;

Procedure SelectTags;
Var 
  Sel : String;
Begin
  If FileExist(DataPath+'tags.txt') Then
    Begin
      TextColor(0);
      ClrScr;
      DispFile(DataPath+'bg.ans');
      gettdfheader(datapath+'font34.tdf');
      font.spacing := 1;
      tdfwrite(2,2,'Tags');
      Center(' |15|16ENTER to Select / ESC to go Back ',25);
      Sel := MenuFile(DataPath+'tags.txt',False,'Tags');
      If Sel <> '' Then TagSel := WordGet(2,Sel,';') +';'+ TagSel ;
    End;
End;

Procedure SelectPost;
Begin
  TextColor(0);
  clrscr;
  DispFile(DataPath+'bg.ans');
  gettdfheader(datapath+'font34.tdf');
  font.spacing := 1;
  //xwindow(' Options ',1,19,7,61,22);
  tdfwrite(2,2,'Select...');
  MenuCMD('DD','ls '+DataPath+'draft'+' -1 > '+DataPath+'browse.txt');
  PostSel := MenuFile(DataPath+'browse.txt',False,'Select');
  If PostSel <> '' Then PostSel := WordGet(2,PostSel,';');
End;

Procedure NewPost;
Var 
  Cat : String;
Begin
  Center('|16|15Enter Filename for new post.',21);
  Center('|16|15The file will be saved in "Draft" directory.',22);
  XWindow(' Filename ',1,40,13,60,15);
  GotoXY(42,14);
  Cat := '';
  Cat := Input(17,30,11, Cat);
  If Cat = '' Then Exit;
  If EditFile(DataPath+'draft'+PathChar+Cat,'')=False Then
    Begin
      XWindow(' Message ',1,40,13,60,15);
      GotoXY(42,14);
      Write('Aborted...');
    End;
End;

Procedure AddNewCategory;
Var 
  Cat : String;
Begin
  Center('|16|15Enter new category name, leave blank to do nothing...',21);
  Center('|16|15Update categories if you create one, new.',22);
  XWindow(' Category ',1,40,13,60,15);
  GotoXY(42,14);
  Cat := '';
  Cat := Input(17,30,11, Cat);
  If Cat <> '' Then
    menucmd('DE',DataPath+'wpcli.py -nc "'+Cat+'"');
End;

Procedure DeletePost;
Var 
  Cat : String;
  k   : Char;
Begin
  Center('|16|15Enter ID number of post to be deleted.',22);
  XWindow(' ID ',1,40,13,60,15);
  GotoXY(42,14);
  Cat := '';
  Cat := Input(17,30,11, Cat);

  If Cat = '' Then Exit;

  MenuCMD('GT','|#V#1#20#10# Confirm #Y-Yes             ,N-No             #');
  k := ReadKey;
  If Upper(k)='Y' Then
    menucmd('DE',DataPath+'wpcli.py -e "'+Cat+'"');
End;

Procedure RetrievePost;
Var 
  Cat : String;
  k   : Char;
Begin
  Center('|16|15Enter ID number of post to be retrieved.',22);
  XWindow(' ID ',1,40,13,60,15);
  GotoXY(42,14);
  Cat := '';
  Cat := Input(17,30,11, Cat);

  If Cat = '' Then Exit;

  MenuCMD('GT','|#V#1#20#10# Confirm #Y-Yes             ,N-No             #');
  k := ReadKey;
  If Upper(k)='Y' Then
    menucmd('DE',DataPath+'wpcli.py -g "'+Cat+'"');
End;

Procedure GetCategories;
Begin
  XWindow(' Status ',1,20,12,60,14);
  Center('|16|15Getting Categories...',13);
  menucmd('DE',DataPath+'wpcli.py -c > '+DataPath+'categories.txt');
  Center('|16|15        Done...      |PN',13);
End;

Procedure GetTags;
Begin
  XWindow(' Status ',1,20,12,60,14);
  Center('|16|15Getting Tags...',13);
  menucmd('DE',DataPath+'wpcli.py -t > '+DataPath+'tags.txt');
  Center('|16|15     Done...   |PN',13);
End;

Procedure GetPosts;
Begin
  XWindow(' Status ',1,20,12,60,14);
  Center('|16|15Getting Posts...',13);
  menucmd('DE',DataPath+'wpcli.py -a '+DataPath);
  menucmd('DE',DataPath+'wpcli.py -i > '+DataPath+'index.txt');
  menucmd('DE',DataPath+'inverse.py');
  Center('|16|15     Done...    |PN',13);
End;

Procedure PublishPost;
Var 
  k : Char;
  fpt : File;
  w : byte;
  cat : String;
Begin
  If PostSel = '' Then
    Begin
      XWindow(' Error ',1,20,12,60,14);
      Center('|16|15No Post Selected...|PN',13);
      Exit;
    End;

  If CatSel = '' Then
    Begin
      XWindow(' Error ',1,20,12,60,14);
      Center('|16|15No Categories Selected...|PN',13);
      Exit;
    End;

  If TagSel = '' Then
    Begin
      XWindow(' Error ',1,20,12,60,14);
      Center('|16|15No Tags Selected...|PN',13);
      Exit;
    End;

  fAssign(fpt,DataPath+'draft'+PathChar+PostSel+'.cat',66);
  fReWrite(fpt);
  w := 1;
  Repeat
    cat := Wordget(w,CatSel,';');
    fWriteln(fpt,cat);
    w := w +1;
  Until cat = '';
  fclose(fpt);

  fAssign(fpt,DataPath+'draft'+PathChar+PostSel+'.tag',66);
  fReWrite(fpt);
  w := 1;
  Repeat
    cat := Wordget(w,TagSel,';');
    fWriteln(fpt,cat);
    w := w +1;
  Until cat = '';
  fclose(fpt);

  Center('|16|15Enter a Title for the post.',22);
  XWindow(' Title ',1,20,13,60,15);
  GotoXY(22,14);
  Cat := '';
  Cat := Input(37,200,11, Cat);

  If Cat = '' Then
    Begin
      XWindow(' Error ',1,20,12,60,14);
      Center('|16|15You didn''t enter a title...|PN',13);
      Exit;
    End;

  fAssign(fpt,DataPath+'draft'+PathChar+PostSel+'.tit',66);
  fReWrite(fpt);
  fWriteLn(fpt,Cat);
  fclose(fpt);

  MenuCMD('GT','|#V#1#20#10# Confirm #P-Post            ,A-Abort          #');
  k := ReadKey;
  If Upper(k)='P' Then
    Begin
      menucmd('DE',DataPath+'wpcli.py '+ DataPath+'draft'+PathChar+PostSel);
    End;
  FileErase(DataPath+'draft'+PathChar+PostSel+'.tit');
  FileErase(DataPath+'draft'+PathChar+PostSel+'.tag');
  FileErase(DataPath+'draft'+PathChar+PostSel+'.cat');
End;

Procedure ViewFiles;
Begin
  TextColor(0);
  ClrScr;
  MenuCmd ('GA', DataPath+'posts');
End;

Procedure SysopMenu;
Var 
  d : Integer;

Procedure Draw;
Var x : Byte;
Begin
  TextColor(0);
  clrscr;
  DispFile(DataPath+'bg.ans');
  gettdfheader(datapath+'font34.tdf');
  font.spacing := 1;
  //xwindow(' Options ',1,19,7,61,22);
  tdfwrite(2,2,'Sysop Menu');
  ClearData;
  x := 1;
  Data[x].Name  := 'Get Posts';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Get Categories';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Get Tags';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Write New Post';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Add New Tag';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Add New Category';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Select Categories';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Clear Categories';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Select Tags';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Clear Tags';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Select Post';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'UnSelect Post';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Publish Post';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Delete Post';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Save Post as Draft';
  Data[x].ID     := x;
  x := x + 1;
  Data[x].Name  := 'Back';
  Data[x].ID     := x;
  TotalItems  := x;
  If CatSel <> '' Then
    Begin
      GotoXY(1,25);
      Write(StrRep(' ',79));
      Center('|15Categories: |07'+CatSel,25);
    End;
  If TagSel <> '' Then
    Begin
      GotoXY(1,24);
      Write(StrRep(' ',79));
      Center('|15Tags: |07'+TagSel,24);
    End;
  If PostSel <> '' Then Center('|15Selected Post: |07'+PostSel,8);
End;

Begin
  Repeat
    Draw;
    d := Menu;
    Case d Of 
      1 : GetPosts;
      2 : GetCategories;
      3 : GetTags;
      4 : NewPost;
      5 : AddNewTag;
      6 : AddNewCategory;
      7 : SelectCategories;
      8 : CatSel := '';
      9 : SelectTags;
      10 : TagSel := '';
      11 : SelectPost;
      12 : PostSel := '';
      13 : PublishPost;
      14 : DeletePost;
      15 : RetrievePost;
      16 : Exit;
    End;
  Until d = 16;
End;

Procedure MainScreen;
Var 
  d : Integer;

Procedure Draw;
Begin
  TextColor(0);
  clrscr;
  DispFile(DataPath+'bg.ans');
  gettdfheader(datapath+'font34.tdf');
  font.spacing := 1;
  tdfwrite(2,2,'Main Menu');
  ClearData;
  Data[1].Name  := 'Index (Latest First)';
  Data[1].ID     := 1;
  Data[2].Name  := 'Index (Older First)';
  Data[2].ID     := 2;
  Data[3].Name  := 'View Post By ID';
  Data[3].ID     := 3;
  Data[4].Name  := 'Find Post';
  Data[4].ID     := 4;
  Data[5].Name  := 'Exit';
  Data[5].ID     := 5;
  If ACS(Sysop) Then
    Begin
      Data[6].Name  := 'Sysop Menu';
      Data[6].ID     := 6;
      TotalItems  := 6;
    End
  Else
    TotalItems  := 5;
End;
Begin
  Repeat
    Draw;
    d := Menu;
    Case d Of 
      1 :
          Begin
            TextColor(0);
            ClrScr;
            DispFile(DataPath+'bg.ans');
            gettdfheader(datapath+'font34.tdf');
            font.spacing := 1;
            tdfwrite(2,2,'Index / Latest');
            MenuFile(DataPath+'index.txt',True,'Index / Latest');
          End;
      2 :
          Begin
            TextColor(0);
            ClrScr;
            DispFile(DataPath+'bg.ans');
            gettdfheader(datapath+'font34.tdf');
            font.spacing := 1;
            tdfwrite(2,2,'Index / Oldest');
            MenuFile(DataPath+'inverse.txt',True,'Index / Oldest');
          End;
      3 : ViewFiles;
      4 : Find;
      5 : Exit;
      6 : SysopMenu;
    End;
  Until d = 5;
End;

Begin
  GetThisUser;
  If Graphics = 0 Then
    Begin
      WriteLn('|16|15No Graphics support. Exiting... |PA');
      AddLog('No Graphics Support. Aborting. User: '+UserAlias);
      Halt;
    End;
  Datapath := AddSlash(addslash(cfgmpepath)+'xq-wpcli'+PathChar);

  MainScreen;
  
  TextColor(0);
  ClrScr;
End;
