Uses Cfg;

Const
  cfg_maxrec = 10;

Type
  Rec = Record
    User : String[15];
    BBS  : String[30];
    Date : String[10];
    Time : String[6];
    City : String[20];
    OS   : String[10];
    Addr : String[100];
  End;

Type
  BBSRec = Record
    Name : String[30];
    Addr : String[100];
    Calls: Integer;
  End;

Var
  AppDir  : String;
  DatFile : String;
  More    : Boolean = False;
  RanBBS  : String = '';
  FB      : Byte = 2;
  RD      : Byte = 0;
  x1 : Byte = 1;
  x2 : Byte = 1;
  x3 : Byte = 1;
  x4 : Byte = 1;
  y1 : Byte = 6;
  y2 : Byte = 6;
  y3 : Byte = 22;
  y4 : Byte = 22;
  x1e : Byte = 1;
  x2e : Byte = 79;
  x3e : Byte = 1;
  x4e : Byte = 79;
  y1e : Byte = 19;
  y2e : Byte = 19;
  y3e : Byte = 24;
  y4e : Byte = 24;

function Rot47(s: string): string;
var
  i, j: integer;
  res : String;
begin
  Res := s;
  for i := 1 to Length(s) do
  begin
    j := Ord(s[i]);
    if (j>=33) and (j<=126) then
    begin
      Res[i] := Chr(33 + ((j + 14) % 94));
    end;
  end;
  Rot47:=Res;
end;

Procedure ClearTextArea;
Var
  l:byte;
Begin
  for l:=7 to 18 Do WriteXY(4,l,7,StrRep(' ',74));
End;

Procedure ResetScreen;
Begin
  TextColor(7);
  ClrScr;
End;

Procedure AddBBS(bbs,addr:String);
Var
  fp   : LongInt;
  i    : Integer;
  B    : BBSRec;
  F    : Boolean = False;
Begin
  ClassCreate(fp, 'file');
  If Not FileOpen(fp, AddSlash(AppDir)+'ilc-bbs.dat', SizeOf(B), 1, 66) Then 
    If Not FileOpen(fp, AddSlash(AppDir)+'ilc-bbs.dat', SizeOf(B), 2, 66) Then Begin
      ClassFree(fp);
      Exit;
    End Else Begin
      B.Name:=bbs;
      B.Addr:=addr;
      B.Calls:=1;
      FileWrite(fp,B);
      ClassFree(fp);
      Exit;
    End;
  
  i:=0;
  While Not FileEOF(fp) Do Begin
    FileRead(fp,B);
    If Upper(B.Name)=Upper(bbs) Then Begin
      F:=True;
      Break;
    End;
    i := i + 1;
  End;
  
  If F THen Begin
    FileSeek(fp,i);
    B.Calls := B.Calls+1;
  End Else Begin
    B.Name:=bbs;
    B.Addr:=addr;
    B.Calls:=1;
  End;
  FileWrite(fp,B);
  
  ClassFree(fp);  
End;

Procedure TrimFile;
Var
  fp   : LongInt;
  tp   : LongInt;
  Recs : Word;
  i    : Word;
  U    : Rec;
Begin
  If Not FileExist(DatFile) Then Exit;
  
  ClassCreate(fp, 'file');
  ClassCreate(tp, 'file');

  If Not FileOpen(fp, DatFile, SizeOf(U), 1, 66) Then Begin
    ClassFree(fp);
    Exit;
  End;

  If FileSize(fp) = 0 Then Begin
    ClassFree(fp);
    Exit;
  End;

  Recs := FileSize(fp);
  
  If Recs<=cfg_maxrec Then Begin
    ClassFree(fp);
    ClassFree(tp);
    Exit;
  End;
  
  FileOpen(tp, AddSlash(AppDir)+'xq-ilc.tmp', SizeOf(U), 2, 66)
  
  i := Recs - cfg_maxrec;
  While Not FileEOF(fp) Do Begin
    FileSeek(fp,i);
    FileRead(fp,U);
    FileWrite(tp,U);
    i := i + 1;
  End;
  
  ClassFree(fp);
  ClassFree(tp);
  
  FileErase(DatFile);
  FileCopy(AddSlash(AppDir)+'xq-ilc.tmp',DatFile);
  FileErase(AddSlash(AppDir)+'xq-ilc.tmp');
    
End;
  
Procedure GetDataFrom(S:String);
Var
  fp : File;
  l  : String;
  U  : Rec;
Begin
  If Not FileExist(S) Then Exit;
  FillChar(U,SizeOf(U),#0);
  fAssign(fp,S,66);
  fReset(fp);
  While Not fEOF(fp) Do Begin
    fReadLn(fp,l);
    if l='>>> BEGIN' Then Begin
      fReadLn(fp,l);
      U.User:=Rot47(l);
      fReadLn(fp,l);
      U.BBS:=Rot47(l);
      fReadLn(fp,l);
      U.Date:=Rot47(l);
      fReadLn(fp,l);
      U.Time:=Rot47(l);
      fReadLn(fp,l);
      U.City:=Rot47(l);
      fReadLn(fp,l);
      U.OS:=Rot47(l);
      fReadLn(fp,l);
      U.Addr:=Rot47(l);
    End;
  End;
  fClose(fp);
  FileErase(S);
  AppendText (CfgSysPath+'logs'+PathChar+'xq-ilc.log', 'Adding: '+U.User+'/'+U.BBS)
  AddBBS(U.BBS,U.Addr);
  
  fAssign(fp,DatFile,66);
  If FileExist(DatFile) Then Begin
    fReset(fp);
    fSeek(fp,fSize(fp));
  End Else Begin
    fReWrite(fp);
  End;
  fWriteRec(fp,U);
  fClose(fp);
End;

Procedure DispANSI(A:String);
Begin
  If FileExist(A) Then MenuCMD('GD','@0@false@'+A)
    Else If FileExist(CfgMPEPath+A) Then MenuCMD('GD','@115000@false@'+CfgMPEPath+A);
End;

Procedure Flash(x,y:Byte);
  Var
    oldc : Char;
    olda : Byte;
  Begin
    oldc := GetCharXY(x,y);
    olda := GetAttrXY(x,y);
    WriteXY(x,y,15,oldc);
    Delay(50);
    WriteXY(x,y,olda,oldc);
  End;
  
Procedure RandomBBS;
  
  Procedure GetBBS;
  Var
    fp : LongInt;
    B  : BBSRec;
    p  : Integer;
    k  : char;
    d  : Integer;
  Begin
    If Not FileExist(AddSlash(AppDir)+'ilc-bbs.dat') Then Exit;
    ClassCreate(fp, 'file');
    If Not FileOpen(fp, AddSlash(AppDir)+'ilc-bbs.dat', SizeOf(B), 1, 66) Then Exit;
    p:=Filesize(fp);
    p:=Random(p)+1;
    //While not FileEOF(fp) Do 
      For d:=1 to p Do
        FileRead(fp,B);
        
    ClassFree(fp);
    
    RanBBS := Copy(StripMCI(B.Name +' '+Chr(179)+' '+ B.Addr),1,77);
  End;
  
Begin
  Case FB Of
    0 : Begin WriteXY(40-(Length(RanBBS) / 2),21,8,RanBBS); Delay(50);End;
    1 : Begin WriteXY(40-(Length(RanBBS) / 2),21,7,RanBBS); Delay(50);End;
    2 : Begin WriteXY(40-(Length(RanBBS) / 2),21,15,RanBBS); Delay(50);End;
    3 : Begin WriteXY(40-(Length(RanBBS) / 2),21,15,RanBBS); Delay(50);End;
  End;
  FB:=FB+1;
  If FB>3 Then Begin
    FB:=0;
    GetBBS;
    WriteXY(2,21,8,StrRep('.',77));
  End;
End;  

Procedure Glow;
Begin
  Flash(x1,y1);
  Flash(x2,y2);
  //Flash(x3,y3);
  //Flash(x4,y4);
  if x1=79 then y1:=y1+1 else x1:=x1+1;
  if x1=79 and y1=y1e then begin
    x1:=1;
    y1:=6;
  end;
  
  if y2=y2e then x2:=x2+1 else y2:=y2+1;
  if y2=y2e and x2=79 then begin
    y2:=6;
    x2:=1;
  end;
  (*
  if x3=79 then y3:=y3+1 else x3:=x3+1;
  if x3=79 and y3=y3e then begin
    x3:=1;
    y3:=22;
  end;
  
  if y4=y4e then x4:=x4+1 else y4:=y4+1;
  if y4=y4e and x4=79 then begin
    y4:=22;
    x4:=1;
  end;
  *)
End;

Procedure ListBBSes;
Var
  fp : File;
  B  : BBSRec;
  p  : Integer;
  k  : char;
  d  : Byte;
  addr : String ='';
Begin
  If Not FileExist(AddSlash(AppDir)+'ilc-bbs.dat') Then Exit;
  ResetScreen;
  fAssign(fp,AddSlash(AppDir)+'ilc-bbs.dat',66);
  fReset(fp);
  p:=1;
  DispANSI(AddSlash(AppDir)+'header.ans');
  TextColor(7);
  WriteLn('');
  While Not fEOF(fp) Do Begin
    fReadRec(fp,B);
    Textcolor(7);
    addr:=StripMCI(B.Addr);
    If Pos('.',addr)<=0 Then addr:='N0t VaLiD!';
    WriteLn(PadRt(PadLt(Int2Str(p),4,' '),7,'.')+' '+PadLt(Int2Str(B.Calls),5,' ')+' '+PadRT(StripMCI(B.Name),30,' ')+' '+PadRT(addr,30,' '));
    p:=p+1;
  End;
  
  WriteLn('');
  DispANSI(AddSlash(AppDir)+'footer.ans');
  Write('[80D[2A[2C');
  Write(' Total BBSes: '+PadLt(Int2Str(p-1),5,' '));
  Write('[3B[80D');
  Writeln('');
  Write('|07 Select BBS to connect or Q to Quit: ');
  k:=OneKeyRange('Q',1,p-1);
  If k=#0 Then Begin
    p:=RangeValue;
    fseek(fp,(p-1)*sizeof(b));
    freadrec(fp,b);
    fClose(fp);
    d:=Pos(':',b.Addr)
    If d>0 Then Begin
      MenuCmd('IT','/addr='+Copy(b.Addr,1,d-1)+' /port='+Copy(b.Addr,d+1,Length(b.Addr)-d));
    End
    Else
      MenuCmd('IT','/addr='+b.Addr);
    
    
  End Else
    fClose(fp);

End;

Procedure ShowBBSData;
Var
  fp : File;
  B  : BBSRec;
  ib : BBSRec;
  Data : Array[1..11] of BBSRec;
  p  : Byte;
  d  : byte;
  Done : Boolean = False;
  C  : Char;
  addr : String = '';
  
  Procedure Sort;
  Var
    i, j, index : Integer;
    
    tmp : BBSRec;
  Begin
    for i:=1 to 10 do begin
      if ib.calls>data[i].calls then begin
        j:=11;
        while j>=i do begin
          data[j]:=data[j-1];
          j:=j-1;
        end;
                
        data[i]:=ib;
        exit;
      end;
    end;
  End;
  
  
Begin
  If Not FileExist(AddSlash(AppDir)+'ilc-bbs.dat') Then Exit;
  ResetScreen;
  fAssign(fp,AddSlash(AppDir)+'ilc-bbs.dat',66);
  fReset(fp);
  For p:=1 to 11 Do FillChar(Data[p],Sizeof(B),#0);
  For p:=1 to 11 Do Data[p].calls:=0;
  p:=0;
  While Not fEOF(fp) Do Begin
    fReadRec(fp,ib);
    Sort;
  End;
  fClose(fp);
  
  For p:=1 to 10 Do 
    If Data[p].Calls = 0 Then FillChar(Data[p],Sizeof(B),#0);
  
  DispANSI(AppDir+'bgb.ans');
  WriteXY(6,23,8,'[ '+StrMci('|BN')+' ]');
  ClearTextArea;
  For p := 1 to 10 Do Begin
    WriteXY(5,7+p,8,StrRep('.',30));
    WriteXY(5,7+p,7,StripMCI(Data[p].Name));
    WriteXY(36,7+p,8,StrRep('.',30));
    
    addr:=StripMCI(Data[p].Addr);
    If Pos('.',addr)<=0 Then addr:='N0t VaLiD!';
    
    WriteXY(36,7+p,7,addr);
    WriteXY(68,7+p,8,StrRep('.',5));
    WriteXY(68+5-Length(Int2Str(Data[p].Calls)),7+p,7,Int2Str(Data[p].Calls));
  End;
  C:=Readkey;
  If Upper(C)='T' THen Begin
    WriteXY(2,21,7,'Enter number to connect, Q to Quit: ');
    C:=OneKey('123456789XQ',False);
    TextColor(7);
    ClrScr;
    Case Upper(C) Of
    #48,#49,#50,
    #51,#52,#53,
    #54,#55,#56,
    #57  : Begin
                p:=11-Ord(c)+48;
                d:=Pos(':',Data[p].Addr)
                If d>0 Then Begin
                  MenuCmd('IT','/addr='+Copy(Data[p].Addr,1,d-1)+' /port='+Copy(Data[p].Addr,d+1,Length(Data[p].Addr)-d));
                End
                Else
                  MenuCmd('IT','/addr='+Data[p].Addr);
                
           End;
    'X' : Begin
            MenuCmd('IT','/addr='+Data[1].Addr);
          End;
    End;
  End;  
End;

Procedure ShowData;
Var
  fp : File;
  U  : Rec;
  Data : Array[1..10] of Rec;
  i  : Byte;
  Done : Boolean = False;
  C  : Char;
  
  Procedure ShowText;
  Begin
    ResetScreen;
    If Not More Then Begin
      DispANSI(AppDir+'bg.ans');
      WriteXY(6,23,8,'[ '+StrMci('|BN')+' ]');
      For i := 1 to 10 Do Begin
        WriteXY(5,7+i,8,StrRep('.',15));
        WriteXY(5,7+i,7,Data[i].User);
        WriteXY(21,7+i,8,StrRep('.',27));
        WriteXY(21,7+i,7,Data[i].BBS);
        WriteXY(49,7+i,8,StrRep('.',18));
        WriteXY(49,7+i,7,Copy(Data[i].City,1,18));
        WriteXY(68,7+i,8,StrRep('.',10));
        WriteXY(68,7+i,7,Data[i].Date);
      End;
    End
  Else
    Begin
      DispANSI(AppDir+'bgm.ans');
      WriteXY(6,23,8,'[ '+StrMci('|BN')+' ]');
      For i := 1 to 10 Do Begin
        WriteXY(5,7+i,8,StrRep('.',15));
        WriteXY(5,7+i,7,Data[i].User);
        WriteXY(21,7+i,8,StrRep('.',27));
        WriteXY(21,7+i,7,Data[i].BBS);
        WriteXY(49,7+i,8,StrRep('.',18));
        WriteXY(49,7+i,7,Data[i].OS);
        WriteXY(68,7+i,8,StrRep('.',10));
        //WriteXY(68,7+i,7,Data[i].Calls);
      End;
    End;
  End;
  
Begin
  If Not FileExist(DatFile) Then Begin
    ClrScr;
    TextColor(7);
    WriteLn('No Data to display... Exiting.');
    Pause;
    Exit;
  End;
  
  fAssign(fp,DatFile,66);
  fReset(fp);
  For i:=1 to 10 Do FillChar(Data[i],Sizeof(U),#0);
  i:=1;
  While Not fEOF(fp) Do Begin
    fReadRec(fp,Data[i]);
    i:=i+1;
  End;
  fClose(fp);

  ShowText;
  
  Repeat
    If Keypressed Then Begin
      C:=ReadKey;
      If c=#13 then More:=False
      Else If c='1' Then Begin
        ResetScreen;
        DispANSI(AppDir+'bg1.ans')
        GotoXY(1,1);
        ReadKey;
      End
      Else If c='2' Then Begin
        ResetScreen;
        DispANSI(AppDir+'bg2.ans')
        GotoXY(1,1);
        ReadKey;
      End
      Else If Upper(c)='B' Then Begin
        ShowBBSData;
      End
      Else If Upper(c)='L' Then Begin
        ListBBSes;
      End
      Else If Upper(c)='H' Then Begin
        ResetScreen;
        DispANSI(AppDir+'bgh.ans')
        WriteXY(6,23,8,'[ '+StrMci('|BN')+' ]');
        GotoXY(1,1);
        ReadKey;
      End
      Else Done:=True;
      ShowText;
    End;
  Glow;
  RD:=RD+1;
  If RD>10 Then Begin
    RandomBBS;
    Delay(10);
    RD:=0;
  End;
    
  Until Done;
  
  
End;

Begin
  AppDir :=  AddSlash(CfgMPEPath+'xq-ilastcaller');
  DatFile := AddSlash(AppDir)+'xq-ilc.dat';
  TextColor(7);
  //Import Incoming Data
  FindFirst (AppDir+'*.ilc', 63);
  While DosError = 0 Do
    Begin
      GetDataFrom(AppDir+DirName);
      FindNext;
    End;
  FindClose;
  TrimFile;
  
  //Display Data
  ClrScr;
  ShowData;
  TextColor(7);
  Clrscr;
End;
