# coding: CP437

# Configurable Variables, feel free to change!

# for version A47+ use the following
# swidth,sheight = termsize()
swidth = 80                             # Screen width,height, for future use
sheight = 25                            # in adjustable theme
topics_per_page = 10                    # how many posts per page to show
new_char = '|SA|12'+chr(175)+'|RA'      # prefix string/char for new topics/forums
#new_char = '|SA|23|00'+chr(175)+'|RA'  # a more advanced one
folder_char = '+'                       # prefix str/char for forums
sub_char = '-- '                        # prefix for sub-forums
bullet_char = chr(254)                  # chr/str for bullet lists [li] in BBCODES
show_subforums = False                  # show/hide by default sub-forums
csv_char = ';'

# Footer Position and Color
forums_footer = (3,24,7)
posts_footer = (3,24,7)

# ANSI Files | All files must be in the directory of MysticBB
ansi_posts_help = 'posts_help.ans'
ansi_forums_help = 'forums_help.ans'
ansi_posts = 'posts.ans'
ansi_forums = 'forums.ans'

# Forum/topic list dimensions
#               x y w  h 
forum_window = (2,3,78,21)

# Colors for use in the list
color_forum_high = 15 + 16
color_forum_low = 14
color_forum_sub_high = 11 + 16
color_forum_sub_low = 11
color_forum_line2 = 8
color_topic_high = 11+16
color_topic_low = 7
color_topic_line2 = 8

# These colors are for the views/forum/topic columns, showed in the list
color_fw_lastuser = '|07'
color_fw_lasttime = '|03'
color_fw_topics   = '|11'
color_fw_posts    = '|11'
color_fw_sep      = '|08'


# Locations and colors for the forum/topic information
#(x,y,attr,width,align,pad_char)
info_desc = (3,22,7,75,'left',' ')
info_posts = (67,23,7,5,'right',' ')
info_topics = (73,23,7,5,'right',' ')
info_last_time = (43,23,7,10,'left',' ')
info_last_from = (15,23,7,24,'left',' ')
info_type = (73,21,8,5,'left','.')
info_sysop_forum_id = (75,1,14,8,'left',' ')

# Dimension for the Post window/scroller
#            top,bottom
post_window = (2,21)
post_width = 79

# Text attributes for posts
post_text_normal = 7
post_text_quote = 1

# Locations and colors for the forum/topic information
#(x,y,attr,width,align,pad_char)
posts_pages = (60,23,7,12,'left','.')
posts_page_num = (67,22,11,3,'right',' ')
posts_page_total = (74,22,11,3,'right',' ')
posts_subject = (3,1,15,75,'left',' ')

# This is the header for each post, displayed in the text/scroller, you can
# use either one. ANSI codes are also accepted.
'''
posts_header = ['|15 |09|17|15|16 |09|17|01|16  |09|17|15|16 |09|17|16|15 |09|17|16 |17    |15        |09 |15 |09    |16 |17۲|16|17۲۱',
                '|00    |01#ID |01 |17|09mystic|01|16|07 |09|17 user |16       |00    |09   |00        |09|16      |17 date |16 |09%PD%|07      ',
                '|00  |09%ID% |01|17|09forums|01|00|16  |01> |11%PN% |00    |09   |00    |09|17 time |16 %PT%  |07      ',
                '|15 |09|17|15|16 |09|17|01|16  |09|17|15|16 |09|17|16|15 |09|17|16 |17    |15        |09 |15 |09    |16 |17۲|16|17۲۱']

'''
posts_header = ['|15|11|01|01 |09|01 |09|01 |09|01 |09|01 |09|01',
                '|09 |09#ID |07%ID% |09// |15%PN%                 |01on |07%PD% %PT%',
                '|09|01 |09|01 |09|01 |09|01 |09|01 |09|01 |09|01']

# Strings, Dimensions, Location for text in the Post area
posts_ruler = ['|09'+'-'*7]
#posts prompt   x  y at width
posts_prompt = (4,23,9,5)
posts_prompt_str = 'Enter post #ID to Quote: '
posts_search_str = 'Search for: '
posts_search = (4,23,9,60)
posts_search_hl = 4*16+14               # yellow text on red bg
posts_search_bg = 1                     # text attribute to show current search string at position #post_search
posts_search_searching = 'Current search string: '
posts_delete = (4,23,9,5)
posts_delete_str = 'Enter post #ID to delete: '
posts_edit_id = (4,23,9,5)
posts_edit_reason = (4,23,9,55,80)
posts_edit_str_id = 'Enter post #ID to edit: '
posts_edit_str_reason = 'Reason for editing: '
posts_edit_footer = '|01Edited from: |09%EN%, |01for |09%ER% |01on |09%ET%'
posts_download = (4,23,9,5)
posts_download_str = 'Enter post #ID to download: '

posts_bar_x       = 70
posts_bar_y       = 24
posts_bar_width   = 8
posts_bar_bg      = ' '
posts_bar_fg      = ' '
posts_bar_bg_col  = 16
posts_bar_fg_col  = 3*16
posts_bar_text_col= 7

posts_bar_per_show= True
posts_bar_per     = (66,24,1,14,'left',' ')


# Quote header, use the chr(2) so that the program knows it's a quote and color it
# otherwise it will show it with normal text color
quote_header = [chr(2)+' +--[ On %QT%, %QN% said ]----']
quote_prefix = chr(2)+' |'
quote_postfix = ''
quote_footer = [chr(2)+' +---']

# Strings used in the Search/Find dialog
search_prompts = ('Case sensitive?','Include Forum titles?','Include Topic titles?','Include Post text?',chr(192)+' also include writers name?')

# Max search results. You don't want to be very big
search_max_results = 100

# Spinner type
spinner_string = '.oO080Oo. '

# Position, color, separator for the Crumbs string
crumbsx = 4
crumbsy = 1
crumbsw = 73
color_crumbs = 15
crumbs_prefix = '::'
crumbs_sep = chr(249)

# Colorized emoticons! Add yours also. You can also change the color of them.
emoticons =  [(':-)','|SA|14:-)|RA'),
              (':O','|SA|15:O|RA'),
              (':)','|SA|15:)|RA'),
              (';)','|SA|15;)|RA'),
              (';-)','|SA|15;-)|RA'),
              (':D','|SA|15:D|RA'),
              (':-D','|SA|15:-D|RA'),
              (':*','|SA|15:*|RA'),
              (':-*','|SA|15:-*|RA'),
              (':p','|SA|15:p|RA'),
              (':-p','|SA|15:-p|RA'),
              ('<3','|SA|04<3|RA'),
              (':ass:','|SA|14(_x_)|RA'),
              (':rose:','|SA|14@|10->-->--|RA'),
              (':spider:','|SA|15/\oo/\|RA'),
              (':mouse:','|SA|08<:3)~~~~|RA'),
              (':O','|SA|15:O|RA'),
              (':-O','|SA|15:-O|RA'),
              (":'-(","|SA|15:'-(|RA"),
              (":'(","|SA|15:'(|RA"),
              (':-(','|SA|15:-(|RA'),
              (':(','|SA|15:(|RA')]

# BBCODES!!! As you see, ANSI codes are supported ;)
bbcodes = [ ('[youtube]','[1B[79D|SA|20|14 Youtube: [1B[79D|15|20 '),
            ('[/youtube]','[1B[79D|15|20|$X79 |RA'+chr(13)),
            ('[url]','|SA|14|19'+chr(175)+' '),('[/url]','|RA'),
            ('[b]','|SA|15'),('[/b]','|RA'),
            ('[i]','|SA'+chr(27)+'[2m'),('[/i]','|RA'),
            ('[u]','|SA'+chr(27)+'[4m'),('[/u]','|RA'),
            ('[strike]','|SA'+chr(27)+'[9m'),('[/strike]','|RA'),
            ('[hr]','|01'+chr(196)*77),
            ('[li]','|SA|14'+bullet_char+' |RA'),('[/li]',''),
            ('[google]','[1B[79D|SA|17|14 Google Search: [1B[79D|15|17 http://letmegooglethat.com/?q='),
            ('[/google]','[1B[79D|15|17|$X79 |RA'+chr(13)),
          ]
          
# Colors, chars for the scrollbar of the lists
scrollbar = {"enable":True,"hichar":chr(219),"lochar":chr(179),"hiatt":11,"loatt":1}
