unit pcboard;

interface

function pcb(string1 : string): string;
function pcbln(string1 : string): string;
function pcbdisplay(filevar : string): string;
function pcbscroll(filevar : string): string;
function pcbhscroll(filevar, author, title : string): string;

implementation

uses crt, dos, fadeunit;

var
   a, b, c, d, counter1, counter2 : integer;
   color1, color2, color3 : string[2];
   ch, ch2, ch3, ch4 : char;
   string1 : string;
   filevar : text;

function pcb(string1 : string): string;
begin;
  for a := 1 to length(string1) do
  begin;
    ch := string1[a];
    if ch = '@' then begin;
      inc(a);
      ch2 := string1[a];
      if ch2 = 'X' then begin;
        inc(a);
        color1[1] := string1[a];
        inc(a);
        color1[2] := string1[a];
        if color1[1] = '0' then textbackground(0);
        if color1[1] = '1' then textbackground(1);
        if color1[1] = '2' then textbackground(2);
        if color1[1] = '3' then textbackground(3);
        if color1[1] = '4' then textbackground(4);
        if color1[1] = '5' then textbackground(5);
        if color1[1] = '6' then textbackground(6);
        if color1[1] = '7' then textbackground(7);

        if color1[2] = '0' then textcolor(0);
        if color1[2] = '1' then textcolor(1);
        if color1[2] = '2' then textcolor(2);
        if color1[2] = '3' then textcolor(3);
        if color1[2] = '4' then textcolor(4);
        if color1[2] = '5' then textcolor(5);
        if color1[2] = '6' then textcolor(6);
        if color1[2] = '7' then textcolor(7);
        if color1[2] = '8' then textcolor(8);
        if color1[2] = '9' then textcolor(9);
        if color1[2] = 'A' then textcolor(10);
        if color1[2] = 'B' then textcolor(11);
        if color1[2] = 'C' then textcolor(12);
        if color1[2] = 'D' then textcolor(13);
        if color1[2] = 'E' then textcolor(14);
        if color1[2] = 'F' then textcolor(15);
      end else write(ch, ch2);
    end else write(ch);
  end;
  textcolor(7);
  textbackground(0);
end;


function pcbln(string1 : string): string;
begin;
  for a := 1 to length(string1) do
  begin;
    ch := string1[a];
    if ch = '@' then begin;
      inc(a);
      ch2 := string1[a];
      if ch2 = 'X' then begin;
        inc(a);
        color1[1] := string1[a];
        inc(a);
        color1[2] := string1[a];
        if color1[1] = '0' then textbackground(0);
        if color1[1] = '1' then textbackground(1);
        if color1[1] = '2' then textbackground(2);
        if color1[1] = '3' then textbackground(3);
        if color1[1] = '4' then textbackground(4);
        if color1[1] = '5' then textbackground(5);
        if color1[1] = '6' then textbackground(6);
        if color1[1] = '7' then textbackground(7);

        if color1[2] = '0' then textcolor(0);
        if color1[2] = '1' then textcolor(1);
        if color1[2] = '2' then textcolor(2);
        if color1[2] = '3' then textcolor(3);
        if color1[2] = '4' then textcolor(4);
        if color1[2] = '5' then textcolor(5);
        if color1[2] = '6' then textcolor(6);
        if color1[2] = '7' then textcolor(7);
        if color1[2] = '8' then textcolor(8);
        if color1[2] = '9' then textcolor(9);
        if color1[2] = 'A' then textcolor(10);
        if color1[2] = 'B' then textcolor(11);
        if color1[2] = 'C' then textcolor(12);
        if color1[2] = 'D' then textcolor(13);
        if color1[2] = 'E' then textcolor(14);
        if color1[2] = 'F' then textcolor(15);
      end else write(ch, ch2);
    end else write(ch);
  end;
  textcolor(7);
  textbackground(0);
  writeln;
end;


function pcbdisplay(filevar : string): string;

var
   file2 : text;
   string2 : string;

begin;

  assign(file2, filevar);
  reset(file2);
  while not eof(file2) do
  begin;
    readln(file2, string2);
    pcbln(string2);
  end;

  close(file2);
end;


function pcbscroll(filevar : string): string;

var
   file2 : text;
   string1, string2 : string;
   string3 : array[1..30] of string;
   counter, counter2, counter3, a, b, c, d : integer;
   the_cows_come_home, I_say_so, fade : boolean;
   ch, ch2, ch3 : char;
   low, high : integer;

begin;
  initcol;
  fadeout(10);
  fade := false;
  clrscr;
  counter3 := 0;
  the_cows_come_home := false;
  assign(file2, filevar);
  reset(file2);
  counter := 0;
  while not eof(file2) do
  begin;
    readln(file2);
    inc(counter);
  end;
  reset(file2);
  for counter2 := 1 to 30 do
    readln(file2, string3[counter2]);
      for counter2 := 1 to 24 do
    begin;
      gotoxy(1,counter2);
      pcbln(string3[counter2]);
    end;

  fadein(10);
  repeat
  reset(file2);
  begin;
    for counter2 := 1 to 24 do
    begin;
      gotoxy(1,counter2);
      pcbln(string3[counter2]);
    end;
  end;

  I_say_so := false;
  repeat
  ch := readkey;

  if ch = 'Q' then begin;               {Q Key}
    the_cows_come_home := true;
    I_say_so := true;
  end;

  if ch = chr(27) then begin;           {ESC Key}
    the_cows_come_home := true;
    I_say_so := true;
  end;

  if ch = 'q' then begin;               {Q Key}
    the_cows_come_home := true;
    I_say_so := true;
  end;

  if ch = chr(13) then begin;
    the_cows_come_home := true;
    I_say_so := true;
  end;

  if ord(ch) = 0 then begin;
  ch := readkey;

  if ch = 'P' then begin;               {Down Key}

    I_say_so := true;
    reset(file2);
    if (counter3+24) < counter then begin;
      inc(counter3);
      for a := 1 to (counter3) do
        readln(file2, string1);
      for a := 1 to 24 do
        readln(file2, string3[a]);
    end;
  end;

  if ch = 'M' then begin;               {Right Key}
    I_say_so := true;
    reset(file2);
    if (counter3+24) < counter then begin;
      inc(counter3);
      for a := 1 to (counter3) do
        readln(file2, string1);
      for a := 1 to 24 do
        readln(file2, string3[a]);
    end;
  end;

  if ch = 'H' then begin;               {Up Key}
    I_say_so := true;
    reset(file2);
    dec(counter3);
    if counter3 <= 0 then counter3 := 0;
      for a := 1 to counter3 do
        readln(file2, string1);
      for a := 1 to 24 do
        readln(file2, string3[a]);
  end;

  if ch = 'K' then begin;               {Left Key}
    I_say_so := true;
    reset(file2);
    dec(counter3);
    if counter3 <= 0 then counter3 := 0;
      for a := 1 to counter3 do
        readln(file2, string1);
      for a := 1 to 24 do
        readln(file2, string3[a]);

  end;


  if ch = 'Q' then begin;               {Page Down Key}

    I_say_so := true;
    reset(file2);
    if (counter3+24) < counter then begin;
      counter3 := counter3 + 24;
      if counter3 >= (counter-24) then counter3 := (counter-24);
      for a := 1 to (counter3) do
        readln(file2, string1);
      for a := 1 to 24 do
        readln(file2, string3[a]);
    end;
  end;

  if ch = 'I' then begin;               {Page Up Key}

    I_say_so := true;
    reset(file2);
    counter3 := counter3 - 24;
    if counter3 <= 1 then counter3 := 1;
    for a := 1 to (counter3) do
      readln(file2, string1);
    for a := 1 to 24 do
      readln(file2, string3[a]);
    end;


    if ch = 'O' then begin;               {End Key}
    I_say_so := true;
    reset(file2);
    low := high;
    counter3 := counter;
    if counter3 >= (counter-24) then counter3 := (counter-24);
    for a := 1 to (counter3) do
      readln(file2, string1);
    for a := 1 to 24 do
      readln(file2, string3[a]);
  end;

  if ch = 'G' then begin;               {Home Key}
    I_say_so := true;
    reset(file2);
    counter3 := 1;
    if counter3 >= (counter-24) then counter3 := (counter-24);
    for a := 1 to (counter3) do
      readln(file2, string1);
    for a := 1 to 24 do
      readln(file2, string3[a]);
  end;


  end;
  until I_say_so;

  until the_cows_come_home;
  close(file2);
  fadeout(10);
  clrscr;


end;




function pcbhscroll(filevar, author, title : string): string;

var
   file2 : text;
   scounter, string1, string2, lines : string;
   string3 : array[1..30] of string;
   counter, counter2, counter3, a, b, c, d : integer;
   the_cows_come_home, I_say_so, fade : boolean;
   ch, ch2, ch3 : char;
   low, high, lines2 : integer;


begin;
  initcol;
  val(lines, lines2, lines2);
  fadeout(10);
  fade := false;
  clrscr;
  counter3 := 0;
  the_cows_come_home := false;
  assign(file2, filevar);
  reset(file2);
  counter := 0;
  while not eof(file2) do
  begin;
    readln(file2);
    inc(counter);
  end;

  reset(file2);

  for counter2 := 1 to 30 do
    readln(file2, string3[counter2]);

  pcbln('@X08@X07@X0FĿ');
  pcbln('@X08@X07                                                                             ');
  pcbln(' Author: @X0F[@X07                               @X0F @X07        @X0F      ] @X07                   ');
  pcbln(' Title:  @X0F[@X07                              @X0F                ]@X07                    ');
  pcbln(' Lines:@X0F  [@X07                                                                   ');
  pcbln('                                                                      @X08       ');
  pcbln('@X0F@X07@X08');


  textcolor(7);
  gotoxy(13,3);
  write(author);

  gotoxy(13,4);
  write(title);


  low := 1;
  high := counter;
  high := high - 16;
  if high <= 0 then high := 1;
  gotoxy(13,5);
  str(low, scounter);
  str(counter, lines);
  a := (length(scounter) + length(lines)) + 17;
  textcolor(7);
  write(low,' of ',high);
  textcolor(15);
  gotoxy(a, 5);
  write(' ]   ');

  for counter2 := 1 to 17 do
    begin;
      gotoxy(1,counter2+7);
      pcbln(string3[counter2]);
    end;

  fadein(10);
  repeat
  reset(file2);
  begin;
  gotoxy(13,5);
  str(low, scounter);
  str(counter, lines);
  a := (length(scounter) + length(lines)) + 17;
  textcolor(7);
  write(low,' of ',high);
  textcolor(15);
  gotoxy(a, 5);
  write(' ]   ');

    for counter2 := 1 to 17 do
    begin;
      gotoxy(1,counter2+7);
      pcbln(string3[counter2]);
    end;
  end;

  I_say_so := false;
  repeat
  ch := readkey;

  if ch = 'Q' then begin;               {Q Key}
    the_cows_come_home := true;
    I_say_so := true;
  end;

  if ch = chr(27) then begin;           {ESC Key}
    the_cows_come_home := true;
    I_say_so := true;
  end;

  if ch = 'q' then begin;               {Q Key}
    the_cows_come_home := true;
    I_say_so := true;
  end;

  if ch = chr(13) then begin;
    the_cows_come_home := true;
    I_say_so := true;
  end;

  if ord(ch) = 0 then begin;
  ch := readkey;

  if ch = 'P' then begin;               {Down Key}

    I_say_so := true;
    reset(file2);
    inc(low);
    if low > high then low := high;
    if (counter3+17) < counter then begin;
      inc(counter3);
      for a := 1 to (counter3) do
        readln(file2, string1);
      for a := 1 to 17 do
        readln(file2, string3[a]);
    end;
  end;

  if ch = 'M' then begin;               {Right Key}
    I_say_so := true;
    reset(file2);
    inc(low);
    if low > high then low := high;
    if (counter3+17) < counter then begin;
      inc(counter3);
      for a := 1 to (counter3) do
        readln(file2, string1);
      for a := 1 to 17 do
        readln(file2, string3[a]);
    end;
  end;

  if ch = 'H' then begin;               {Up Key}
    I_say_so := true;
    reset(file2);
    dec(counter3);
    dec(low);
    if low < 1 then low := 1;
    if counter3 <= 0 then counter3 := 0;
      for a := 1 to counter3 do
        readln(file2, string1);
      for a := 1 to 17 do
        readln(file2, string3[a]);
  end;

  if ch = 'K' then begin;               {Left Key}
    I_say_so := true;
    reset(file2);
    dec(counter3);
    dec(low);
    if low < 1 then low := 1;
    if counter3 <= 0 then counter3 := 0;
    for a := 1 to counter3 do
      readln(file2, string1);
    for a := 1 to 17 do
      readln(file2, string3[a]);
  end;

  if ch = 'Q' then begin;               {Page Down Key}

    I_say_so := true;
    reset(file2);
    low := low + 17;
    if low >= high then low := high;
    if (counter3+17) < counter then begin;
      counter3 := counter3 + 17;
      if counter3 >= (counter-17) then counter3 := (counter-17);
      for a := 1 to (counter3) do
        readln(file2, string1);
      for a := 1 to 17 do
        readln(file2, string3[a]);
    end;
  end;

  if ch = 'O' then begin;               {End Key}
    I_say_so := true;
    reset(file2);
    low := high;
    counter3 := counter;
    if counter3 >= (counter-17) then counter3 := (counter-17);
    for a := 1 to (counter3) do
      readln(file2, string1);
    for a := 1 to 17 do
      readln(file2, string3[a]);
  end;

  if ch = 'G' then begin;               {Home Key}

    I_say_so := true;
    reset(file2);
    low := 1;

    if (counter3+16) < counter then begin;
      counter3 := 0;
      if counter3 >= (counter-17) then counter3 := (counter-17);
      for a := 1 to (counter3) do
        readln(file2, string1);
      for a := 1 to 17 do
        readln(file2, string3[a]);
    end;
  end;




  if ch = 'I' then begin;               {Page Up Key}

    I_say_so := true;
    reset(file2);
    low := low - 17;
    if low < 1 then low := 1;
    counter3 := counter3 - 17;
    if counter3 <= 0 then counter3 := 0;
    for a := 1 to (counter3) do
      readln(file2, string1);
    for a := 1 to 17 do
      readln(file2, string3[a]);
    end;

  end;


  until I_say_so;

  until the_cows_come_home;
  close(file2);
  fadeout(10);
  clrscr;


end;


end.