unit myapp;

interface
uses dos, crt;

procedure tc(num:byte);
procedure wl(amt:byte);
procedure uncrunch(var Addr1,Addr2; BlkLen:Integer);
procedure gp(ColorNo : Byte; Var R,G,B : Byte);
procedure FadeOut;
procedure ResetTextMode;
procedure GrabPal;
procedure BlackOut;
procedure whiteout;
procedure FadeIn;
procedure intro1;
procedure intro2;
procedure mik_in;
procedure pause1;
procedure pause2;
procedure pause3;
procedure cursoroff;
procedure cursoron;
procedure flushkeyboard;
procedure pauseb;

implementation

Procedure tc(num:byte);

begin
textcolor(num);
end;


Procedure wl(amt:byte);var t : byte;
begin
For t := 1 to amt do
 writeln;
end;

procedure uncrunch(var Addr1,Addr2;BlkLen:Integer);

type ScreenType = array [0..3999] of Byte;
var ScreenAddr : ScreenType absolute $B800:$0000;

begin

  inline (
    $1E/               {       PUSH    DS             ;Save data segment.}
    $C5/$B6/ADDR1/     {       LDS     SI,[BP+Addr1]  ;Source Address}
    $C4/$BE/ADDR2/     {       LES     DI,[BP+Addr2]  ;Destination Addr}
    $8B/$8E/BLKLEN/    {       MOV     CX,[BP+BlkLen] ;Length of block}
    $E3/$5B/           {       JCXZ    Done}
    $8B/$D7/           {       MOV     DX,DI          ;Save X coordinate for later.}
    $33/$C0/           {       XOR     AX,AX          ;Set Current attributes.}
    $FC/               {       CLD}
    $AC/               {LOOPA: LODSB                  ;Get next character.}
    $3C/$20/           {       CMP     AL,32          ;If a control character, jump.}
    $72/$05/           {       JC      ForeGround}
    $AB/               {       STOSW                  ;Save letter on screen.}
    $E2/$F8/           {Next:  LOOP    LOOPA}
    $EB/$4C/           {       JMP     Short Done}
                       {ForeGround:}
    $3C/$10/           {       CMP     AL,16          ;If less than 16, then change the}
    $73/$07/           {       JNC     BackGround     ;foreground color.  Otherwise jump.}
    $80/$E4/$F0/       {       AND     AH,0F0H        ;Strip off old foreground.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$F1/           {       JMP     Next}
                       {BackGround:}
    $3C/$18/           {       CMP     AL,24          ;If less than 24, then change the}
    $74/$13/           {       JZ      NextLine       ;background color.  If exactly 24,}
    $73/$19/           {       JNC     FlashBitToggle ;then jump down to next line.}
    $2C/$10/           {       SUB     AL,16          ;Otherwise jump to multiple output}
    $02/$C0/           {       ADD     AL,AL          ;routines.}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $80/$E4/$8F/       {       AND     AH,8FH         ;Strip off old background.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$DA/           {       JMP     Next}
                       {NextLine:}
    $81/$C2/$A0/$00/   {       ADD     DX,160         ;If equal to 24,}
    $8B/$FA/           {       MOV     DI,DX          ;then jump down to}
    $EB/$D2/           {       JMP     Next           ;the next line.}
                       {FlashBitToggle:}
    $3C/$1B/           {       CMP     AL,27          ;Does user want to toggle the blink}
    $72/$07/           {       JC      MultiOutput    ;attribute?}
    $75/$CC/           {       JNZ     Next}
    $80/$F4/$80/       {       XOR     AH,128         ;Done.}
    $EB/$C7/           {       JMP     Next}
                       {MultiOutput:}
    $3C/$19/           {       CMP     AL,25          ;Set Z flag if multi-space output.}
    $8B/$D9/           {       MOV     BX,CX          ;Save main counter.}
    $AC/               {       LODSB                  ;Get count of number of times}
    $8A/$C8/           {       MOV     CL,AL          ;to display character.}
    $B0/$20/           {       MOV     AL,32}
    $74/$02/           {       JZ      StartOutput    ;Jump here if displaying spaces.}
    $AC/               {       LODSB                  ;Otherwise get character to use.}
    $4B/               {       DEC     BX             ;Adjust main counter.}
                       {StartOutput:}
    $32/$ED/           {       XOR     CH,CH}
    $41/               {       INC     CX}
    $F3/$AB/           {       REP STOSW}
    $8B/$CB/           {       MOV     CX,BX}
    $49/               {       DEC     CX             ;Adjust main counter.}
    $E0/$AA/           {       LOOPNZ  LOOPA          ;Loop if anything else to do...}
    $1F);              {Done:  POP     DS             ;Restore data segment.}
end; {UNCRUNCH}

VAR Pall,Pall2 : Array[0..255,1..3] of Byte;

PROCEDURE wrt; assembler;

label
  l1, l2;
asm
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h

    jz  l2
end;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

PROCEDURE gp(ColorNo : Byte; Var R,G,B : Byte);
Begin
   Port[$3c7] := ColorNo;
   R := Port[$3c9];
   G := Port[$3c9];
   B := Port[$3c9];
End;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

PROCEDURE ResetTextMode;
BEGIN
  asm
     mov        ax,03h
     int        10h
  end;
END;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

PROCEDURE sp(ColorNo : Byte; R,G,B : Byte);
BEGIN
   Port[$3c8] := ColorNo;
   Port[$3c9] := R;
   Port[$3c9] := G;
   Port[$3c9] := B;
END;


{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

PROCEDURE FadeOut;
VAR lxpy1,lxpy2:integer;
    Tmp : Array [1..3] of byte;
BEGIN
  For lxpy1:=1 to 64 do BEGIN
    wrt;
    For lxpy2:=1 to 255 do BEGIN
      gp (lxpy2,Tmp[1],Tmp[2],Tmp[3]);
      If Tmp[1]>0 then dec (Tmp[1]);
      If Tmp[2]>0 then dec (Tmp[2]);
      If Tmp[3]>0 then dec (Tmp[3]);
      sp (lxpy2,Tmp[1],Tmp[2],Tmp[3]);
    END;
  END;
END;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

Procedure GrabPal;
VAR loop1:integer;
BEGIN
  For loop1:=0 to 255 do
    Gp (loop1,pall2[loop1,1],pall2[loop1,2],pall2[loop1,3]);
END;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

Procedure Blackout;
  { This procedure blackens the screen by setting the pallette values of
    all the colors to zero. }
VAR loop1:integer;
BEGIN
  WRt;
  For loop1:=0 to 255 do
    sP (loop1,0,0,0);
END;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

Procedure whiteout;
  { This procedure whitens the screen by setting the pallette values of
    all the colors to 255. }
VAR loop1:integer;
BEGIN
  WRt;
  For loop1:=0 to 255 do
    sP (loop1,255,255,255);
END;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

Procedure FadeIn;
Var loop1,loop2:integer;
    Tmp : Array [1..3] of byte;
BEGIN
  For loop1:=1 to 64 do BEGIN
  WRt;
  For loop2:=0 to 255 do
   BEGIN
      Gp (loop2,Tmp[1],Tmp[2],Tmp[3]);
      If Tmp[1]<Pall2[loop2,1] then inc (Tmp[1]);
      If Tmp[2]<Pall2[loop2,2] then inc (Tmp[2]);
      If Tmp[3]<Pall2[loop2,3] then inc (Tmp[3]);
      sP (loop2,Tmp[1],Tmp[2],Tmp[3]);
    END;
  END;
END;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

procedure intro1;

var
   x : integer;

begin
grabpal;
fadeout;
clrscr;
cursoroff;
FADEIN;
for x := 1 to 5 do
begin
delay(190);tc(8);gotoxy (16,11);write ('Alliance Produkshuns & MXKaN TCHN0L0GS Present');
delay(190);tc(7);gotoxy (16,11);write ('Alliance Produkshuns & MXKaN TCHN0L0GS Present');
delay(190);tc(15);gotoxy (16,11);write ('Alliance Produkshuns & MXKaN TCHN0L0GS Present');
delay(190);tc(7);gotoxy (16,11);write ('Alliance Produkshuns & MXKaN TCHN0L0GS Present');
delay(190);tc(8);gotoxy (16,11);write ('Alliance Produkshuns & MXKaN TCHN0L0GS Present');
delay(190);tc(0);gotoxy (16,11);write ('Alliance Produkshuns & MXKaN TCHN0L0GS Present');
   end;
fadeout;
cursoron;
end;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

procedure intro2;

{$I ALL}

type ScreenType = array [0..3999] of Byte;
var ScreenAddr : ScreenType absolute $B800:$0000;
    x : integer;

begin
grabpal;
fadeout;
cursoroff;
blackout;
clrscr;
uncrunch(ALL,screenaddr[(1*2)+(1*160)-162],ALL_length);
fadein;
delay(3000);
fadeout;
clrscr;
fadein;
   for x := 1 to 4 do
     begin
       delay(150);gotoxy (37,12);tc(8);write ('Presents');
       delay(150);gotoxy (37,12);tc(7);write ('Presents');
       delay(150);gotoxy (37,12);tc(15);write ('Presents');
       delay(150);gotoxy (37,12);tc(7);write ('Presents');
       delay(150);gotoxy (37,12);tc(8);write ('Presents');
       delay(150);gotoxy (37,12);tc(0);write ('Presents');
end;
fadeout;
clrscr;
cursoron;
end;
{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

procedure mik_in;

begin
cursoroff;
  delay(150);tc(8);gotoxy (38,11);write ('S');
  delay(150);tc(7);gotoxy (38,11);write ('S');
  delay(150);tc(15);gotoxy (38,11);write ('S');
       delay(150);tc(8);gotoxy (45,13);write ('s');
       delay(150);tc(7);gotoxy (45,13);write ('s');
       delay(150);tc(15);gotoxy (45,13);write ('s');
  delay(150);tc(8);gotoxy (39,11);write ('i');
  delay(150);tc(7);gotoxy (39,11);write ('i');
  delay(150);tc(15);gotoxy (39,11);write ('i');
       delay(150);tc(8);gotoxy (44,13);write ('u');
       delay(150);tc(7);gotoxy (44,13);write ('u');
       delay(150);tc(15);gotoxy (44,13);write ('u');
  delay(150);tc(8);gotoxy (40,11);write ('l');
  delay(150);tc(7);gotoxy (40,11);write ('l');
  delay(150);tc(15);gotoxy (40,11);write ('l');
       delay(150);tc(8);gotoxy (43,13);write ('n');
       delay(150);tc(7);gotoxy (43,13);write ('n');
       delay(150);tc(15);gotoxy (43,13);write ('n');
  delay(150);tc(8);gotoxy (41,11);write ('i');
  delay(150);tc(7);gotoxy (41,11);write ('i');
  delay(150);tc(15);gotoxy (41,11);write ('i');
       delay(150);tc(8);gotoxy (42,13);write ('e');
       delay(150);tc(7);gotoxy (42,13);write ('e');
       delay(150);tc(15);gotoxy (42,13);write ('e');
  delay(150);tc(8);gotoxy (42,11);write ('c');
  delay(150);tc(7);gotoxy (42,11);write ('c');
  delay(150);tc(15);gotoxy (42,11);write ('c');
       delay(150);tc(8);gotoxy (41,13);write ('x');
       delay(150);tc(7);gotoxy (41,13);write ('x');
       delay(150);tc(15);gotoxy (41,13);write ('x');
  delay(150);tc(8);gotoxy (43,11);write ('o');
  delay(150);tc(7);gotoxy (43,11);write ('o');
  delay(150);tc(15);gotoxy (43,11);write ('o');
       delay(150);tc(8);gotoxy (40,13);write ('o');
       delay(150);tc(7);gotoxy (40,13);write ('o');
       delay(150);tc(15);gotoxy (40,13);write ('o');
  delay(150);tc(8);gotoxy (44,11);write ('n');
  delay(150);tc(7);gotoxy (44,11);write ('n');
  delay(150);tc(15);gotoxy (44,11);write ('n');
       delay(150);tc(8);gotoxy (39,13);write ('r');
       delay(150);tc(7);gotoxy (39,13);write ('r');
       delay(150);tc(15);gotoxy (39,13);write ('r');
       delay(150);tc(8);gotoxy (38,13);write ('P');
       delay(150);tc(7);gotoxy (38,13);write ('P');
       delay(150);tc(15);gotoxy (38,13);write ('P');

       delay(150);tc(15);gotoxy (38,13);write ('P');
       delay(150);tc(7);gotoxy (38,13);write ('P');
       delay(150);tc(8);gotoxy (38,13);write ('P');
       delay(150);tc(0);gotoxy (38,13);write ('P');
       delay(150);tc(15);gotoxy (39,13);write ('r');
       delay(150);tc(7);gotoxy (39,13);write ('r');
       delay(150);tc(8);gotoxy (39,13);write ('r');
       delay(150);tc(0);gotoxy (39,13);write ('r');
  delay(150);tc(15);gotoxy (44,11);write ('n');
  delay(150);tc(7);gotoxy (44,11);write ('n');
  delay(150);tc(8);gotoxy (44,11);write ('n');
  delay(150);tc(0);gotoxy (44,11);write ('n');
       delay(150);tc(15);gotoxy (40,13);write ('o');
       delay(150);tc(7);gotoxy (40,13);write ('o');
       delay(150);tc(8);gotoxy (40,13);write ('o');
       delay(150);tc(0);gotoxy (40,13);write ('o');
  delay(150);tc(15);gotoxy (43,11);write ('o');
  delay(150);tc(7);gotoxy (43,11);write ('o');
  delay(150);tc(8);gotoxy (43,11);write ('o');
  delay(150);tc(0);gotoxy (43,11);write ('o');
       delay(150);tc(15);gotoxy (41,13);write ('x');
       delay(150);tc(7);gotoxy (41,13);write ('x');
       delay(150);tc(8);gotoxy (41,13);write ('x');
       delay(150);tc(0);gotoxy (41,13);write ('x');
  delay(150);tc(15);gotoxy (42,11);write ('c');
  delay(150);tc(7);gotoxy (42,11);write ('c');
  delay(150);tc(8);gotoxy (42,11);write ('c');
  delay(150);tc(0);gotoxy (42,11);write ('c');
       delay(150);tc(15);gotoxy (42,13);write ('e');
       delay(150);tc(7);gotoxy (42,13);write ('e');
       delay(150);tc(8);gotoxy (42,13);write ('e');
       delay(150);tc(0);gotoxy (42,13);write ('e');
  delay(150);tc(15);gotoxy (41,11);write ('i');
  delay(150);tc(7);gotoxy (41,11);write ('i');
  delay(150);tc(8);gotoxy (41,11);write ('i');
  delay(150);tc(0);gotoxy (41,11);write ('i');
       delay(150);tc(15);gotoxy (43,13);write ('n');
       delay(150);tc(7);gotoxy (43,13);write ('n');
       delay(150);tc(8);gotoxy (43,13);write ('n');
       delay(150);tc(0);gotoxy (43,13);write ('n');
  delay(150);tc(15);gotoxy (40,11);write ('l');
  delay(150);tc(7);gotoxy (40,11);write ('l');
  delay(150);tc(8);gotoxy (40,11);write ('l');
  delay(150);tc(0);gotoxy (40,11);write ('l');
       delay(150);tc(15);gotoxy (44,13);write ('u');
       delay(150);tc(7);gotoxy (44,13);write ('u');
       delay(150);tc(8);gotoxy (44,13);write ('u');
       delay(150);tc(0);gotoxy (44,13);write ('u');
  delay(150);tc(15);gotoxy (39,11);write ('i');
  delay(150);tc(7);gotoxy (39,11);write ('i');
  delay(150);tc(8);gotoxy (39,11);write ('i');
  delay(150);tc(0);gotoxy (39,11);write ('i');
       delay(150);tc(15);gotoxy (45,13);write ('s');
       delay(150);tc(7);gotoxy (45,13);write ('s');
       delay(150);tc(8);gotoxy (45,13);write ('s');
       delay(150);tc(0);gotoxy (45,13);write ('s');
  delay(150);tc(15);gotoxy (38,11);write ('S');
  delay(150);tc(7);gotoxy (38,11);write ('S');
  delay(150);tc(8);gotoxy (38,11);write ('S');
  delay(150);tc(0);gotoxy (38,11);write ('S');
cursoron;
end;

{/\/\/\/\/\/\/\//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}
procedure pause1;



begin
repeat
gotoxy (31,24);textcolor (8);write ('.');
textcolor (3);write ('x');
textcolor (11);write ('X');
textcolor (8);write (' SMasH tHe eNteR ');
textcolor (11);write ('X');
textcolor (3);write ('x');
textcolor (8);write ('.');
if not keypressed then delay(30);gotoxy (35,24);textcolor (3);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (11);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (15);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (15);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (11);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (3);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (8);write ('S');
if not keypressed then delay(30);gotoxy (36,24);textcolor (3);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (11);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (15);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (15);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (11);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (3);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (8);write ('M');
if not keypressed then delay(30);gotoxy (37,24);textcolor (3);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (11);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (15);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (15);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (11);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (3);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (8);write ('a');
if not keypressed then delay(30);gotoxy (38,24);textcolor (3);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (11);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (15);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (15);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (11);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (3);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (8);write ('s');
if not keypressed then delay(30);gotoxy (39,24);textcolor (3);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (11);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (15);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (15);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (11);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (3);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (8);write ('H');
if not keypressed then delay(30);gotoxy (41,24);textcolor (3);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (11);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (15);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (15);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (11);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (3);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (8);write ('t');
if not keypressed then delay(30);gotoxy (42,24);textcolor (3);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (11);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (15);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (15);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (11);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (3);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (8);write ('H');
if not keypressed then delay(30);gotoxy (43,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (8);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (8);write ('e');
if not keypressed then delay(30);gotoxy (46,24);textcolor (3);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (11);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (15);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (15);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (11);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (3);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (8);write ('N');
if not keypressed then delay(30);gotoxy (47,24);textcolor (3);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (11);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (15);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (15);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (11);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (3);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (8);write ('t');
if not keypressed then delay(30);gotoxy (48,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (8);write ('e');
if not keypressed then delay(30);gotoxy (49,24);textcolor (3);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (11);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (15);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (15);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (11);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (3);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (8);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (3);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (11);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (15);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (15);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (11);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (3);write ('R');
if not keypressed then delay(30);gotoxy (49,24);textcolor (8);write ('R');
if not keypressed then delay(30);gotoxy (48,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (48,24);textcolor (8);write ('e');
if not keypressed then delay(30);gotoxy (47,24);textcolor (3);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (11);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (15);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (15);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (11);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (3);write ('t');
if not keypressed then delay(30);gotoxy (47,24);textcolor (8);write ('t');
if not keypressed then delay(30);gotoxy (46,24);textcolor (3);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (11);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (15);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (15);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (11);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (3);write ('N');
if not keypressed then delay(30);gotoxy (46,24);textcolor (8);write ('N');
if not keypressed then delay(30);gotoxy (45,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (45,24);textcolor (8);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (15);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (11);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (3);write ('e');
if not keypressed then delay(30);gotoxy (43,24);textcolor (8);write ('e');
if not keypressed then delay(30);gotoxy (42,24);textcolor (3);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (11);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (15);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (15);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (11);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (3);write ('H');
if not keypressed then delay(30);gotoxy (42,24);textcolor (8);write ('H');
if not keypressed then delay(30);gotoxy (41,24);textcolor (3);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (11);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (15);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (15);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (11);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (3);write ('t');
if not keypressed then delay(30);gotoxy (41,24);textcolor (8);write ('t');
if not keypressed then delay(30);gotoxy (39,24);textcolor (3);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (11);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (15);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (15);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (11);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (3);write ('H');
if not keypressed then delay(30);gotoxy (39,24);textcolor (8);write ('H');
if not keypressed then delay(30);gotoxy (38,24);textcolor (3);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (11);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (15);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (15);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (11);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (3);write ('s');
if not keypressed then delay(30);gotoxy (38,24);textcolor (8);write ('s');
if not keypressed then delay(30);gotoxy (37,24);textcolor (3);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (11);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (15);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (15);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (11);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (3);write ('a');
if not keypressed then delay(30);gotoxy (37,24);textcolor (8);write ('a');
if not keypressed then delay(30);gotoxy (36,24);textcolor (3);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (11);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (15);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (15);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (11);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (3);write ('M');
if not keypressed then delay(30);gotoxy (36,24);textcolor (8);write ('M');
if not keypressed then delay(30);gotoxy (35,24);textcolor (3);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (11);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (15);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (15);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (11);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (3);write ('S');
if not keypressed then delay(30);gotoxy (35,24);textcolor (8);write ('S');
until keypressed;

end;

{/\/\/\/\/\/\/\//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}
procedure pause2;

begin
repeat
      gotoxy (32,24);textcolor (5);write ('[');
      textcolor (8);write ('');
      textcolor (8);write ('Press Enter');
      textcolor (8);write ('');
      textcolor (5);write (']');
if not keypressed then delay(30);gotoxy (33,24);textcolor (7);write ('');
if not keypressed then delay(30);gotoxy (51,24);textcolor (7);write ('');

if not keypressed then delay(30);gotoxy (34,24);textcolor (7);write ('');
if not keypressed then delay(30);gotoxy (50,24);textcolor (7);write ('');

if not keypressed then delay(30);gotoxy (33,24);textcolor (15);write ('');
if not keypressed then delay(30);gotoxy (51,24);textcolor (15);write ('');

if not keypressed then delay(30);gotoxy (35,24);textcolor (7);write ('');
if not keypressed then delay(30);gotoxy (49,24);textcolor (7);write ('');

if not keypressed then delay(30);gotoxy (34,24);textcolor (15);write ('');
if not keypressed then delay(30);gotoxy (50,24);textcolor (15);write ('');

if not keypressed then delay(30);gotoxy (33,24);textcolor (7);write ('');
if not keypressed then delay(30);gotoxy (51,24);textcolor (7);write ('');

if not keypressed then delay(30);gotoxy (36,24);textcolor (7);write ('');
if not keypressed then delay(30);gotoxy (48,24);textcolor (7);write ('');

if not keypressed then delay(30);gotoxy (35,24);textcolor (15);write ('');
if not keypressed then delay(30);gotoxy (49,24);textcolor (15);write ('');

if not keypressed then delay(30);gotoxy (34,24);textcolor (7);write ('');
if not keypressed then delay(30);gotoxy (50,24);textcolor (7);write ('');

if not keypressed then delay(30);gotoxy (33,24);textcolor (8);write ('');
if not keypressed then delay(30);gotoxy (51,24);textcolor (8);write ('');


until keypressed;

end;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

procedure pause3;

begin
repeat
      gotoxy (36,24);textcolor (8);write ('[');
      textcolor (15);write ('|');
      textcolor (8);write ('Pause');
      textcolor (15);write ('|');
      textcolor (8);write (']');
if not keypressed then delay(30);gotoxy (37,24);textcolor (15);write ('/');
if not keypressed then delay(30);gotoxy (43,24);textcolor (15);write ('/');
if not keypressed then delay(30);gotoxy (37,24);textcolor (15);write ('');
if not keypressed then delay(30);gotoxy (43,24);textcolor (15);write ('');
if not keypressed then delay(30);gotoxy (37,24);textcolor (15);write ('\');
if not keypressed then delay(30);gotoxy (43,24);textcolor (15);write ('\');
if not keypressed then delay(30);gotoxy (37,24);textcolor (15);write ('|');
if not keypressed then delay(30);gotoxy (43,24);textcolor (15);write ('|');
until keypressed;

end;

{-[Cursor Off]-/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}


procedure cursoroff;

var num : word;
begin
     port[$03D4]:=$0A; num:=port[$03D5];
     port[$03D4]:=$0A; port[$03D5]:=num or 32;
end;

{-[Cursor On]-\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

procedure cursoron;

var num : word;
begin
     port[$03D4]:=$0A; num:=port[$03D5];
     port[$03D4]:=$0A; port[$03D5]:=num xor 32;
end;

{-[ Flush the Keyboard Buffer ]--------------------------------------------}

Procedure FlushKeyboard;
Var Key : Char;
Begin
     While KeyPressed do
           Key := ReadKey;
End;

{-[Pause While Blinking LEDs]-\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}

procedure pauseb;

CONST   Enter     :  CHAR = #013; { used to simplify checks for this key }

VAR     Key_Flag_Byte_1   :  BYTE ABSOLUTE $0040:$0017;
        Key_Flag_Byte_2   :  BYTE ABSOLUTE $0040:$0018;

        Old_KFB_1,                  { these are used so we don't forget   }
        Old_KFB_2         :  BYTE;  { what all the keyboard settings were }
                                    { when before we screw them all up    }
        User_Presses      :  CHAR;
        Bit_Counter       :  BYTE;
        Dlay             :  LONGINT;

BEGIN
     Old_KFB_1 := Key_Flag_Byte_1; { save the original keyboard settings    }
     Old_KFB_2 := Key_Flag_Byte_2; { important cause we will annihilate it  }


     gotoxy(1,1);
     IF KeyPressed THEN
        User_Presses := ReadKey;
     User_Presses := ' ';
     REPEAT
           FOR Bit_Counter := 0 TO 3 DO
           BEGIN
                IF KeyPressed THEN;
                FOR Dlay := 1 TO 200000 DO; { dramatic pause }
                Key_Flag_Byte_1 := Key_Flag_Byte_1 XOR (16 SHL Bit_Counter);
           END;
           IF KeyPressed THEN
              User_Presses := ReadKey;
      gotoxy (33,25);
      textcolor (5);write ('[');tc(8);write('');tc(7);write ('');tc(15);write ('');
      textcolor (8);write ('Press Enter');
      textcolor (15);write ('');tc(7);write ('');tc(8);write ('');tc(5);write(']');
     UNTIL User_Presses  = Enter;

     Key_Flag_Byte_1  := Old_KFB_1;  { restore keyboard to original mode };
     Key_Flag_Byte_2  := Old_KFB_2;
END;
{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/}


end.
