/* infamous muggifilelistcreator for dd/linux (c) flower/project-deedee */

#include <dirent.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <time.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define	unzippath	"/usr/bin/unzip"
#define	nodizline	"No File_ID.Diz in this file!\n"
#define unzipline	"%s -qqLC %s/%s file_id.diz"

struct dizlist {
	char line[100];
	struct dizlist *next;
};

/* wildcmp routine gently borrowed from hydra's misc.c			*/

int wildcmp (char *nam, char *pat) {
	register char *p;

        for (;;) {
        	if (tolower(*nam) == tolower(*pat)) {
                        if(*nam++ == '\0')  return(1);
                        pat++;
                } else if (*pat == '?' && *nam != 0) {
                        nam++;
                        pat++;
                } else  break;
        }
        if (*pat != '*') return(0);
        while (*pat == '*') {
                if (*++pat == '\0')  return(1);
	}
        for (p=nam+strlen(nam)-1;p>=nam;p--) {
                	if (tolower(*p) == tolower(*pat))
                        	if (wildcmp(p,pat) == 1) return(1);
        }
        return(0);
}

/* fgetsnolfs routine gently borrowed from hydra and modded		*/

char *fgetsnolfs(char *buf, int n, FILE *fh) {
        char *in;
        char *tmp;

        in=fgets(buf,n,fh);
        if (!in) return 0;
        tmp=buf;
        while (*tmp) {
                if ((*tmp==10)||(*tmp==13)) {
                        *tmp=0;
                        break;
                }
                tmp++;
        }
        return in;
}


int boring(char *str) {
	int ok=1,i,j=strlen(str);

	for (i=0;i<j;i++)
		if ((str[i]!=' ') || (str[i]!='\0'))
			ok=0;
	return ok;
}

struct dizlist *getdiz() {
	FILE *diz;
	char buf[100];
	struct dizlist *tmp,*e=NULL,*h=NULL;
		
	if ((diz=fopen("file_id.diz","r"))) {
		while (fgetsnolfs(buf,100,diz)!=0) {
			if (!boring(buf)) {
				tmp=(struct dizlist *)malloc(sizeof(struct dizlist));
				strcpy(tmp->line,buf);
				tmp->next=NULL;
				if (h==NULL) {
					e=h=tmp;
				} else {
					e=e->next=tmp; /* god, i lub c :) */
				}
			}
		}
		fclose(diz);
	} else {
		h=(struct dizlist *)malloc(sizeof(struct dizlist));
		strcpy(h->line,nodizline);
		h->next=NULL;
	}
	return h;
}

char *makedate() {
	char *tmp=(char*)malloc(9);
	time_t *t;
	struct tm *tid;
	
	time(t);
	tid=localtime(t);
	sprintf(tmp,"%2.2d.%2.2d.%2.2d",tid->tm_mday,tid->tm_mon,tid->tm_year);
	return tmp;
}

char *makelongdate() {
	time_t *t;
	
	time(t);
	return ctime(t);
}

void processfile(struct dirent *fil,char *path,int shortlist) {
	struct dizlist *dl,*t;
	char *tmpstr=(char*)malloc(1000);
	char *args[10];
	int cp,i=1;
	struct stat s;

	remove("file_id.diz");
	sprintf(tmpstr,unzipline,unzippath,path,fil->d_name);
        args[0]=tmpstr;

        while (*tmpstr)
        {
                if (*tmpstr==' ') {
                        *tmpstr=0;
                        tmpstr++;
                        args[i]=tmpstr;
                        i++;
                } else tmpstr++;
        }
        args[i]=0;
	
	cp=fork();
	if (cp==-1) {
		printf("*unf* her findes ingen gaffel :)\n");
		exit(1);
	} else if (cp==0) {
		execvp(args[0],&args[0]);
		kill(getpid(),SIGKILL); /* hvis nu execvp fejler */
	} else {
		waitpid(-1,0,0);
	}

	dl=getdiz();
	sprintf(tmpstr,"%s/%s",path,fil->d_name);
	stat(tmpstr,&s);

	if (shortlist) {
		sprintf(tmpstr,"%-12.12s P--- %7.7ld %s %s\n",fil->d_name,s.st_size,makedate(),dl->line);
		t=dl; dl=dl->next; free(t);
	} else {
		sprintf(tmpstr,"%-34.34s P--- %7.7ld %s",fil->d_name,s.st_size,makelongdate());
	}
	printf(tmpstr);

	while (dl!=NULL) {
		sprintf(tmpstr,"                                   %s\n",dl->line);
		printf(tmpstr);
		t=dl; dl=dl->next; free(t);
	}
	free(tmpstr);
}

void processpath(char *path,int shortlist) {
	DIR *lupdir;
	struct dirent *deent;
	
	if ((lupdir=opendir(path))) {
		while ((deent=readdir(lupdir))) {
			if (!strcmp(deent->d_name,".")||(!strcmp(deent->d_name,".."))) continue; 
			if (wildcmp(deent->d_name,"*.zip"))
				processfile(deent,path,shortlist);
		}
		closedir(lupdir);
	}
}

void main(int argc,char *argv[]) {
	int shortlist=0;

	fprintf(stderr,".________________________________________.\n");
	fprintf(stderr,"|                             _____      |\n");
	fprintf(stderr,"|     P R O J E C T         _/.  . \\_/*  |\n");
	fprintf(stderr,"|                         */ \\__,__/ \\/_/|\n");
	fprintf(stderr,"|      D E E D E E         _____/____/   |\n");
	fprintf(stderr,"|                        _/_ /____\\      |\n");
	fprintf(stderr,"|       presents:       / \\  /    \\  /\\  |\n");
	fprintf(stderr,"|                            \\     \\/ _\\ |\n");
	fprintf(stderr,"| muggi filelist creator   \\__\\          |\n");
	fprintf(stderr,"|        v1.0 beta                       |\n");
	fprintf(stderr,"|________________________________________|\n");

	if (argc<2) {
		fprintf(stderr,"syntax: localup <path> [S|l]\n");
		fprintf(stderr,"		  |	`-----> s=short,l=long dirformat.\n");
		fprintf(stderr,"		  `-------> path to files.\n");
		fprintf(stderr,"output will goto stdout, so be sure to redirect.\n");
		exit(2);
	}
	if (strcasecmp(argv[2],"l")) shortlist=1;

	fprintf(stderr,"Uploading-> Please hold..\n");
	processpath(argv[1],shortlist);
	remove("file_id.diz");
	fprintf(stderr,"Done-> Thank you for choosing project-deedee :)\n");
}
