#include "main/dd.h"
#include <stdio.h>
#include <time.h>

struct lastline {
  char line[80];
};

char *makebytestr(ULONG nip) {
  char *tmp=(char *)malloc(5);

  tmp[0]='\0';
  if (nip==0)
    sprintf(tmp,"----");
  else if (nip<1000)
    sprintf(tmp,"%3.3db",nip);
  else if (nip<1048576)
    sprintf(tmp,"%3.3dK",nip/1024);
  else if (nip<1073741824)
    sprintf(tmp,"%3.3dM",nip/(1024*1024));
  else
    sprintf(tmp,"hmm?");
  return tmp;
}

char *findnewcaller(char *node) {
  FILE *lf,*uf;
  struct callerslog *last=(struct callerslog *)malloc(sizeof(struct callerslog));
  struct userbase *user=(struct userbase *)malloc(sizeof(struct userbase));
  struct tm *tmptime=(struct tm *)malloc(sizeof(struct tm));
  char *tmp=(char *)malloc(80);
  char *buff=(char *)malloc(80);

  tmp[0]='\0';
  sprintf(tmp,"%s/logfiles/callerslog%s.dat",getenv("DAYDREAM"),node);
  if ((lf=fopen(tmp,"rb"))!=NULL) {
    sprintf(tmp,"%s/data/userbase.dat",getenv("DAYDREAM"));
    uf=fopen(tmp,"rb");
    fseek(lf,0-sizeof(struct callerslog),SEEK_END);
    fread(last,sizeof(struct callerslog),1,lf);
    fseek(uf,(last->cl_userid)*sizeof(struct userbase),SEEK_SET);
    fread(user,sizeof(struct userbase),1,uf);

    sprintf(tmp,"   | %5.5d %2.2s",last->cl_bpsrate,node);
    if ((last->cl_flags && CL_NEWUSER)==CL_NEWUSER)
      strcat(tmp,"*");
    else
      strcat(tmp," ");
    
    sprintf(buff," %-15.15s %-21.21s ",user->user_handle,user->user_organization);
    strcat(tmp,buff);
    tmptime=localtime(&(last->cl_logon));
    sprintf(buff,"%2.2d:%2.2d ",tmptime->tm_hour, tmptime->tm_min);
    strcat(tmp,buff);
    tmptime=localtime(&(last->cl_logoff));
    sprintf(buff,"%2.02d:%2.02d ",tmptime->tm_hour, tmptime->tm_min);
    strcat(tmp,buff);
    sprintf(buff,"%s:%s |\n",makebytestr(last->cl_ulbytes),makebytestr(last->cl_dlbytes));
    strcat(tmp,buff);

    fclose(lf); fclose(uf);
  }
  free(buff);
  return tmp;
}

main(int argc, char *argv[]) {
  FILE *inlin;
  struct lastline tmp[10];
  long lines;
  int i=0;
  char *joe=(char *)malloc(255);
 
if ((argc==2) && (getenv("DAYDREAM")!=NULL)) {


  printf("           /\\__ _          _ __\n");
  printf("          //\\_            ___ /_ _\n");
  printf("         //  ____  ______/  /_  ...   ......    [ Ten Last Callers ]\n");
  printf("    _ __//  /_\\_ \\/ __/__ ___/   ::: ::: `:::\n");
  printf("     ._ /  / __/ /\\__  /  /____ ::: :::  ::: ________________________________.\n");
  printf(",    | /  / _/  /  /_ /  /     ::: ::: .:::                                  |\n");
  printf(".__/  /\\____/\\____/  /_nTw :::   `::::' ________________________________. |\n");
  printf("_ _|_\\  /__ _   _ __\\  /__ _                                               |_|\n");
  printf("   . \\\\//           \\\\//                                                   |\n");
 
  bzero(&tmp[0],(sizeof(struct lastline)*10));
  sprintf(joe,"%s/data/mlastcaller.dat",getenv("DAYDREAM"));
  if ((inlin=fopen(joe,"r+b"))!=NULL) {
    fseek(inlin,0,SEEK_END);
    if ((lines=(ftell(inlin)/sizeof(struct lastline)))<10) {
      fseek(inlin,0,SEEK_SET);
      fread(&(tmp[0]),sizeof(struct lastline),lines,inlin);
      strcpy((char *)&tmp[lines++],findnewcaller(argv[1]));
      fwrite(&tmp[lines-1],sizeof(struct lastline),1,inlin);
    } else {
      lines=10;
      fseek(inlin,sizeof(struct lastline),SEEK_SET);
      fread(&(tmp[0]),sizeof(struct lastline),9,inlin);
      strcpy((char *)&tmp[9],findnewcaller(argv[1]));
      fseek(inlin,0,SEEK_SET);
      fwrite(&tmp[0],sizeof(struct lastline),10,inlin);
    }
  } else {
    lines=1;
    inlin=fopen(joe,"wb");
    strcpy((char *)&tmp[0],findnewcaller(argv[1]));
    fwrite(&tmp[0],sizeof(struct lastline),1,inlin);
  }
  free(joe);
  fclose(inlin);
  
  for (i=0;i<lines;i++)  
    printf("%s",&tmp[i]);

  printf("   |_______________________________________________________________________|-.\n");
  printf("     |                                        muggicallers v0.1 (c) ck 1997. |\n");
  printf("     |_______________________________________________________________________|\n");

} else {
  printf("syntax: mlast <node>\n");
  printf("and remember to set the DAYDREAM environment. eg. export DAYDREAM=/home/bbs\n");
}
}
