@echo off
REM ::::: __________________________________________________________________ :::::
REM : ____\ ._ ____ _____ __. ____ ___ _______ .__ ______ .__ _____ .__ _. /____ :
REM __\ .___! _\__/__    / _|__   / _/_____  __|  \ gRK __|_ \  __  |_ \ !___. /__
REM \   ! ___/  |/  /___/  |   \__\ ._/  __\/  \   \___/  |/  \/  \_./  \___ !   /
REM /__  (___   /\____\____|\   ____|   /  /___|\   ______.    ____\|\   ___)  __\
REM   /____  \_/ ___________ \_/ __ |__/ _______ \_/ ____ |___/ _____ \_/  ____\
REM :     /________________________________________________________________\     :
REM :::::       +  p  H  E  N  O  M  p  R  O  D  U  C  T  I  O  N  S  +      :::::
REM ==============================================================================
REM
REM -----------------------------------------
REM - modName: ThreatSentry API query (Win) -
REM - majorVersion: 1                       -
REM - minorVersion: 1                       -
REM - author: StackFault                    -
REM - publisher: Phenom Productions         -
REM - website: https://www.phenomprod.com   -
REM - email: stackfault@bottomlessabyss.net -
REM - bbs: bbs.bottomlessabyss.net:2023     -
REM -----------------------------------------
REM
REM This is the API data fetcher for the ThreatSentry mod
REM
REM === Instruction to install cURL for WIndows ================================
REM
REM  This API requires you to download CURL for Windows for your architecture
REM  Download website: https://curl.haxx.se/windows/
REM
REM  Extract the 3 files from the /bin folder within the archive to your
REM  "{themedir}\scripts\threatsentry" folder. The same folder containing this
REM  batch file
REM
REM ============================================================================
REM
REM It takes 2 arguments, the node temp directory and the user IP address
REM

REM Get your free API Key from https://ipdata.co/registration.html
REM The free API key is good for 1500 requests/day
SET APIKEY=

REM Adjust to your ThreatSentry script directory: {themedir}\scripts\threatsentry
CD \MYSTIC\SCRIPTS\THREATSENTRY

REM API request timeouts and retries
SET TIMEOUT=1
SET RETRY=3
SET DELAY=1

REM Resolve RFC1918 to current WAN IP (ex: local SysOp to WAN IP)
SET RESLOCAL=1

REM Resolve loopback to current WAN IP (ex: local SysOp to WAN IP)
SET RESLOOPBACK=1

REM
REM Nothing to modify below this line
REM

REM Get arguments from the command-line
SET NODEDIR=%1
SET IP=%2

REM Make sure the node directory is specified
IF "%NODEDIR%"=="" (
  ECHO "Required node directory not specified"
  EXIT /B 1
)

REM Make sure the IP is specified
IF "%IP%"=="" (
  ECHO "Required ip not specified"
  EXIT /B 1
)

REM Make sure the node directory exists
IF NOT EXIST %NODEDIR%\NUL (
  ECHO "Required node directory does not exist"
  EXIT /B 1
)

REM Make sure we have curl in the path
IF NOT EXIST CURL.EXE (
  ECHO "Required curl.exe not found"
  EXIT /B 1
)

REM Delete previous threatsentry-data.json if present
if EXIST %NODEDIR%\threatsentry-data.json (
  DEL %NODEDIR%\threatsentry-data.json
)

REM Query the API only if the IP seems to be an IP (very basic checking)
ECHO %IP% | FINDSTR /R "^[0-9\.\:A-Fa-f]*$"
IF NOT ERRORLEVEL 0 (
  EXIT /B 0
)

REM Check if address is loopback (127.*, ::1, fe80:*)
ECHO %IP% | FINDSTR /R "^127\. ^::1$ ^[fF][eE]80\:"
IF "%ERRORLEVEL%"=="0" (
  IF "%RESLOOPBACK%"=="1" (
    ECHO CLEARING 127
    SET IP=
  ) ELSE (
    EXIT /B 0
  )
)

REM Check if IP is ULA (fc00:*)
ECHO %IP% | FINDSTR /R "^[fF][cC]00:"
IF "%ERRORLEVEL%"=="0" (
  IF "%RESLOCAL%"=="1" (
    SET IP=
  ) ELSE (
    EXIT /B 0
  )
)

REM Check if IP is RFC1918
ECHO %IP% | FINDSTR /R "^172\.16\. ^172\.17\. ^172\.18\. ^172\.19\. ^172\.20\. ^172\.21\. ^172\.22\. ^172\.23\. ^172\.24\. ^172\.25\. ^172\.26\. ^172\.27\. ^172\.28\. ^172\.29\. ^172\.30\. ^172\.31\."
IF "%ERRORLEVEL%"=="0" (
  IF "%RESLOCAL%"=="1" (
    SET IP=
  ) ELSE (
    EXIT /B 0
  )
)

ECHO %IP% | FINDSTR /R "^192.168\."
IF "%ERRORLEVEL%"=="0" (
  IF "%RESLOCAL%"=="1" (
    SET IP=
  ) ELSE (
    EXIT /B 0
  )
)

ECHO %IP% | FINDSTR /R "^10\."
IF "%ERRORLEVEL%"=="0" (
  IF "%RESLOCAL%"=="1" (
    SET IP=
  ) ELSE (
    EXIT /B 0
  )
)

REM Query the API for IP address stats
CURL.EXE -s --retry %RETRY% --retry-delay %DELAY% --connect-timeout %TIMEOUT% "https://api.ipdata.co/%IP%?api-key=%APIKEY%" -o "%NODEDIR%/threatsentry-data.json"

EXIT /B 0
