#!/bin/bash
# ::::: __________________________________________________________________ :::::
# : ____\ ._ ____ _____ __. ____ ___ _______ .__ ______ .__ _____ .__ _. /____ :
# __\ .___! _\__/__    / _|__   / _/_____  __|  \ gRK __|_ \  __  |_ \ !___. /__
# \   ! ___/  |/  /___/  |   \__\ ._/  __\/  \   \___/  |/  \/  \_./  \___ !   /
# /__  (___   /\____\____|\   ____|   /  /___|\   ______.    ____\|\   ___)  __\
#   /____  \_/ ___________ \_/ __ |__/ _______ \_/ ____ |___/ _____ \_/  ____\
# :     /________________________________________________________________\     :
# :::::       +  p  H  E  N  O  M  p  R  O  D  U  C  T  I  O  N  S  +      :::::
# ==============================================================================
#
# -----------------------------------------
# - modName: ThreatSentry API query       -
# - majorVersion: 1                       -
# - minorVersion: 1                       -
# - author: StackFault                    -
# - publisher: Phenom Productions         -
# - website: https://www.phenomprod.com   -
# - email: stackfault@bottomlessabyss.net -
# - bbs: bbs.bottomlessabyss.net:2023     -
# -----------------------------------------
#
# This is the API data fetcher for the ThreatSentry mod
#
# It takes 2 arguments, the node temp directory and the user IP address
#

# Get your free API Key from https://ipdata.co/registration.html
# The free API key is good for 1500 requests/day
apikey=""

# API request timeouts and retries
timeout=2
retry=2
delay=1

# Resolve RFC1918 to current WAN IP (ex: local SysOp to WAN IP)
reslocal=1

# Resolve loopback to current WAN IP (ex: local SysOp to WAN IP)
resloopback=0

#
# Nothing to modify below this line
#

# Get arguments from the command-line
nodedir=$1
ip=$2

# Make sure the node directory is specified
if [ -z ${nodedir} ]; then
  echo "Required node directory not specified"
  exit 1
fi

# Make sure the IP is specified
if [ -z ${ip} ]; then
  echo "Required ip not specified"
  exit 1
fi

# Make sure the node directory exists
if [ ! -d ${nodedir} ]; then
  echo "Required node directory does not exist"
  exit 1
fi

# Make sure we have curl in the path
if [ ! -x $(which curl) ]; then
  echo "Required curl not found"
  exit 1
fi

# Delete previous threatsentry-data.json if present
if [ -f "${nodedir}/threatsentry-data.json" ]; then
  rm ${nodedir}/threatsentry-data.json
fi

# Query the API only if the IP seems to be an IP (very basic checking)
if [[ ! $ip =~ ^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$|^[a-fA-F0-9\:]{3,39}$ ]]; then
  exit 0
fi

# Check if address is loopback (127.*, ::1, fe80:*)
if [[ $ip =~ (^127\.|^::1$|^[fF][eE]80:) ]]; then
  if [ ${resloopback} -gt 0 ]; then
    ip=
  else
    exit 0
  fi
fi

# Check if IP is ULA (fc00:*)
if [[ $ip =~ ^[fF][cC]00: ]]; then
  if [ ${reslocal} -gt 0 ]; then
    ip=
  else
    exit 0
  fi
fi

# Check if IP is RFC1918
if [[ $ip =~ ^172\.(16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)\. ]]; then
  if [ ${reslocal} -gt 0 ]; then
    ip=
  else
    exit 0
  fi
fi

if [[ $ip =~ ^192\.168\. ]]; then
  if [ ${reslocal} -gt 0 ]; then
    ip=
  else
    exit 0
  fi
fi

if [[ $ip =~ ^10\. ]]; then
  if [ ${reslocal} -gt 0 ]; then
    ip=
  else
    exit 0
  fi
fi

# Query the API for IP address stats
curl -s --retry ${retry} --retry-delay ${delay} --connect-timeout ${timeout} "https://api.ipdata.co/${ip}?api-key=${apikey}" -o "${nodedir}/threatsentry-data.json"

exit 0

