﻿using System;
using RandM.RMLib;
using System.IO;
using System.Text.RegularExpressions;
using System.Diagnostics;

namespace TwoFactorAuth
{
    class Program
    {
        static RMDoor Door;
        static string _userName = "";
        static int count = 0;

        static void Main(string[] args)
        {
            try
            {
                using (Door = new RMDoor())
                {
                    Door.OnTimeOut = new RMDoor.OnTimeOutCallback(DefaultOnTimeOut);
                    Door.OnHangUp = new RMDoor.OnHangUpCallback(DefaultOnHangUp);

                    Door.Session.MaxIdle = 60;

                    _userName = Door.DropInfo.Alias.ToString();

                    Verify(_userName);
                }
            }
            catch (Exception ex)
            {
                var st = new StackTrace(ex, true);
                var frame = st.GetFrame(0);
                var line = frame.GetFileLineNumber();

                File.AppendAllText("twofactorauth.txt", DateTime.Now + " - Line: " + line.ToString() + Environment.NewLine + ex.ToString() + Environment.NewLine + Environment.NewLine);
            }
        }

        static void Verify(string userName)
        {
            userName = RemoveInvalidFilePathCharacters(userName, "");

            if (!File.Exists(AppDomain.CurrentDomain.BaseDirectory + @"\users\" + userName + ".ini"))
            {
                string[] lines = { "[USER]", "TwoFactorAuth=False", "TwoFactorAuthCode=0000000000000000" };
                File.WriteAllLines(AppDomain.CurrentDomain.BaseDirectory + @"\users\" + userName + ".ini", lines);
            }

            IniFile Ini = new IniFile(AppDomain.CurrentDomain.BaseDirectory + @"\users\" + userName + ".ini");
            string twoFactorAuthentication = Ini.ReadString("USER", "TwoFactorAuth", "False");
            string twoFactorAuthenticationCode = Ini.ReadString("USER", "TwoFactorAuthCode", "0000000000000000");

            if (twoFactorAuthentication == "True")
            {
                startOver:

                string _authCode1 = "";
                string _authCode2 = "";
                string _authCode3 = "";
                string _authCode4 = "";
                string _authCode5 = "";
                string _authCode6 = "";

                Door.ClrScr();
                DisplayAnsi("2factor");

                // Key 1
                Door.GotoXY(22, 13);
                char Ch = '\0';
                do
                {
                    char? TempCh = Door.ReadKey();
                    if (TempCh == null) continue;

                    Ch = Char.ToUpper((char)TempCh);

                    _authCode1 = Ch.ToString();
                    Door.Write(_authCode1);
                    break;
                } while (Ch != 'Q');

                // Key 2
                Door.GotoXY(29, 13);
                Ch = '\0';
                do
                {
                    char? TempCh = Door.ReadKey();
                    if (TempCh == null) continue;

                    Ch = Char.ToUpper((char)TempCh);

                    _authCode2 = Ch.ToString();
                    Door.Write(_authCode2);
                    break;
                } while (Ch != 'Q');

                // Key 3
                Door.GotoXY(36, 13);
                Ch = '\0';
                do
                {
                    char? TempCh = Door.ReadKey();
                    if (TempCh == null) continue;

                    Ch = Char.ToUpper((char)TempCh);

                    _authCode3 = Ch.ToString();
                    Door.Write(_authCode3);
                    break;
                } while (Ch != 'Q');

                // Key 4
                Door.GotoXY(44, 13);
                Ch = '\0';
                do
                {
                    char? TempCh = Door.ReadKey();
                    if (TempCh == null) continue;

                    Ch = Char.ToUpper((char)TempCh);

                    _authCode4 = Ch.ToString();
                    Door.Write(_authCode4);
                    break;
                } while (Ch != 'Q');

                // Key 5
                Door.GotoXY(51, 13);
                Ch = '\0';
                do
                {
                    char? TempCh = Door.ReadKey();
                    if (TempCh == null) continue;

                    Ch = Char.ToUpper((char)TempCh);

                    _authCode5 = Ch.ToString();
                    Door.Write(_authCode5);
                    break;
                } while (Ch != 'Q');

                // Key 6
                Door.GotoXY(58, 13);
                Ch = '\0';
                do
                {
                    char? TempCh = Door.ReadKey();
                    if (TempCh == null) continue;

                    Ch = Char.ToUpper((char)TempCh);

                    _authCode6 = Ch.ToString();
                    Door.Write(_authCode6);
                    break;
                } while (Ch != 'Q');

                string _authCode = _authCode1 + _authCode2 + _authCode3 + _authCode4 + _authCode5 + _authCode6;
                if (TOTP.Lib.TOTP.GetTotp(twoFactorAuthenticationCode) == _authCode)
                {
                    Door.ClearBuffers();
                    Door.Dispose();
                }
                else
                {
                    count++;

                    if (count == 3)
                    {
                        Door.ClearBuffers();
                        Door.Disconnect();
                        Door.Dispose();
                        Environment.Exit(0);
                    }

                    goto startOver;
                }
            }
            else
            {
                Door.ClearBuffers();
                Door.Dispose();
                Environment.Exit(0);
            }
        }

        static bool DisplayAnsi(string fileName)
        {
            if (string.IsNullOrEmpty(fileName))
            {
                return false;
            }
            else
            {
                Door.DisplayFile(AppDomain.CurrentDomain.BaseDirectory + @"\" + fileName.ToLower() + ".ans", 0);
            }

            return false;
        }

        private static void DefaultOnTimeOut()
        {
            Door.Disconnect();
            Door.Dispose();
            Environment.Exit(0);
        }

        private static void DefaultOnHangUp()
        {
            Door.Dispose();
            Environment.Exit(0);
        }

        public static string RemoveInvalidFilePathCharacters(string filename, string replaceChar)
        {
            string regexSearch = new string(Path.GetInvalidFileNameChars()) + new string(Path.GetInvalidPathChars());
            Regex r = new Regex(string.Format("[{0}]", Regex.Escape(regexSearch)));
            return r.Replace(filename, replaceChar);
        }
    }
}