#! /bin/sh
#
# MkInvis v1.04 for glftpd by phillie
#
# this script adds/deletes a privpath entry in glftpd.conf
# it got no error-handling and will NEVER get one.
#
# tested on glftpd 1.27.
#
# example how to add it to your glftpd.conf:
# site_cmd MKINVIS	EXEC	/glftpd/bin/mkinvis.sh
# custom-mkinvis	1	!N
#

## config:

# your glftpd path
GLPATH=/glftpd

# you glftpd config file
GLCONF=/etc/glftpd.conf

# your site root-path
SITEPATH=/glftpd/site

# flags/users/groups that will ALWAYS be added to the privchan
# line.
PADDITION="1 =STAFF"

###################################################################

echo "MkInvis v1.04 for glftpd by phillie 2002"

case "$1" in

  add)
    CCOUNT="`grep -c \"privpath $SITEPATH$2 $3 $PADDITION\" $GLCONF`"
    if [ $CCOUNT != "0" ]
    then
      echo "ERROR: private-path already exist."
      exit 0
    fi
    echo "Adding privatepath $2 for $3 to config file ..."
    echo "Processing, hope your params are not wrong ..."
    { cat $GLCONF
      echo "privpath $SITEPATH$2 $3 $PADDITION" | tr -s ' '
    } > $GLPATH/mkinvis.$3
    mv -f $GLPATH/mkinvis.$3 $GLCONF > /dev/null
    $GLPATH/bin/reset > /dev/null
    echo "DONE."
  ;;

  del)
    CCOUNT="`grep -c \"privpath $SITEPATH$2 $3 $PADDITION\" $GLCONF`"
    if [ $CCOUNT = "0" ]
    then
      echo "ERROR: no match found."
      exit 0
    fi
    echo "Deleting privatepath $2 for $3 to config file ..."
    echo "Processing, hope your params are not wrong ..."
    grep -v "^privpath $SITEPATH$2 $3 $PADDITION" $GLCONF | tr -s ' ' \
      > $GLPATH/mkinvis.$3
    mv -f $GLPATH/mkinvis.$3 $GLCONF
    $GLPATH/bin/reset
    echo "DONE."
  ;;

  list)
    CCOUNTS="`grep -c \"privpath\" $GLCONF`"
    CNCOUNTS="`grep -c -v \"privpath\" $GLCONF`"
    CACOUNTS=$(($CCOUNTS+$CNCOUNTS))
    echo "Currently added private-paths in $GLCONF:"
    echo "----------------------------------------------------------------"
    if [ $CCOUNTS = "0" ]
    then
      echo "none."
    else
      grep "privpath" $GLCONF
    fi
    echo "----------------------------------------------------------------"
    echo "Scanned Lines: $CACOUNTS Matches: $CCOUNTS Non-Matched: $CNCOUNTS"
  ;;

  *)
    echo "ERROR: no/wrong args."
    echo "site mkinvis {add|del} <dir> {flag|-user|=group}"
    echo "to get a list of private-paths, use 'site mkinvis list'"
  ;;

esac
exit 0
