//PCBoard 15.X WHO.CPP Version 1.2
//
//September 12, 1995  (C) Peregrine Hardware, Inc
//Author: Kevin McGrail

#include <dir.h>         //Used for Maxpath
#include <io.h>	         //Used for Access
#include <conio.h>       //Used for wherey
#include <iostream.h>    //Used for Cout
#include <share.h>       //Used for fsopen
#include <stdio.h>       //Used for File
#include <string.h>      //Used for string copy etc
#include "nl.h"          //Defines NewLine
#include "error.h"       //Error Handler
#include "usernet.h"     //Usernet.h structs

int nodeup(int node, char *status);  	   //Checks to see if a node is up
char *what(char status, char *operation);  //Shows what a user is doing
void header();  			   //Prints the header
void footer();  			   //Prints the footer
int exist(char *filepath);            //Checks to see if a file or path exists
void parseargs(int numargs, char *args[], char arg1[MAXPATH]);  //parses commandline

int main(int argc, char *argv[]) {
  usernethdrtype RecSize;   //Recsize is a struct for store the Usernet Header
  noderectype RecInfo;      //RecInfo is a struct for each nodes info
  FILE *f;                  //File stream for pcboard.dat and usernet.xxx
  char usernet[MAXPATH];    //String for usernet filename and path


  parseargs(argc, argv, usernet);  //Get position of usernet from user
  f = _fsopen(usernet, "rb", SH_DENYNO);  //open usernet
  if (f==NULL) {
    error("Error opening USERNET.XXX",FILE_NOT_EXIST);
  }

  fread(&RecSize,sizeof(usernethdrtype),1,f);  //Read the header

  header();    //Output a header
  int statusbytes=RecSize.NumOfNodes/8;  //Determine number of bytes for attention and status
  if (RecSize.NumOfNodes%8) statusbytes++;  //Round up to greatest integer

  char *attention=new char[statusbytes];  //Allocate mem for status and attention
  char *upstatus=new char[statusbytes];
  fread(attention,1,statusbytes,f);  //Read status and attention bytes
  fread(upstatus,1,statusbytes,f);
  textcolor(WHITE);
  for (int i=0;i<=(RecSize.NumOfNodes-1);i++) {  //Do the main loop for each node
    if (nodeup(i, upstatus)) {  //Don't process if the node isn't up
      fread(&RecInfo,sizeof(noderectype),1,f);  //Read the current node Info
      fseek(f,(RecSize.SizeOfRec-sizeof(noderectype)),SEEK_CUR);  //Seek through and extra space
      cprintf(" %d",(i+1));                           //Print Node #
      gotoxy(6,wherey());
      if (RecInfo.Status==' ')  //If the node is awaiting a caller print no caller
	cprintf("Needs a Caller\n\r");
      else {  //otherwise print what the user is doing, who they are, and where they are
	cprintf("%s",what(RecInfo.Status,RecInfo.Operation));
	gotoxy(32,wherey());
	if (strcmp(RecInfo.City,"")==0)
	  cprintf("%s\n\r", RecInfo.Name);
	else
	  cprintf("%s (%s)\n\r",RecInfo.Name,RecInfo.City);
      }
    } else fseek(f,RecSize.SizeOfRec,SEEK_CUR);  //If not up seek to next node
  }
  footer();  //Print footer
  fclose(f);  //Close the file
  delete attention;  //Give memory back to pool
  delete upstatus;  //Give memory back to pool
  return 0;
}

int nodeup(int node, char *status) {
  int i=node/8;  //determine which byte contains the node status
  int j=node;  //Determine the bit that contains the node status
  while (j>7) {
	 j-=8;
  }
  return((status[i] >> j) & 0x01);  //return the node's bit value
}

char *what(char status, char *operation) {  //return what a user is doing
  switch (status) {
    case '\0': return("Node is Offline");
    case 'A': return("Available for Chat");
    case 'B': return("Out to Dos");
    case 'C': return("Chatting with Sysop");
    case 'D': return("User in a Door");
    case 'E': return("Entering a Message");
    case 'F': return("Viewing a File");
    case 'G': return("Chatting with Group");
    case 'H': return("Handling Mail");
    case 'L': return("AutoLogoff Sequence");
    case 'M': return("Rcvd Broadcast Msg");
    case 'N': return("Running Event");
    case 'O': return("Logon Sequence");
    case 'P': return("Paging Sysop");
    case 'R': return("Recycling Node");
    case 'S': return("Answering a Script");
    case 'T': if (strstr(operation,"(H)")!= '\0') return ("HS-Leeching");
      else if (strstr(operation,"(U)")!='\0') return("Uploading");
      else if (strstr(operation,"(D)")!='\0') return("Downloading");
      else return("Beginning Transfer");
    case 'U': return("Unavailable for Chat");
    case 'W': return("Node dropped to Dos");
    case 'X': return("Drop to Dos pending");
    default: return("Unknown Activity");
  }
}

void header() {  //Print Header
  textcolor(WHITE);
  cprintf("\n\r ");
  textcolor(LIGHTBLUE);
  cprintf("Current Node Status");
  textcolor(WHITE);
  cprintf(" \n\r\n\r");
  textcolor(BLUE);
  cprintf("[");
  textcolor(WHITE);
  cprintf("#");
  textcolor(BLUE);
  cprintf("] [");
  textcolor(WHITE);
  cprintf("Status");
  textcolor(BLUE);
  cprintf("]                  [");
  textcolor(WHITE);
  cprintf("UserName (Location/Group)");
  textcolor(BLUE);
  cprintf("]\n\r");
  textcolor(LIGHTBLUE);
  cprintf("į\n\r");
}

void footer() {  //Print Footer
  textcolor(LIGHTBLUE);
  cprintf("į\n\r");
  textcolor(LIGHTGRAY);
  cprintf("\n\r");
}

int exist(char *filepath) {  //Determine if a file or path exists
  int exists=access(filepath,0);
  return((exists==0));
}

void parseargs(int numargs, char *args[], char arg1[MAXPATH]) {
  FILE *user;            //File stream for pcboard.dat and usernet.xxx
  char *pcbdat;	         //pointer for pcbdat environment var

  if (numargs < 2) {  //If no arguments then check the environment
    pcbdat=getenv("PCBDAT");

    if (!exist(pcbdat))
      error("Cannot find USERNET.XXX",FILE_NOT_EXIST);

    user = _fsopen(pcbdat, "r", SH_DENYNO);  //Open PCBoard.dat to fine Usernet
    if (user==NULL)
      error("Error opening USERNET.XXX",FILE_NOT_EXIST);

    for (int count=0;count<41;count++)  //Goto 41st line in pcboard.dat
      fgets(arg1, MAXPATH, user);
    fclose(user);

    arg1[strlen(arg1)-1]='\0';  //Remove the /n
  } else {
	 if (args[1][1]=='?') {
		cout << nl;
      cout << progname << " v" << version << "   " << date << "  " << copyright << nl;
      cout << "Author: Kevin McGrail" << nl << nl;
      cout << "   " << progname << " is designed for PCBoard sysops to see who is logged on, without " << nl;
      cout << "   logging on yourself.  It has been fully tested with PCBoard v15.21" << nl;
      cout << "   and under OS/2 and DV." << nl << nl;
      cout << "   If the environment variable PCBDAT is set correctly, then " << progname << " will" << nl;
      cout << "   automatically find all the files it needs.  Otherwise, a path to " << nl;
      cout << "   USERNET.XXX must be supplied." << nl << nl;
      cout << "     Examples: " << progname << " C:\\PCB\\MAIN" << nl;
      cout << "               " << progname << " C:\\PCB\\MAIN\\USERNET.XXX" << nl << nl;
      exit(0);
    } else {
      char temp[14];  //For checking if the user typed usernet.XXX at cli
      strcpy(arg1, args[1]);  //Get the argument typed on CLI
      if (arg1[strlen(arg1)-1]=='\\')  //Remove any terminating backslashes
	arg1[strlen(arg1)-1]='\0';

      int j=0;  //Copy the last 12 chars of the argument to temp
      for (int i=strlen(arg1)-12;i<(strlen(arg1)+1);i++) {
	temp[j]=arg1[i];
	j++;
      }
      //Check if temp = "\USERNET.XXX" if not add it
      if (!strcmp(strupr(temp),"\\USERNET.XXX")==0)
      strcat(arg1,"\\USERNET.XXX");
    }
  }
}

