#include <stdio.h> 
#include <dir.h>
#include <string.h>
#include <io.h>
#include <sys\stat.h>
#include <stdlib.h>
#include <fcntl.h>

char buff[256];

/* Struct of idx Header */
typedef struct header_struct {
	long filesize;
	unsigned filetime;
	unsigned filedate;
	unsigned latest;
	char reserved[6];
};

/* Struct Of each Files in IDx.. */
typedef struct idx_struct_record {
	char name[8];
	char ext[3];
	unsigned date;
	unsigned low_offset;
	char high_offset;
};

/* Convert List Date to Dos'Bit-packed date */
unsigned text2date(char * text_date) {
	unsigned date_bin;

	date_bin =  (text_date[1]-48+(text_date[0]-48)*10) << 5;          // le mm
	date_bin |= text_date[4]-48 + (text_date[3]-48)*10;               // le jj
	date_bin |= (text_date[7]-48 + (text_date[6]-48)*10) - 80  << 9;  // l'aa

	return(date_bin);
}

int old_drive;
char old_path[256];

char * buff_lst;

void fin(int return_code) {
	free(buff_lst);

	setdisk(old_drive);
	chdir(old_path);
	exit(return_code);
};

int change_drive(int actual_drive,char * drive,char * chemin_dir) {
	if(actual_drive == drive[0]-65) return 1;
	else {
		setdisk(drive[0]-65);
		if(getdisk() != drive[0]-65) {
			printf("Erreur : ne peut passer au drive %s pour %s\n",drive,chemin_dir);
			return 0;
		}
		return 1;
	}
}

int main(int argc, char * argv[]) {
	FILE * ptr_pcb, * ptr_idx;
	header_struct header_idx;
	idx_struct_record idx_record;
	struct ffblk ffblkdir, ffblkidx;
	char nom_idx[13];
	char * pos_point;
	unsigned long old_offset, new_offset;
	char nom_fic[9];

	struct stat statbuf;
	unsigned i;
	int handle_lst;
	char chemin_dir[31];
	int actual_drive;

	char drive[3], path[256], name[9], ext[4];

	if(argc < 2) {
		puts("Mage BBS 95\n");

		puts("Objet : construction des fichiers index pcboard");
		puts("Ceux-ci seront construits dans le meme repertoire que les dir\n");

		puts("Format d'appel a utiliser :");
		puts("mk_idx [drive:][\\path\\]fichier_dir_lst\n");
		puts("La reconstruction d'un index n'a lieu QUE si la date du fichier dir");
		puts("differe d'un jour minimum de celle de l'index => les nouveaux fichiers");
		puts("ne seront donc pris en compte dans les index QUE le jour suivant.");
		puts("Partant du principe que la construction des index ne se fera de toutes");
		puts("facons QU'AU moment de l'event systeme, c'est pas trop genant je pense\n");

		return 0;
	}

	if((handle_lst = open(argv[1],O_RDONLY | O_BINARY)) == -1) {
		printf("Erreur : ne peut ouvrir le fichier liste %s\n",argv[1]);
		fin(1);
	};

	fstat(handle_lst,&statbuf);

	if((buff_lst = (char *) malloc(statbuf.st_size)) == NULL) {
		printf("Erreur : debordement memoire\n");
		close(handle_lst);
		fin(1);
	};

	read(handle_lst,buff_lst,statbuf.st_size);
	close(handle_lst);

	old_drive = getdisk();
	getcurdir(old_drive+1,old_path);

	actual_drive = old_drive;

	for(i=0;i<statbuf.st_size;i+=96) {
		memcpy(chemin_dir,&buff_lst[i],30);
		chemin_dir[30]=0;

		fnsplit(chemin_dir,drive,path,name,ext);

		if(change_drive(actual_drive,drive,chemin_dir)) {
			actual_drive=drive[0]-65;
			*(strrchr(path,'\\'))=0;
			if(chdir(path))

// On essaie de changer direct : fo pas trop vouloir faire "rapide" quand
// un simple changement de directory est plus rapide qu'une lecture eventuelle
// du courant dans le cas d'un changement EFFECTIF de drive (enfin a voir)

				printf("Erreur : le repertoire %s n'existe pas pour %s\n",path,chemin_dir);
			else {
				if(findfirst(name,&ffblkdir,0))
					printf("Erreur : le fichier %s est introuvable\n",name);
				else {
					header_idx.filesize = ffblkdir.ff_fsize;
					header_idx.filedate = ffblkdir.ff_fdate;
					header_idx.filetime = ffblkdir.ff_ftime;

					strcpy(nom_idx,name);
					strcat(nom_idx,".idx");

					if(findfirst(nom_idx,&ffblkidx,0) ||
						(ffblkdir.ff_fdate > ffblkidx.ff_fdate)) { // pas d'index ou perime
						ptr_pcb = fopen(name,"rb");
						ptr_idx = fopen(nom_idx,"wb");
						header_idx.latest=0;

						fwrite(&header_idx,16,1,ptr_idx);

						old_offset = new_offset = 0;
						while (fgets(buff,256,ptr_pcb)) {
							buff[12] = 0;
							new_offset = ftell(ptr_pcb);
							if(pos_point=strchr(buff,'.')) {
								idx_record.low_offset = old_offset;
								idx_record.high_offset = old_offset >> 16;
								idx_record.ext[0] = pos_point[1];
								idx_record.ext[1] = pos_point[2];
								idx_record.ext[2] = pos_point[3];

								*pos_point = 0;
								sprintf(nom_fic,"%8s",buff);
								memcpy(idx_record.name,nom_fic,8);

								buff[32]=0;
								idx_record.date = text2date(&buff[23]);
								fwrite(&idx_record,16,1,ptr_idx);
								header_idx.latest = idx_record.date > header_idx.latest ?
														  idx_record.date : header_idx.latest;
							}
							old_offset = new_offset;
						}

						fclose(ptr_pcb);

						rewind(ptr_idx);
						fwrite(&header_idx,16,1,ptr_idx);

						fclose(ptr_idx);
					}
				}
			}
		}
	}
	fin(0);
}
