#include <daydream.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#ifndef _WINDOWS
#include <unistd.h>
#include <dirent.h>
#endif
#include <string.h>

extern struct DayDream_Archiver *arc;

int viewfile(char *params)
{
	char parbuf[1024];
	char fname[1024];
	char vbuf[1024];
	char *srcstrh;
	
	srcstrh=params;

	if (!params || !*params) {
		DDPut(sd[viewstr]);
		*vbuf=0;
		if (!(Prompt(vbuf,80,PROMPT_FILE))) return 0;
		if (!*vbuf) return 0;
		srcstrh=vbuf;
	}
	while((srcstrh=strspa(srcstrh,parbuf)))
	{
		getarchiver(parbuf);
		if (!arc) {
			sprintf(fname,sd[viewunkastr],parbuf);
			DDPut(fname);
			continue;
		}
		if (!*arc->ARC_VIEW) {
			sprintf(fname,sd[viewnosupstr],arc->ARC_NAME);
			DDPut(fname);
			continue;
		}
		if (arc->ARC_VIEWLEVEL > user.user_securitylevel) {
			sprintf(fname,sd[viewlamerstr],arc->ARC_NAME);
			DDPut(fname);
			continue;
		}
		if (!findfile(parbuf,fname,0)) {
			sprintf(fname,sd[viewnostr],parbuf);
			DDPut(fname);
			continue;
		}
		genstdiocmdline(parbuf,arc->ARC_VIEW,fname,0);
		sprintf(fname,"%sarcoutp%d",DDTMP,node);
		runstdio(parbuf,fname,3);
		DDPut("[0m");
		TypeFile(fname,TYPE_NOCODES);
		unlink(fname);
	}
	return 1;
}

int findfile(char *file, char *de, struct DayDream_Conference *tc)
{
	char buf1[1024];
	char buf2[1024];
	int fd1;
	FILE *plist;
	char *s;
	DIR *dh;
	struct dirent *dent;
	struct DayDream_Conference *co;
	
	if (tc) co=tc; else co=conf;
	
	*de=0;
	s=file;
	while(*s) {
		if (*s=='/') return 0;
		s++;
	}	
	sprintf(buf1,"%sdata/paths.dat",co->CONF_PATH);
	if ((plist=fopen(buf1,"r"))) {
		while(fgetsnolf(buf1,512,plist))
		{
			sprintf(buf2,"%s%s",buf1,file);
			if (*buf1 && ((fd1=open(buf2,O_RDONLY)) > -1)) {
				fclose(plist);
				close(fd1);

				strcpy(de,buf2);
				return 1;
			}
		}
		fclose(plist);
	}

	sprintf(buf1,"%sdata/paths.dat",co->CONF_PATH);
	if ((plist=fopen(buf1,"r"))) {
		while(fgetsnolf(buf1,512,plist))
		{
			if (*buf1 && (dh=opendir(buf1)))
			{
				while((dent=readdir(dh)))
				{
					if (!strcmp(dent->d_name,".") || (!strcmp(dent->d_name,".."))) continue;
					if (!strcasecmp(dent->d_name,file)) {
						sprintf(de,"%s%s",buf1,dent->d_name);
						break;
					}
				}
				closedir(dh);
			}
		}
		fclose(plist);
	}
	if (*de) return 1;
	return 0;
}
