#include <daydream.h>
#ifdef UNIX
#include <sys/socket.h>
#include <sys/un.h>
#endif
#include <string.h>

int pageflag;
char reason[100];


int pagesysop(char *reas)
{
	struct DayDream_PageMsg pm;
#ifdef UNIX
	struct sockaddr_un name;
	int sock;
#endif
	time_t ctim;
	int i;
	char reabuf[120];
			
	changenodestatus("Paging SysOp");

	reason[0]=0;
	if (reas) strcpy(reason,reas);

	TypeFile("pagesysop",TYPE_MAKE|TYPE_WARN);
		
	if (maincfg.CFG_FLAGS & (1L<<0)) {
		if (reason[0]==0) {
			DDPut(sd[psreasonstr]);
			if (!(Prompt(reason,75,0))) return 0;
			if (reason[0]==0) {
				DDPut("\n");
				return 0;
			}
		}
	}

	clog.cl_flags |= CL_PAGEDSYSOP;
	
#ifdef UNIX
	sock = socket(AF_UNIX, SOCK_DGRAM, 0);
	if (sock < 0) {
		return 0;
	}
#endif
	pm.pm_cmd=2;
	ctim=time(0);
	*pm.pm_string=0;
	if (onlinestat)
		sprintf(pm.pm_string,"\n\n%s / %s (node %d) paged you on %s\n",user.user_realname,user.user_handle,node,ctime(&ctim));
	if (reason[0]) {
		strcat(pm.pm_string,"Reason: ");
		strcat(pm.pm_string,reason);
		strcat(pm.pm_string,"\n\n");
	}

#ifdef UNIX
	name.sun_family = AF_UNIX;
	strcpy(name.sun_path, YELLDSOCK);

	if (sendto(sock, &pm, sizeof(struct DayDream_PageMsg), 0, (struct sockaddr *)&name, sizeof(struct sockaddr_un)) < 0) {
		DDPut(sd[pspageoffstr]);
		close(sock);
		return 0;
	}
#endif
	pages--;
	sprintf(reabuf,sd[pspagingstr],maincfg.CFG_SYSOPNAME);
	DDPut(reabuf);

	pageflag=0;     
	for (i=0;i < 20;i++)
	{
		unsigned char c;
		DDPut(".");
		delayt=1;
		while ((c=HotKey(HOT_QUICK)))
		{
			if (c==255) break;
			if (c==3) {
				DDPut(sd[psabortstr]);
				i=21;
				break;
			}
		}
		if (pageflag) break;
		
		pm.pm_cmd=1;
#ifdef UNIX
		name.sun_family = AF_UNIX;
		strcpy(name.sun_path, YELLDSOCK);
		sendto(sock, &pm, sizeof(struct DayDream_PageMsg), 0, (struct sockaddr *)&name, sizeof(struct sockaddr_un));
#endif
		sleep(1);       
	}
	if (i==20) DDPut(sd[psnosysopstr]);
#ifdef UNIX
	close(sock);
#endif
	return 0;
	
}
