/*
 * WHAT: Transfer Activities; for DayDream BBS/Linux.
 * Coding by: bObO/mYSTiC (east@canit.se)
 *
 * You may always reach me at east@canit.se, or at IRCNET (nick:east).
 *
 * As Usual, I'm always open for suggestions. Feel free to mail me at 
 * any time.
 *
 * Adios!
 *  - bObO/mYSTiC (east bbs)
 */

#ifndef _WHAT_h_
#define _WHAT_h_

#include <DDDI.h>
#include <String.h>

/*************************** - DO NOT CHANGE */
#define DOOR_VERSION 0
#define DOOR_REVISION 91
/*************************** - USED FOR COMPABILITY */

/* our main DDDI-object */
class what : public DDDI
{
public:
  what();                   /* constructor */
  ~what();                  /* destructor */

  void DDDIMain(int argc, String* argv);  /* our mainloop */

protected:
private:
  static const int DOOR_VER = DOOR_VERSION;
  static const int DOOR_REV = DOOR_REVISION;

  void AnalyzeArguments(int argc, String* argv);

  enum { STAT_STARTUL         = 0,    /* for PrintStatusLine() */
	 STAT_STARTDL         = 1,    /* and TransferEntry structure */
	 STAT_UPLOADING       = 2,
	 STAT_DOWNLOADING     = 3,
	 STAT_UPLOADOK        = 4,
	 STAT_DOWNLOADOK      = 5,
	 STAT_HYDRAUPLOADING  = 6,
	 STAT_HYDRADOWNLOADING= 7,
         STAT_HYDRAUPLOADOK   = 8,
         STAT_HYDRADOWNLOADOK = 9,
         STAT_NA              = 10 };

  void PrintHelp();  
  void PrintHeader();
  void PrintStatusLine(int node, const char* username, int status, const char* file, int size, int cps);
  void PrintSeperator(char sep);
  void PrintStats();

  struct TransferLogEntry  /* for ReadTransferLogEntry() */
  {
    int type;              /* transfer type (enum STAT_TYPE) */
    int filesize;          /* filesize in bytes */
    int bps;               /* bpsrate (always 0?) */
    int cps;               /* cpsrate */
    int errors;            /* num of errors */
    int blocksize;         /* blocksize? (1024) */
    String filename;       /* filename */
  };

  int ReadEntryFromTransferLog(FILE* fp, struct TransferLogEntry* tlf);

  int mTotalUlBytes; /* for PrintStats() */
  int mTotalUlFiles;
  int mTotalDlBytes;
  int mTotalDlFiles;

  int mShowNode;     /* Settings */
  int mFirstCnt;
  int mLastCnt;
  bool mShowUploadsOnly;
  bool mShowDownloadsOnly;
  bool mShowExtended;
  bool mShowNonstop;
};

#endif
