/**
 * dRUNkEN Announce 0.4 for DayDream/UN*X
 * by Rezine/dRUNkEN (rezine@criminology.de)
 *
 * Yoo, this is a quick&dirty hack.
 *
 * Do not expect ANYTHING of it, as I take NO warranties about anything.
 * Please read the files LICENSE and README which are included in this
 * package.
 *
 * Configuration resides in $DAYDREAM/configs/dkn-announce.cfg
**/

/*
 * Btw, this code is _UGLY_ :) Don't copy it's style... ;)
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <ddlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>
#include "parseme.h"

void writefile(void);
int readconfig(void);
int mkstatfile(void);
int rdstatfile(void);

 
struct dif *d;
int node;
struct DayDream_Conference *actconf;
unsigned long int ulbytes, dlbytes;

char *ddhome, *writedir;
char *logoff_str, *logon_str, *newfile_str;
char *act_user, *act_group, *file_upped, *confname, *confnr;

int mode=0;

char commongroup[32];
char *errormsg;

struct passwd *my_id;
struct group *my_group;


int mkstatfile(void) {
char *fbuf;
FILE *f;

	fbuf=malloc(sizeof(ddhome)+strlen("/users/")+2+strlen("/updlstats")+1);
	sprintf(fbuf,"%s/users/%i/updlstats",ddhome,dd_getintval(d,USER_ACCOUNT_ID));

	if((f=fopen(fbuf,"w")) == NULL) {
		dd_sendstring(d,"[dKN!Announce]: Couldn't write to statfile. Stats not available.\n");
		return(0);
	}
	
	fprintf(f,"%li\n%li\n",dd_getlintval(d,USER_ULBYTES),dd_getlintval(d,USER_DLBYTES));
	fclose(f);	
	return(0);
}

int rdstatfile(void) {
char *buf;
char *libuf;
FILE *f;

	buf=malloc(sizeof(getenv("DAYDREAM"))+strlen("/users/")+2+strlen("/updlstats")+1);
	sprintf(buf,"%s/users/%i/updlstats",getenv("DAYDREAM"),dd_getintval(d,USER_ACCOUNT_ID));

	if((f=fopen(buf,"r")) == NULL) {
		dd_sendstring(d,"[dKN!Announce]: Couldn't write to statfile. Stats not available.\n");
		return(0);
	}

	libuf=malloc(24);
	
	fgets(libuf,24,f);	
	libuf[strlen(libuf)-1]=0;
	ulbytes=atol(libuf);
	
	fgets(libuf,24,f);
	libuf[strlen(libuf)-1]=0;
	dlbytes=atol(libuf);
	
	fclose(f);	
	return(0);
}

int readconfig(void) {

FILE *f;
char *buf;
char *nodebuf;
char errmsg[]="[dKN!Announce]: Error in configuration file.\n";
char *ulbuf,*dlbuf;

	if(!(buf=malloc(strlen(ddhome)+strlen("/configs/dkn-announce.cfg")+2))) {
		dd_sendstring(d,"malloc() failed for buf\n");
		exit(-1);
	}
	
	strcpy(buf,ddhome);
	strcat(buf,"/configs/dkn-announce.cfg");
	
	if(!(f=fopen(buf,"r"))) {
		dd_sendstring(d,"[dKN!Announce]: Could not open config file.\n");
		dd_sendstring(d,"[dKN!Announce]: ");
		dd_sendstring(d,buf);
		dd_sendstring(d,"\n");
		exit(-1);
	}
	free(buf); 
	
	/* Allocate some memory for needed buffers. */
	
	if(!(buf=malloc(1024))) {
		dd_sendstring(d,"malloc() failed for buf\n");
		exit(-1);
	}
	
	if(mode==1) {
		mkstatfile();
		if(!(logon_str=malloc(1024))) {
			dd_sendstring(d,"malloc() failed for logon_str\n");
			exit(-1);
		}
	}
	
	if(mode==2) {
		rdstatfile();
		if(!(logoff_str=malloc(1024))) {
			dd_sendstring(d,"malloc() failed for logoff_str\n");
			exit(-1);
		}
		
		ulbuf=malloc(24);
		dlbuf=malloc(24);
		sprintf(ulbuf,"%li",dd_getlintval(d,USER_ULBYTES)-ulbytes);
		sprintf(dlbuf,"%li",dd_getlintval(d,USER_DLBYTES)-dlbytes);
	}
	
	if(mode==3) {
		if(!(newfile_str=malloc(1024))) {
			dd_sendstring(d,"malloc() failed for newfile_str\n");
			exit(-1);
		}
	}
	
    /* Get strings from config and parse them. */
	
	if(fgets(commongroup,31,f)==NULL) {
		dd_sendstring(d,errmsg);
		exit(-1);
	} else {
		commongroup[strlen(commongroup)-1]=0; /* Strip newline char */
	}
	
	if(fgets(buf,1023,f)==NULL) {
		dd_sendstring(d,errmsg);
		exit(-1);
	} else {
		writedir=malloc(strlen(buf)+1);
		strcpy(writedir,buf);
		writedir[strlen(writedir)-1]=0;
	}
	
	nodebuf=malloc(4);
	snprintf(nodebuf,3,"%i",node);

	if(fgets(buf,1023,f)==NULL) {
		dd_sendstring(d,errmsg);
		exit(-1);
	} else {
		if(mode==1) {
			if(!(strcpy(logon_str, parse_string(buf,"USER",act_user," ")))) {
				dd_sendstring(d,errmsg);
				exit(-1);
			}
			
			if(!(strcpy(logon_str, parse_string(logon_str,"GROUP",act_group," ")))) {
				dd_sendstring(d,errmsg);
				exit(-1);
			}
			strcpy(logon_str, parse_string(logon_str,"NODE",nodebuf," "));
		}
	}
	
	if(fgets(buf,1023,f)==NULL) {
		dd_sendstring(d,errmsg);
		exit(-1);
	} else {
		if(mode==2) {
			strcpy(logoff_str,parse_string(buf,"USER",act_user," "));
			strcpy(logoff_str,parse_string(logoff_str,"GROUP",act_group, " "));
			strcpy(logoff_str,parse_string(logoff_str,"NODE",nodebuf," "));
			strcpy(logoff_str,parse_string(logoff_str,"UPPED",ulbuf," "));
			strcpy(logoff_str,parse_string(logoff_str,"LEECHED",dlbuf," "));
		}
	}
	
	if(fgets(buf,1023,f)==NULL) {
		dd_sendstring(d,errmsg);
		exit(-1);
	} else {
		if(mode==3) {
			strcpy(newfile_str,parse_string(buf,"USER",act_user," "));
 			strcpy(newfile_str,parse_string(newfile_str,"GROUP", act_group, " "));
			strcpy(newfile_str,parse_string(newfile_str,"FILE",file_upped," "));
			strcpy(newfile_str,parse_string(newfile_str,"CONFNR",confnr," "));
			strcpy(newfile_str,parse_string(newfile_str,"CONFNAME", confname, " "));
		}
	}

	/* End parsing */

	free(buf);
	fclose(f);
	return(0); /* Return success */
}
		
void die(void)
{
    dd_close(d);
}

int main(int argc, char *argv[]) {

char *param;
uid_t myid;

	/* Check for existence of $DAYDREAM environment */

	if(!getenv("DAYDREAM")) {
		fprintf(stderr,"FATAL: Need $DAYDREAM environment.\n\r");
		exit(1); 
	}
	
		

	/* Get memory for the buffer that will hold the value of $DAYDREAM */
	ddhome=malloc(strlen(getenv("DAYDREAM")+1));
    strcpy(ddhome,getenv("DAYDREAM"));
    
    /* Check if we have enough commandline parameter */
    if (argc==1) {
		printf("Uhmm this won't do mate!\n");
		exit(-1);
    }
    
    /* Try to initialize our door sockets with the first parameter we have */
    if(!(d = dd_initdoor(argv[1]))) {
		printf("Couldn't find socket, bye\n");
		exit(-1);
    }

	/* If parm was a valid node, get it into our global variable. */  
    node=atoi(argv[1]);
    atexit(die);
    
    if(!(param=malloc(1024))) {
    	dd_sendstring(d,"malloc() failed for param\n");
    	exit(-1);
    } else {
    	dd_getstrval(d,param,DOOR_PARAMS);
    	if(!param) {
    		free(param);
    	}
    }
    
    if(!(act_user=malloc(32))) {
    	dd_sendstring(d,"malloc() failed for act_user\n");
    	exit(-1);
    } else {
    	dd_getstrval(d,act_user,USER_HANDLE);
    }
    
    if(!act_user) {
    	dd_sendstring(d,"ERROR: Could not get your username?!\n");
    	exit(-1);
    }
    
    if(!(act_group=malloc(32))) {
    	dd_sendstring(d,"malloc() failed for act_group\n");
    	exit(-1);
    } else {
    	dd_getstrval(d,act_group,USER_ORGANIZATION);
    }
    
    if(!act_group) {
    	dd_sendstring(d,"ERROR: Could not get your groupname?!\n");
    	exit(-1);
    }
    
    if (!strcmp(param,"")) {
    	if(argc<3) {

    		dd_sendstring(d,"[dKN!Announce]: I need a parameter!\n");
    		exit(1);

    	} else {

    		if(!strcmp(argv[2],"LOGON")) {
    			mode=1;
    		} else if (!strcmp(argv[2],"LOGOFF")) {
    			mode=2;
    		} else {
    			dd_sendstring(d,"[dKN!Announce]: I need a parameter!\n");
    			exit(1);
    		}
    	}

    } else {
 
    	actconf=dd_getconf(dd_getintval(d,SYS_CONF));
    	
    	/* Strange situation. ;) */
    	if(!actconf) {
    		dd_sendstring(d,"[dKN!Announce]: Whoops. Couldn't get conference.\n");
    		exit(-1);
    	}
    	
    	confnr=malloc(4);
    	snprintf(confnr,3,"%i",dd_getintval(d,SYS_CONF));
    	
    	/* 32 is the limit for filename length set by DayDream */
    	file_upped=malloc(32);
    	strncpy(file_upped,param,32);
    	
    	/* We get our conference name. */
    	confname=malloc(sizeof(actconf->CONF_NAME));
    	strcpy(confname,actconf->CONF_NAME);
    	
    	mode=3;
    }

	readconfig(); /* Read in configuration */
	
	/* Check for existence of the group "announce" */

	my_group=malloc(sizeof(struct group));
	
	if(!(my_group=getgrnam(commongroup))) {
		fprintf(stderr,"No group called %s on this system.\n\r",commongroup);
		fprintf(stderr,"Didn't you read the README?!\n\r");
		exit(-1);
	}
	
	/* Get Login name and UID (Should usually be user "bbs") */

	myid=getuid();
	my_id=malloc(sizeof(struct passwd));
	my_id=getpwuid(myid);
	
	/* Shit happens... */
	if(!my_id) {
		fprintf(stderr,"ERROR: Couldn't get your passwd entry.\n");
		exit(-1);
	}
	
    writefile();  /* Make announce ... */
    exit(0); /* Clean exit... ;) */
}


void writefile(void)
{
FILE *f;
char *filebuf;
char errmsg[1024];
struct stat st;
struct passwd *tmp_pw;
struct group *tmp_group;

	/* Do _some_ sanity checks. Do not relay on that. */

	if((stat(writedir,&st))) {
		snprintf(errmsg,sizeof(errmsg),"[dKN!Announce]: Could not stat %s\n",writedir);
		dd_sendstring(d,errmsg);
		exit(-1);
	}
	
	/* Check for 770 permissions on our writeable directory */

	if( ( (st.st_mode & S_IRWXU) != (S_IRUSR|S_IWUSR|S_IXUSR) ) ||
	 	( (st.st_mode & S_IRWXG) != (S_IRGRP|S_IWGRP|S_IXGRP) ) ||
	 	( (st.st_mode & S_IRWXO) )) { 
		
		snprintf(errmsg,sizeof(errmsg),"[dKN!Announce]: Wrong permissions on %s. Should be 770!\n",writedir);
		dd_sendstring(d,errmsg);
		exit(-1);
	}
	
	if(!(tmp_pw=malloc(sizeof(struct passwd)))) {
		dd_sendstring(d,"malloc() failed for tmp_pw.\n");
		exit(-1);
	}

	if(!(tmp_group=malloc(sizeof(struct group)))) {
		dd_sendstring(d,"malloc() failed for tmp_group\n");
		exit(-1);
	}
	
	tmp_group=getgrgid(st.st_gid);
	
	if(st.st_uid != 0) {
		snprintf(errmsg,sizeof(errmsg),"[dKN!Announce]: Wrong owner for %s. Must belong to UID 0 (root)\n",writedir);
		dd_sendstring(d,errmsg);
		exit(-1);
	}
	
	if(st.st_gid != my_group->gr_gid) {
		snprintf(errmsg,sizeof(errmsg),"[dKN!Announce]: Wrong group for %s. Must belong to GID %i (%s)\n",writedir,my_group->gr_gid,my_group->gr_name);
		dd_sendstring(d,errmsg);
		exit(-1);
	}

	/* End of sanity checks */

	if(!(filebuf=malloc(strlen(writedir)+1024))) {
		dd_sendstring(d,"[dKN!Announce]: malloc() failed for filebuf.\n");
		exit(0);
	}
	
	if(mode==1) {
		snprintf(filebuf,strlen(writedir)+80,"%s/node%i.logon",writedir,node);
	} else if (mode==2) {
		snprintf(filebuf,strlen(writedir)+80,"%s/node%i.logoff",writedir,node);
	} else if (mode==3) {
		snprintf(filebuf,strlen(writedir)+1023,"%s/node%i.upload.%s",writedir,node,file_upped);
	}
	
	umask(007);	/* Group writeable umask() */

	if((f=fopen(filebuf,"w"))==NULL) { /* Yoo... be careful :D */
		dd_sendstring(d,"Could not open output file for writing!!\n");
		perror(filebuf);
		dd_sendstring(d,"\n");
		exit(0);
	}

	if(mode==1) {
		dd_sendstring(d,"[dRUNkEN dOORS]: Announcing your logon to IRC.\n");
		fprintf(f,"%s",logon_str);
	} else if(mode==2) {
		dd_sendstring(d,"[dRUNkEN dOORS]: Announcing your logoff to IRC.\n");
		fprintf(f,"%s",logoff_str);
	} else if(mode==3) {
		dd_sendstring(d,"[dRUNkEN dOORS]: Announcing your upload to IRC.\n");
		fprintf(f,"%s",newfile_str);
	}

	fclose(f);
	
	/* Set group owner of the just created file to our group */	

	if((chown(filebuf,my_id->pw_uid, my_group->gr_gid))) {
		dd_sendstring(d,"ERROR: Couldn't chown() output file. Doh.\n");
		exit(-1);
	}
}

/* Blub. That's all, folks. */