# [FTPACCT.MPS]
# ----------------------------------------------------------------------------
#                  FTP Serv-U Integrator for Mystic BBS v1.2
#      Tested with FTP Serv-U v2.5e (32 bit) & Mystic v1.07a28
#             A Demonic release by grymmjack (grymmjack@home.com)
# ----------------------------------------------------------------------------
#
# NOTE: READ FTPACCT.DOX!                                                    
#
# This program works by passing command line arguments.  The valid commands 
# and their syntax follow:
#
# FTPACCT {TOGGLE|STATUS|PASS|SWITCH}
#
# TOGGLE = Toggle current users account on and off (add/remove from INI)
# STATUS = Display the status of users account and the status of the server
# PASS   = Change the users password for the FTP server
# SWITCH = Toggles the network status of your FTP server
#
# I chose to create the module this way simply because it allows for much 
# more configurability to the end user.  This way you can do what you want 
# with menus and such. See the package distribution for example menus and 
# how it can be done. Read FTPACCT.DOX!!!
#
# ----------------------------------------------------------------------------

Uses USER
Uses CFG
Uses DIR

const version     = '1.2'
const linesinrec  = 3
const DATFILENAME = 'FTPACCT'

var DATFILE string	      # path to datafile
var INIFILE string	      # path to SERV-U.INI
var TMPFILE string	      # temporary file
var FILELOCK string	      # file lock metaphor file

# array of configuration data initilaized with defaults
var DATLine string array(1..23)  

  DATLine(01) := 'C:\PROGRA~1\SERV-U\SERV-U.INI'
  DATLine(02) := 'ftp.yourbbsname.com'
  DATLine(03) := '21'
  DATLine(04) := '1'
  DATLine(05) := 'Online'
  DATLine(06) := 'Offline'
  DATLine(07) := 'Active'
  DATLine(08) := 'Inactive'
  DATLine(09) := '|CRThe server address is: |$1'
  DATLine(10) := '|CRThe server is currently: |$2'
  DATLine(11) := '|CR|CRYour account is: |$3'
  DATLine(12) := '|CREnter current pass: '
  DATLine(13) := '|CREnter your new password: '
  DATLine(14) := '|CRConfirm your new password: '
  DATLine(15) := '|CR|CRPassword incorrect!'
  DATLine(16) := '|CR|CRPasswords dont match!'
  DATLine(17) := '|CR|CRPassword Changed|CR|PA'
  DATLine(18) := 'T'
  DATLine(19) := 'bbs'
  DATLine(20) := 'FTP'
  DATLine(21) := '|CR|CR*** SERV-U.INI in use. Waiting for access...'
  DATLine(22) := '-|[D01|DE/|[D01|DE|PI|[D01|DE\|[D01|DE'
  DATLine(23) := 'granted.|DE|DE|CR'
    
var s1 string		          # temporary string 1
var s2 string		          # temporary string 2
var s3 string		          # temporary string 3
var i1 integer		        # temporary integer 1
var i2 integer		        # temporary integer 2
var i3 integer		        # temporary integer 3
var l1 longint		        # temporary longint 1

var loop integer    		  # temporary counter variable
var acct_exists boolean		# boolean global to check account existance
var line_pointer longint	# pointer for line counter for find function






# ----------------------------------------------------------------------------
# P R O C E D U R E S
# ----------------------------------------------------------------------------

# procedure waits for lockfile to be deleted then returns
procedure waitforunlock
begin

  if fexist(FILELOCK) then

    write(DATLine(21))      # display 'waiting for file access' string

    repeat
      delay(100)
      write(DATLine(22))    # display idler as waiting string (spinning cursor)
    until not fexist(FILELOCK)

    write(DATLine(23))      # display 'access gratned' string
  endif

pend



# procedure to lock lockfile
procedure lockfile
begin
	fopen(4, bin, rewrite, FILELOCK)
	fclose(4)
pend



# procedure to unlock lockfile
procedure unlockfile
begin
	ferase(FILELOCK)                    # remove the lock
pend



# procedure that clears the screen safely (switches to black bg first)
procedure clrscr
begin
	write('|16|07|CL')
pend



# procedure to create minimal data file
procedure make_dat
begin

	clrscr

	writeln(DATFILE + ' does not exist! Creating minimal DAT file now.')
	writeln('Enter the 8.3 pathname to your Serv-U INI file.')
	writeln('(Example: C:\PROGRA~1\SERV-U\SERV-U.INI)')
	write('>> ')

	INIFILE := input(127,127,1,'')

	if INIFILE <> '' then
		fopen(1, text, rewrite, DATFILE)
		fwriteln(1, INIFILE)
		fclose(1)
	else
		clrscr
		writeln('(ERROR): You must create ' + DATFILE + '!')
		writeln('         EXITING!|CR|PA|CL')
		halt
	endif

pend



# procedure to read the data file into memory
procedure read_dat
begin

	if fexist(DATFILE) then
		
		i1 := 0                           # initialize datafile item pointer
		
		fopen(1, text, reset, DATFILE)
		
		while not eof(1)                  # check to see if line is comment/blank

			freadln(1, s1)
			
			if copy(s1, 1, 1) <> '#' then    # if it is then skip it
        if copy(s1, 1, 1) <> '' then
          if copy(s1, 1, 1) <> ' ' then
            i1 := i1 + 1
            DATLine(i1) := s1
          endif
        endif
      endif

		wend
		
		fclose(1)
		INIFILE := DATLine(01)
	else
		make_dat                          # if datafile doesn't exist, create it
	endif
pend



# procedure to show valid module arguments
procedure show_args
begin
	clrscr
	writeln('(ERROR): Argument is required.')
	writeln('         Valid arguments are {TOGGLE|PISTATUS|PIPASS}')
	writeln('')
	writeln(' TOGGLE: Toggles the users account on/off (add/remove)')
	writeln(' STATUS: Displays status for user and ftp server')
	writeln('   PASS: Changes the users password.')
	writeln(' SWITCH: Toggles FTP server network status (online/offline)')
	writeln('|PA')
pend



# procedure that parses the mci codes
procedure parse_mci(line string)
begin
	
	loop := 0                           # make sure that the loop is initialized

	while loop < length(line)
		loop := loop + 1
		s2 := copy(line, loop, 1)

		if s2 = '|' then
			s2 := copy(line, loop, 3)

			if s2 = '|$1' then
				delete(line, loop, 3)
				s3 := DATLine(02) + ':' + DATLine(03)
				insert(s3, line, loop)
			endif

			if s2 = '|$2' then

				if DATLine(04) = '1' then
					delete(line, loop, 3)
					insert(DATLine(05), line, loop)
				else
					delete(line, loop, 3)
					insert(DATLine(06), line, loop)
				endif

			endif

			if s2 = '|$3' then

				if acs('F' + DATLine(18)) then
					delete(line, loop, 3)
					insert(DATLine(07), line, loop)
				else
					delete(line, loop, 3)
					insert(DATLine(08), line, loop)
				endif

			endif

		endif

	wend

	write(line)

pend



# procedure to return the line pointer of where a users account is in the ini
procedure find_account
begin
  fopen(1, text, reset, INIFILE)      

  l1 := 0                             # initialize temporary counter 
  acct_exists := false                # initialize result to false

  while not eof(1)
    l1 := l1 + 1
    freadln(1, s1)
    s2 := copy(s1, 1, 6)

    if s2 = '[USER=' then
      i2 := length(s1) - 7
      s3 := copy(s1, 7, i2)

      if s3 = USERALIAS then
        line_pointer := l1
        acct_exists := true
      endif

    endif

  wend

  fclose(1)

pend



# procedure that switches the ftp server network status
procedure switch_status
begin
  if fexist(DATFILE) then
    
    i1 := 0                           # initialize datafile item pointer
    
    fopen(1, text, reset, DATFILE)
      
      if fexist(TMPFILE) then         # if stale temp file exists, erase it
        ferase(TMPFILE)
      endif
      
      fopen(2, text, rewrite, TMPFILE)
      freadln(1, s1)
      
      while not eof(1)
        
        if copy(s1, 1, 1) = '#' then  # check to see if line is a comment/blank
          fwriteln(2, s1)             # if it is, skip it
        elseif copy(s1, 1, 1) = '' then
          fwriteln(2, s1)
        elseif copy(s1, 1, 1) = ' ' then
          fwriteln(2, s1)
        else
          i1 := i1 + 1
       
          if i1 = 4 then              # check to see if we're on line 4

            if s1 = '0' then
              fwriteln(2, '1')
              DATLine(04) := '1'
              writeln('FTP is now ' + DATLine(05))
              write('|CR|DE|DE')
              freadln(1, s1)
            else
              fwriteln(2, '0')
              DATLine(04) := '0'
              writeln('FTP is now ' + DATLine(06))
              write('|CR|DE|DE')
              freadln(1, s1)
            endif

          endif

          fwriteln(2, s1)

        endif

        freadln(1, s1)

      wend

    fwriteln(2, s1)
    fclose(1)
    fclose(2)
    
    ferase(DATFILE)                   # erase old datfile and replace w/new
    if fcopy(TMPFILE, DATFILE) then
    endif    

  endif

pend



# procedure that adds a user account (activates) to the ini file
procedure add_account
begin
  find_account                        # look for the users account in the ini

  if acct_exists then                 # if account already exists, exit
    halt
  else                                # otherwise add the users account
    fopen(1, text, append, INIFILE)
    fwriteln(1, '[USER=' + USERALIAS + ']')
    fwriteln(1, 'Group=' + DATLine(19))
    fwriteln(1, 'Password=' + USERPASSWORD)
    fclose(1)
  endif

pend



# procedure that deletes a user account (deactivates) from the ini file
procedure del_account
begin
  find_account                        # look for the users account in the ini

  if acct_exists then
    waitforunlock
    lockfile                          # lock lockfile
    ferase(TMPFILE)                   # remove stale temporary file
    fopen(1, text, reset, INIFILE)
    fopen(2, text, rewrite, TMPFILE)

    l1 := line_pointer - 1

    for i1 := 1 to l1                 # set file pointer to line account found
      freadln(1, s1)                  # on via read line data to garbage var
      fwriteln(2, s1)                 # til pointer is reached
    fend    

    line_pointer := line_pointer + linesinrec   # skip the users record

    for i1 := 1 to linesinrec
      freadln(1, s3)
    fend

    for i1 := line_pointer to filesize(1)   # continue to the end of the file

      if not eof(1) then
        freadln(1, s1)
        fwriteln(2, s1)
      endif

    fend

    fclose(1)
    fclose(2)
    
    ferase(INIFILE)                   # erase the old ini
    
    if fcopy(TMPFILE, INIFILE) then   # replace with the temp one
    endif    
    
    unlockfile                        # unlock the ini file

  else
    halt                              # if account does not exist, exit

  endif

pend



# procedure to toggle a users account on or off (add/remove from ini)
procedure toggle_account
begin

  if acs('F' + DATLine(18)) then
    menucmd('-F','-' + DATLine(18))   # if flag on, turn it off
    del_account
  else
    menucmd('-F','+' + DATLine(18))   # otherwise, turn the flag on
    add_account
  endif

pend



# procedure to display the status of the users account and ftp status
procedure show_status
begin
  parse_mci(DATLine(09))
  parse_mci(DATLine(10))
  parse_mci(DATLine(11))
pend



# procedure to change the users password on the ftp server
procedure change_pass
begin
  find_account                        # look for the users account in the ini

  if acct_exists then
    waitforunlock
    lockfile                          # lock the lockfile
    ferase(TMPFILE)                   # remove stale temp file
    fopen(1, text, reset, INIFILE)
    fopen(2, text, rewrite, TMPFILE)
    
    l1 := line_pointer - 1

    for i1 := 1 to l1                 # set file pointer to line account found
      freadln(1, s1)                  # on by reading line data to garbage vars
      fwriteln(2, s1)                 # until pointer is reached
    fend    
    
      for i1 := 1 to linesinrec - 1     
        freadln(1, s3)
        fwriteln(2, s3)
      fend

    freadln(1, s3)                    # retrieve the users pass

    i3 := length(s3) - 9
    s2 := copy(s3, 10, i3)

    write(DATLine(12))                # show string 'enter current password'
    s1 := input(12, 12, 6, '')
    if s1 = '' then                   # if input is null user has canceled
      fclose(1)                       # exit the module
      fclose(2)
      dispfile(DATLine(20))
      unlockfile
      halt
    endif
                
    if s1 <> s2 then                  # if pw is bad show badstr and halt
      write(DATLine(15))
      fclose(1)
      fclose(2)
      dispfile(DATLine(20))
      unlockfile  
      halt
    else
      write(DATLine(13))              # otherwise show 'enter new pass' str
      s1 := input(12, 12, 6, '')

      if s1 = '' then                 # if input is null user has canceled
        fclose(1)                     # exit the module
        fclose(2)
        dispfile(DATLine(20))
        unlockfile
        halt
      endif
                        
      write(DATLine(14))              # show 'confirm new password' string
      s2 := input(12, 12, 6, '')

      if s1 <> s2 then                # if confirmation fails show the
        write(DATLine(16))            # 'new pass conf failed' str and exit
        fwriteln(2, s3)
        dispfile(DATLine(20))
      else
        write(DATLine(17))            # show the 'pass change success' str
        fwriteln(2, 'Password=' + s2)
        dispfile(DATLine(20))
      endif

    endif

    for l1 := line_pointer to filesize(1)   # do the rest of the file

      if not eof(1) then
        freadln(1, s1)
        fwriteln(2, s1)
      endif

    fend

    fclose(1)
    fclose(2)
    ferase(INIFILE)                   # erase the old ini

    if fcopy(TMPFILE, INIFILE) then   # replace the ini with temp one
    endif    

    unlockfile                        # unlock the lockfile

  else
    halt                              # if account doesn't exist, exit
  endif

pend






# ----------------------------------------------------------------------------
# M A I N   P R O G R A M
# ----------------------------------------------------------------------------
begin

  getcfg
  getthisuser

  DATFILE := cfgsyspath + cfgdatapath + DATFILENAME + '.DAT'
  TMPFILE := cfgsyspath + cfgdatapath + DATFILENAME + '.TMP'
  FILELOCK := cfgsyspath + cfgdatapath + DATFILENAME + '.LCK'

  read_dat                            # read the data file configuration

  if INIFILE = '' then
    clrscr
    writeln('(ERROR): Accessing ' + DATFILE)
    writeln('         Check to make sure line #1 is valid!')
    halt
  endif
  
  if not fexist(INIFILE) then         # check to make sure the file exists
    clrscr
    writeln('(ERROR): ' + INIFILE + ' does not exist!')
    writeln('         Fix line #1 of ' + DATFILE + '!')
                writeln('         Read FTPACCT.MPS/DOX for more help..')
    writeln('|PA')
    halt
  endif
  
  if paramcount < 1 then              # if no arguments are passed, exit
    show_args
    halt
  endif
  
  if upper(paramstr(1)) = 'TOGGLE' then   # parse the args
    toggle_account
  elseif upper(paramstr(1)) = 'STATUS' then
    show_status
  elseif upper(paramstr(1)) = 'PASS' then
    change_pass
        elseif upper(paramstr(1)) = 'SWITCH' then
                switch_status
  else
    show_args
  endif

end
