#pragma once
#include <iostream>
#include "CGengine.hpp"
#include "CircParticle.hpp"

using namespace cg_engine;

class Title: public Timeframe {
	public:
		Title(Config *c);
		void show(double time);
	private:
		ShaderProgram *simple;
		Sprite *screenquad;
		unsigned int title1;
		unsigned int title2;
};

class Intro: public Timeframe {
	public:
		Intro(int w, int h, Config *c);
		void show(double time);
		void geometry(Matrix camera);
	private:
		ShaderProgram *wireframe;
		ShaderProgram *simple;
		Mesh3D *terrain;
		Mesh3D *charger;
		Mesh3D *toycar;
		Mesh3D *wheel;
		Mesh3D *skybox;
		Matrix pmatrix;
		unsigned int stars;
		Sprite *screenquad;
};

class TerrainAndCars: public Timeframe {
	public:
		TerrainAndCars(int w, int h, Config *c);
		void show(double time);
		void geometry(double time, Matrix camera);
	private:
		ShaderProgram *wireframe;
		ShaderProgram *simple;
		ShaderProgram *tinyplanet;
		Mesh3D *terrain;
		Mesh3D *charger;
		Mesh3D *toycar;
		Mesh3D *wheel;
		Mesh3D *skybox;
		Matrix pmatrix;
		CubeMap *cubemap;
		unsigned int stars;
		Sprite *screenquad;
};

class CarDrop: public Timeframe {
	public:
		CarDrop(int w, int h, Config *c);
		void show(double time);
	private:
		ShaderProgram *wireframe;
		ShaderProgram *simple;
		Mesh3D *terrain;
		Mesh3D *charger;
		Mesh3D *toycar;
		Mesh3D *wheel;
		Mesh3D *skybox;
		Matrix pmatrix;
		unsigned int stars;
};

class WholeWorld: public Timeframe {
	public:
		WholeWorld(int w, int h, Config *c);
		void show(double time);
	private:
		Mesh3D *turtle;
		Mesh3D *terrain;
		Mesh3D *charger;
		Mesh3D *toycar;
		Mesh3D *skybox;
		Matrix pmatrix;
		ShaderProgram *wireframe;
		ShaderProgram *simple;
		ShaderProgram *title;
		unsigned int poet;
		unsigned int stars;
		Sprite *screenquad;
};

class ToInfinity: public Timeframe {
	public:
		ToInfinity(int w, int h, Config *c);
		void show(double time);
	private:
		Mesh3D *charger;
		Mesh3D *toycar;
		Mesh3D *wheel;
		Matrix pmatrix;
		ShaderProgram *wireframe;
		ShaderProgram *starshader;
		CircParticle *stars;
		unsigned int startrail;
};

class RaceWorld: public Demo{
	public:
		RaceWorld(int w, int h);
		void init();
};
