#include <stdio.h>
#include <stdlib.h>
#include <SDL2/SDL.h>
#include <SDL2/SDL_mixer.h>
#include <GL/glew.h>
#include <math.h>

#include "raceworld.hpp"

int main(int, char**){
	SDL_Window *w;
	Mix_Music *music;
	Uint32 start = 0;
	double time;
	int quit = 0;
	SDL_Event event;
	int width = 0;
	int height = 0;
	SDL_DisplayMode display;

	RaceWorld *raceworld;

	SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO);
	w = SDL_CreateWindow("MoonShine", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED, 0, 0, SDL_WINDOW_FULLSCREEN_DESKTOP | SDL_WINDOW_OPENGL);
	SDL_ShowCursor(SDL_FALSE);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 4);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 1);
	SDL_GL_SetAttribute( SDL_GL_CONTEXT_PROFILE_MASK, SDL_GL_CONTEXT_PROFILE_CORE );
	SDL_GL_CreateContext(w);
	glewExperimental = GL_TRUE;
	glewInit();

	Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 2048);
	music = Mix_LoadMUS("data/raceworld.mp3");

	SDL_GetWindowSize(w, &width, &height);
	SDL_GetCurrentDisplayMode(1, &display);
	raceworld = new RaceWorld(width, height);
	raceworld->init();

	Mix_PlayMusic(music, 1);
	start = SDL_GetTicks();
	while(!quit){
		while(SDL_PollEvent(&event) != 0){
			if(event.type == SDL_KEYDOWN && event.key.keysym.sym == SDLK_ESCAPE){
				quit = 1;
			}
		}
		if(Mix_PlayingMusic() == 0){
			quit = 1;
		}
		time = ((double)SDL_GetTicks() - (double)start) / 1000.0;
		raceworld->show(time);
		SDL_GL_SwapWindow(w);
	}

	SDL_ShowCursor(SDL_TRUE);
	SDL_DestroyWindow(w);
	Mix_FreeMusic(music);
	Mix_Quit();
	SDL_Quit();

	return(EXIT_SUCCESS);
}
