#include "RenderBuffer.hpp"
#include "Matrix.hpp"

using namespace cg_engine;

RenderBuffer::RenderBuffer(int w, int h, int sy, int texnum, bool adddepth)
{
	isError    = false;
	maxtexture = texnum;
	width      = w;
	height     = h;
	starty     = sy;

	renderTexture = (GLuint*)malloc(sizeof(GLuint) * maxtexture);
	GLenum *drawBuffer = (GLenum*)malloc(sizeof(GLenum) * maxtexture);
	texnames = (char**)malloc(sizeof(char*) * maxtexture);

	glGenFramebuffers(1, &framebuffer);
	glBindFramebuffer(GL_FRAMEBUFFER, framebuffer);

	glGenTextures(maxtexture, renderTexture);

	for (int i = 0; i < maxtexture; i++) {
		glBindTexture(GL_TEXTURE_2D, renderTexture[i]);
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

		glFramebufferTexture2D(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0 + i, GL_TEXTURE_2D, renderTexture[i], 0);
		drawBuffer[i] = GL_COLOR_ATTACHMENT0 + i;
	}

	if(adddepth){
		glGenTextures(1, &depthbuffer);
		glBindTexture(GL_TEXTURE_2D, depthbuffer);
		glTexImage2D(GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT32, width, height, 0, GL_DEPTH_COMPONENT, GL_FLOAT, NULL);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
		glFramebufferTexture2D(GL_FRAMEBUFFER, GL_DEPTH_ATTACHMENT, GL_TEXTURE_2D, depthbuffer, 0);
/*
		glGenRenderbuffers(1, &depthbuffer);
		glBindRenderbuffer(GL_RENDERBUFFER, depthbuffer);
		glRenderbufferStorage(GL_RENDERBUFFER, GL_DEPTH_COMPONENT32, width, height);
		glFramebufferRenderbuffer(GL_FRAMEBUFFER, GL_DEPTH_ATTACHMENT, GL_RENDERBUFFER, depthbuffer);*/
	}

	glDrawBuffers(maxtexture, drawBuffer);
	if (glCheckFramebufferStatus(GL_FRAMEBUFFER) != GL_FRAMEBUFFER_COMPLETE) {
		isError = true;
		printf("Render to texture initialization failed\n");
	}
	glBindFramebuffer(GL_FRAMEBUFFER, 0);
	free(drawBuffer);

	outsprite = new Sprite();
}

RenderBuffer::~RenderBuffer()
{
	free(renderTexture);
	glDeleteTextures(maxtexture, renderTexture);
	glDeleteFramebuffers(1, &framebuffer);
	for(int i = 0;i < maxtexture; i++){
		free(texnames[i]);
	}
	free(texnames);
}

GLuint RenderBuffer::getFramebuffer() {
	return framebuffer;
}

GLuint RenderBuffer::getRenderTexture(int index) {
	if (index >= maxtexture) {
		return 0;
	}
	return renderTexture[index];
}

GLuint RenderBuffer::getDepth() {
	return depthbuffer;
}

bool RenderBuffer::getError() {
	return isError;
}

void RenderBuffer::firstPass() {
	glBindFramebuffer(GL_FRAMEBUFFER, framebuffer);
	glEnable(GL_DEPTH_TEST);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glViewport(0, 0, width, height);
}

void RenderBuffer::addShader(ShaderProgram *prg) {
	postprocessing = prg;
}

void RenderBuffer::secondPass()
{
	char buffer[10];
	glBindFramebuffer(GL_FRAMEBUFFER, 0);
	glDisable(GL_DEPTH_TEST);
	glClear(GL_COLOR_BUFFER_BIT);
	//glViewport(0, 0, width, height);

	postprocessing->use();

	for(int i = 0; i < maxtexture; i++){
		sprintf(buffer, "color%d", i);
		postprocessing->addTexture(buffer, renderTexture[i]);
	}

	if(depthbuffer != 0){
		postprocessing->addTexture("depth", depthbuffer);
	}
}

void RenderBuffer::draw()
{
	outsprite->draw();
}

