#include "Point3D.hpp"



Point3D::Point3D(double x, double y, double z)
{
	this->x = x;
	this->y = y;
	this->z = z;
}

Point3D::Point3D() {
	x = 0.0;
	y = 0.0;
	z = 0.0;
}

Point3D::~Point3D()
{
}

Point3D Point3D::operator-(const Point3D a)
{
	return Point3D(this->x - a.x, this->y - a.y, this->z - a.z);
}

double Point3D::dot(Point3D a, Point3D b) {
	return((a.x * b.x) + (a.y * b.y) + (a.z * b.z));
}

Point3D Point3D::cross(Point3D a, Point3D b) {
	Point3D r(0.0, 0.0, 0.0);

	r.x = a.y * b.z - a.z * b.y;
	r.y = a.z * b.x - a.x * b.z;
	r.z = a.x * b.y - a.y * b.x;

	return r;
}
