#include "CGengine.hpp"
#include <math.h>

using namespace cg_engine;

Path::Path() {
}

Path::~Path() {
}

double Path::coef(unsigned int n, unsigned int k) {
	unsigned long int c = 1;
	unsigned long int m = n - k;

	if(k < n - k){
		m = k;
	}
	
	for(unsigned long int i = 0; i < m; i++){
		c = c * (n - i) / (i + 1);
	}

	return (double)c;
}

void Path::addPoint(Point3D point) {
	controls.push_back(point);
}

Point3D Path::bezier(double t) {
	Point3D p;
	unsigned int n = controls.size() - 1;

	for(unsigned int i = 0; i <= n; i++){
		double b = coef(n, i) * pow(t, (double)i) * pow(1.0 - t, (double)(n - i));
		p.x += controls.at(i).x * b;
		p.y += controls.at(i).y * b;
		p.z += controls.at(i).z * b;
	}

	return p;
}
