#pragma once

#include <GL/glew.h>
#include <vector>
#include "MeshIndex.hpp"

#ifdef _WIN32
#define MYSTRTOK strtok_s
#else
#define MYSTRTOK strtok_r
#endif

namespace cg_engine {
	/**
	 * Mesh3D is a simple non deformable polieder made from triangles
	 * */
	class Mesh3D
	{
	private:
		const static int BUFFERNUM = 4;
		enum {VERTEX, NORMAL, TEXTURE, INDEX};

		std::vector<GLfloat>    vbuffer;  //TODO somehow add custom buffers
		std::vector<GLfloat>    tbuffer;
		std::vector<GLfloat>    nbuffer;
		std::vector<MeshIndex*> ibuffer;

		GLfloat                 *vertices;
		GLfloat                 *normals;
		GLfloat                 *textcoord;
		GLuint                  *indices;

		int                      i_count;

		bool                     has_normals;
		bool                     has_texture;

		GLuint vertexarray;
		GLuint buffers[BUFFERNUM];
		void createOpenGLBinding();
		void buildMesh();
	public:
		Mesh3D(const char *filename);
		~Mesh3D(void);
		void draw();
		void loadOBJ(const char *filename);
	};
}

