#pragma once

#include <GL/glew.h>
#include "CGengine.hpp"

namespace cg_engine {
	class CubeMap
	{
		public:
			CubeMap(int size, int width, int height);
			~CubeMap();
			void setAsRendertarget();
			void unset();
			void setSide(int side);
			GLuint getID();
		private:
			GLuint fbo = 0;
			GLuint cubemap = 0;
			GLuint render = 0;
			int size = 0;
			int width = 0;
			int height = 0;
	};
}
