#pragma once
#include <GL/glew.h>
#include <vector>
#include "Point3D.hpp"

#ifdef _WIN32
#define MYRAND rand
#else
#define MYRAND drand48
#endif

namespace cg_engine {
	class CircParticle {
		private:
			double startx;
			double starty;
			double startz;
			double r;
			double prevtime;
			int count;
			GLuint vao;
			GLuint buffers[4];
			std::vector<GLfloat> pos;
			std::vector<GLfloat> direction;
			std::vector<GLfloat> birth;
			std::vector<GLfloat> life;
			void createOpenGLBinding();
		public:
			CircParticle(int nump, GLfloat x, GLfloat y, GLfloat z, GLfloat r, double birthtime);
			~CircParticle();
			void draw();
			void update(double time);
	};
}
