#include "CircParticle.hpp"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

// I need a better solution than this
#define LIFE 12.0

using namespace cg_engine;
using namespace std;

void CircParticle::createOpenGLBinding(){

	glGenVertexArrays(1, &vao);
	glBindVertexArray(vao);

	glGenBuffers(4, buffers);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[0]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * 3 * count, &pos[0], GL_DYNAMIC_DRAW);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(0);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[1]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * 3 * count, &direction[0], GL_DYNAMIC_DRAW);
	glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(1);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[2]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * count, &birth[0], GL_DYNAMIC_DRAW);
	glVertexAttribPointer(2, 1, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(2);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[3]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * count, &life[0], GL_DYNAMIC_DRAW);
	glVertexAttribPointer(3, 1, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(3);

	glBindVertexArray(0);
}

CircParticle::CircParticle(int num, GLfloat x, GLfloat y, GLfloat z, GLfloat r, double birthtime)
{
	count  = num;
	startx = x;
	starty = y;
	startz = z;
	this->r = r;
	prevtime = birthtime;

	for(int i = 0; i < count; i++) {
		// Every particle came from a circle
		double angle = MYRAND() * M_PI * 2.0;
		pos.push_back(x + sin(angle) * r);
		pos.push_back(y + cos(angle) * r);
		pos.push_back(z - (MYRAND() * 37.0));

		// what is the destination?
		direction.push_back(0.0);
		direction.push_back(0.0);
		direction.push_back(z - (MYRAND() / 100.0));

		// Life of the particle
		birth.push_back(birthtime);
		life.push_back(birthtime + MYRAND() * LIFE);
	}
	createOpenGLBinding();
}

CircParticle::~CircParticle()
{
}

void CircParticle::draw()
{
	glBindVertexArray(vao);
	glDrawArrays(GL_POINTS, 0, count);
}

void CircParticle::update(double time)
{
	double deltatime = time - prevtime;
	for(int i = 0; i < count; i++){
		int index = i * 3;
		if( time > life.at(i)){
			double angle = MYRAND() * M_PI * 2.0;
			pos.at(index + 0) = startx + sin(angle) * r;
			pos.at(index + 1) = starty + cos(angle) * r;
			pos.at(index + 2) = startz + MYRAND() * 37.0;

			birth.at(i) = time;
			life.at(i) = time + MYRAND() * LIFE;
		} else {
			pos.at(index + 0) = pos.at(index + 0) + direction.at(index + 0) * deltatime;
			pos.at(index + 1) = pos.at(index + 1) + direction.at(index + 1) * deltatime;
			pos.at(index + 2) = pos.at(index + 2) + direction.at(index + 2) * deltatime;
		}
	}

	glBindVertexArray(vao);

	glBindBuffer(GL_ARRAY_BUFFER, buffers[0]);
	glBufferSubData(GL_ARRAY_BUFFER, 0, sizeof(GLfloat) * count * 3, &pos[0]);
	glBindBuffer(GL_ARRAY_BUFFER, buffers[1]);
	glBufferSubData(GL_ARRAY_BUFFER, 0, sizeof(GLfloat) * count * 3, &direction[0]);
	glBindBuffer(GL_ARRAY_BUFFER, buffers[2]);
	glBufferSubData(GL_ARRAY_BUFFER, 0, sizeof(GLfloat) * count, &birth[0]);
	glBindBuffer(GL_ARRAY_BUFFER, buffers[3]);
	glBufferSubData(GL_ARRAY_BUFFER, 0, sizeof(GLfloat) * count, &life[0]);

	glBindVertexArray(0);
	prevtime = time;
}

