#version 450

/*
  TinyPlanet projection code came from here:
  https://www.shadertoy.com/view/ldBczm
*/

layout (location = 0) out vec4 FragColor;

const float PI = 3.1415926536;
const float PI_2 = PI * 0.5; 
const float PI2 = PI * 2.0; 

in vec2 texcoord;

uniform samplerCube image;
uniform float param1;
uniform float param2;
uniform float param3;
uniform float param4;

vec2 calcSphericalCoordsInStereographicProjection(in vec2 screenCoord, in vec2 centralPoint, in vec2 FoVScale, float localRadius) {
    vec2 cp = (centralPoint * 2.0 - 1.0) * vec2(PI, PI_2);
    
    vec2 convertedScreenCoord = (screenCoord * 2.0 - 1.0) * FoVScale * vec2(PI, PI_2); 
    float x = convertedScreenCoord.x;
    float y = convertedScreenCoord.y;
    
    float rou = sqrt(x * x + y * y);
    float c = 2.0 * atan(rou / localRadius / 2.0); 
    float sin_c = sin( c );
    float cos_c = cos( c );  
    
    float lat = asin(cos_c * sin(cp.y) + (y * sin_c * cos(cp.y)) / rou);
    float lon = cp.x + atan(x * sin_c, rou * cos(cp.y) * cos_c - y * sin(cp.y) * sin_c);
    
    lat = (lat / PI_2 + 1.0) * 0.5; 
    lon = (lon / PI + 1.0) * 0.5; //[0, 1]

   return vec2(lon, lat) * vec2(PI2, PI);
}

vec3 sphericalToCubemap(in vec2 sph) {
    return vec3(sin(sph.y) * sin(sph.x), cos(sph.y), sin(sph.y) * cos(sph.x));
}

void main() {
    
    // Modify this to adjust the field of view
    vec2 FoVScale = vec2(0.2, 0.2) * param1;

    //
    float locrad = param2;
         
    // central / foveated point, iMouse.xy corresponds to longitude and latitude 
    vec2 centralPoint = vec2(param3, param4);
    
    vec3 dir = sphericalToCubemap( calcSphericalCoordsInStereographicProjection(texcoord, centralPoint, FoVScale, locrad) );
    
    FragColor = texture(image, dir);
}

