; Compile with "nasm.exe xxx.asm -fbin -o xxx.com"

org 100h	
	xor bp, bp

	push 8000h ; bump map
	pop ds
noise:
	add si, cx
	rol si, cl
	ror cx, 1
	add cx, ax
	lea ax, [bp+si]
	sar ax, 0ch
	inc ax
	mov dl, [di]
	inc di
	mov bl, [di]
	add bx, dx
	shr bx, 1
	add ax, bx
	mov [di+319], al
	dec bp
	jnz noise
	
	xor di, di
	push ds
	pop fs
	inc bp
	lea si, coords2
	mov cx, 4
genCirclesLoop:	
	push cx
	mov cl, 4
	call genLightmap
	pop cx
	loop genCirclesLoop
	mov cl, 3
	call genLightmap

	push 9000h
	pop fs ; light map
	mov cl, 1
	xor bp, bp
	call genLightmap

	
	push 0a000h 
	pop es ; screen

	mov ax, 13h
	int 10h

	xor ax, ax
	mov dx, 3c9h
nextColor:
	dec al 
	mov cx, 12
nextColorComponent:
	out dx, al
	loop nextColorComponent
	jnz nextColor
	
nextFrame:
nextPixel:
	mov bx, 320
	call bumpProc

	imul bx
	push ax	
	mov bx, 1
	call bumpProc
	
	pop bx
	add ax, bx
	
	mov si, di
	add si, ax
	add si, bp
	mov al, byte fs:[si]
	stosb
	test di, di
	jnz nextPixel

	dec bp
	dec bp

;	in al, 60h
;	dec al
	jnz nextFrame

;	mov ax, 03h
;	int 10h

	ret

genLightmap:
	; inputs 
	; fs=target segment
	; cl=circle size 
	; di=start of buffer
nextLightmapPixel:
	xor dx, dx
	mov ax, di
	mov bx, 320 
	div bx ; ax=y, dx=x
	xor bx,bx
	mov bl, byte cs:[si]
	sub ax, bx
	inc si
	sal ax, cl
	mov bl, byte cs:[si]
	sub dx, bx
	dec si
	sal dx, cl
	
	mov [buf], ax
	fild word [buf]
	fmul st0, st0
	mov [buf], dx
	fild word [buf]
	fmul st0, st0
	faddp st1, st0
	fsqrt

	test bp, bp
	jne genLightmapPart2
	
	fistp word fs:[di]
	mov ax, word fs:[di] ; TODO: can we check this on the FPU?
	test ah, ah
	jz notblack
	mov byte fs:[di], 255
notblack:
	fninit
	inc di
	jnz nextLightmapPixel
	inc si
	inc si
	ret
	
genLightmapPart2:
	fistp word [buf]
	mov ax, word [buf]
	cmp ah, 0
	jnz doNotWrite2
	mov byte fs:[di], 0
doNotWrite2:	
	jmp notblack


bumpProc:
	mov al, byte ds:[di+bx]
	neg bx
	sub al, byte ds:[di+bx]
	cbw
	shl ax, 1 
	ret
	
coords2 db 80, 27+40, 18, 100+40, 85, 213+40, 180, 196+40, 153, 97+40
coords db 100, 160
buf: