import java.io.*;
import java.nio.file.*;
import java.util.*;

public class GarminBoingBallGen
{
public static void main(String args[]) throws Exception
{
	double[][] boingballCoordsR = new double[9][];
	double[][] boingballCoordsL = new double[9][];
	var mid = 240 / 2;
	var len = mid * 0.73;
	var z = 0.0d;
	z = Math.toRadians(16+90); boingballCoordsL[0] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16+67.5); boingballCoordsL[1] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16+45); boingballCoordsL[2] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16+22.5); boingballCoordsL[3] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16); boingballCoordsL[4] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16-22.5); boingballCoordsL[5] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16-45.5); boingballCoordsL[6] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16-67.5); boingballCoordsL[7] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16-90); boingballCoordsL[8] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	boingballCoordsR[0] = boingballCoordsL[0];
	z = Math.toRadians(16+112.5); boingballCoordsR[1] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16+135); boingballCoordsR[2] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16+157.5); boingballCoordsR[3] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16+180); boingballCoordsR[4] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16+202.5); boingballCoordsR[5] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16+225); boingballCoordsR[6] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	z = Math.toRadians(16+247.5); boingballCoordsR[7] = new double[] {mid+len*Math.cos(z), mid+len*Math.sin(z)};
	boingballCoordsR[8] = boingballCoordsL[8];

	for (int i = 0 ;i < 20; i++) {
		var lines = new ArrayList<String>();
		lines.add("<drawable-list id=\"boing"+i+"\" background=\"Graphics.COLOR_TRANSPARENT\">");
		var angle = 25.7 / 10 * (i % 10);
		var col = i / 10;
		for (var a = 0; a < 8; a++) {
			var progressLeftAngle = -25.7 + angle;
			var progressLeft = Math.cos(Math.toRadians(progressLeftAngle)) / 2 + .5;
			for (var b = 0; b < 8; b++) {
				var rightTopX = boingballCoordsR[a][0];
				var rightTopY = boingballCoordsR[a][1];
				var rightBotX = boingballCoordsR[a+1][0];
				var rightBotY = boingballCoordsR[a+1][1];
				var leftTopX = boingballCoordsL[a][0];
				var leftTopY = boingballCoordsL[a][1];
				var leftBotX = boingballCoordsL[a+1][0];
				var leftBotY = boingballCoordsL[a+1][1];
				var progressRight = progressLeft;
				if (b == 7) {
					progressLeft = 0.0;
				} else {
					if (b == 0) {
						progressRight = 1.0;
					}
					progressLeftAngle += 25.7;
					progressLeft = Math.cos(Math.toRadians(progressLeftAngle)) / 2 + .5;
				}
				lines.add(String.format(Locale.ROOT, "<shape type=\"polygon\" points=\"[[%d,%d],[%d,%d],[%d,%d],[%d,%d]]\" color=\"%s\" />",
					lerp(rightTopX, leftTopX, progressLeft), lerp(rightTopY, leftTopY, progressLeft),
					lerp(rightTopX, leftTopX, progressRight), lerp(rightTopY, leftTopY, progressRight),
					lerp(rightBotX, leftBotX, progressRight), lerp(rightBotY, leftBotY, progressRight),
					lerp(rightBotX, leftBotX, progressLeft), lerp(rightBotY, leftBotY, progressLeft),
					((a + b) % 2) == col ? "Graphics.COLOR_RED" : "Graphics.COLOR_WHITE"
				));
			}
		}
		lines.add("</drawable-list>");
		Files.write(new File("C:/Users/Robin/programming/demos/my - i - r24 what time is it/r25/r25/resources-round-240x240/drawables/boing"+i+".xml").toPath(), lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
	}
}

static int lerp(double a, double b, double x) {
	return (int) Math.round(a + (b - a) * x);
}
}
