
noperspective out vec2 uv;
noperspective out vec3 norm;
out vec3 ws_pos;

out vec4 cs_pos;
out vec4 cs_pos_prev;


uniform int potato;

uniform vec3* buff_front;
uniform vec3* buff_back;

uniform mat4 mat;
uniform mat4 prev_mat;
uniform mat4 rot_mat;
uniform bool is_shadow;


vec3 get_vert(int id, float t){
	float fid = float(id);
	vec3 p =sin(vec3(
		fid,
		(fid+t)*1.1,
		(fid+t)*1.26
	))*2.5;
	p.y += 5.7;
	p.z += 1.5;
	p.x += 5.5;

	return p;
}

void main(){

	int id = int(gl_VertexID);


	vec3 v = get_vert(id, T);
	vec3 v_prev = get_vert(id, T - dT);

	int next_v_idx = 0;
	int next_next_v_idx = 0;

	if(id/ 3 == 0){
		next_v_idx = id + 1;
		next_next_v_idx = id + 2;
	} else if(id / 3 == 1){
		next_v_idx = id + 1;
		next_next_v_idx = id - 1;
	} else {
		next_v_idx = id - 2;
		next_next_v_idx = id - 1;
	}

	vec3 next_v = get_vert(next_v_idx, T);
	vec3 next_next_v = get_vert(next_next_v_idx, T);


	vec3 n = vec3(0,1,0);
	n = -cross(normalize(next_next_v - v), normalize(next_v - v));
	n = normalize(n);
	norm = n;
	norm = ((rot_mat) * vec4(norm,1.0)).xyz;


	uv = vec2(0.5);
	vec4 pos = vec4(v,1);

	ws_pos = (mat * vec4(v.xyz,1)).xyz;
	cs_pos = (P * V * mat * vec4(v.xyz,1));
	cs_pos_prev = (P_prev * V_prev * prev_mat * vec4(v_prev.xyz,1));
	#ifdef SHADOW_MAP
//		ws_pos *= 0.5;
//		is_shadow = true;
	#else
		pos = mat * pos;
		pos = V * pos;
		pos = P * pos;
//		if(false){
//			float depth = pos.z;
//
//			if(is_shadow){
//				//		pos.z += 0.02;
//			}
//			pos.xy = (pos.xy + vec2(1.0, 1.0)) * R * 0.5;
//			quant_dist = 5.01*(1 + pow(abs(depth)/cam_far,2.0) * 240*1.0);
//			if(!is_shadow){
//				pos.xy = round(pos.xy/quant_dist)*quant_dist;
//			} else {
//			}
//			pos.xy = pos.xy * 2.0 / R - 1.0;
//
//		}
//		//	pos.w = 1.0;
//		//	pos.xyz = floor(pos.xyz/quant_dist)*quant_dist;
	#endif
	gl_Position = pos;
}
