
in vec2 uv;
in vec3 norm;


in vec4 cs_pos;
in vec4 cs_pos_prev;

in flat int draw_id;


layout (location = 0) out vec4 C;
layout (location = 1) out uvec2 outN_MatId;
layout (location = 2) out vec2 out_movec;

//uniform int tex_albedo;
//uniform bool has_albedo_tex;

struct MDIUniforms{
	mat4 rot_mat;
	mat4 mat;
	mat4 prev_mat;

	int buff_normals_offs;
	int buff_tex_coords_offs;
	int buff_vert_indices_offs;
	int buff_verts_offs;


	int tex_albedo;
	int has_albedo_tex;
	int g;
	int h;
};

uniform MDIUniforms* mdi_uniforms_buff;


uniform bool is_shadow;

uniform int curr_rendering_light;
uniform int spot_sublight_idx;


in vec3 ws_pos;
in float DD;

void main(){
	if(dbg_frag(vec2(20,20))){
		print(ws_pos);
		print(ws_pos);
		print(ws_pos);
		print(ws_pos);
	}
	
	gl_FragDepth = gl_FragCoord.z;
	if(is_shadow && DD >= 0.0001){
		gl_FragDepth = DD;
	}
//	if(is_shadow){
//		if(lights[curr_rendering_light].type == LIGHT_TYPE_POINT){
//		}
//		return;
//	}

	MDIUniforms un = mdi_uniforms_buff[draw_id];
	C = vec4(1,1,1, 1.0);

	uint n_enc = octahedral_16(norm);
	outN_MatId.x = n_enc;
	outN_MatId.y = 0;
	if(un.has_albedo_tex > 0){
		vec2 u = fract(uv);
		u.y = 1.-u.y;
		u.x = 1.-u.x;
		u *= 1.;
		u = fract(u);
		vec2 tex_res = vec2(textureSize(textures[un.tex_albedo],0).xy);
		C.rgb = texelFetch(textures[un.tex_albedo], ivec2(u*tex_res),0).rgb;
	} else {
//		C.r -= length(cs_pos - cs_pos_prev);
	}

	out_movec = (cs_pos.xy/cs_pos.w - cs_pos_prev.xy/cs_pos_prev.w)/2.0;
//	out_movec = vec2(0);

//	if(potato == 1){
//		C = abs(uv.xyxx)*1.4;
//		C.a = 1.0;
//	}
//	C += 40.;

}
