in vec2 uv;

out vec4 C;

uniform float u_t;
uniform int tex_typo;

#include scene_jyrevis25/common.glsl

bool getText(vec2 p, vec2 ind, vec2 range) {
    if (abs(p.x)>range.x/2.0 || abs(p.y)>range.y/2.0) return false;
    return 0.5<texture(textures[tex_typo], (p+ind+4.0+vec2(0.5)*(fract(range/2.0)*2.0))/8.0).r;
}

vec2 melt(vec2 p, float amount) {
    return p+vec2(0,pow(sin(cos(p.x*4.9)*8.9+p.x-u_t)*0.5+0.6,.4))*amount;
}

vec2 fracture(vec2 p, float amount) {
    float part = 1.0;

    vec2 silly = sin(cos((p.yx)*2.8)*2.12)*0.5+0.5;
    silly *= 0.8;
    mat2 wobb = mat2(1.0+silly.x,0.0,0.0,1.0+silly.y);
    mat2 unwobb = mat2(1.0/(1.0+silly.x),0.0,0.0,1.0/(1.0+silly.y));
    vec2 q = (p*wobb-0.5/part)*wobb;

    vec2 i_p = floor(q*part),
         f_p = fract(q*part);
    seed = (uint)(i_p.y-i_p.x*35.124+5832.0);
    vec2 off = floor(0.5*(1.0+6.0/length(i_p+0.5))/(hash_v2()*2.0-1.0));
    return ((mix(i_p,off,amount)/part+f_p/part)*unwobb+0.5/part)*unwobb;
}

void main() {
    vec2 UV=vec2(uv.x*R.x/R.y, uv.y);

    vec3 col = c_beige;
    if (getText(UV, vec2(0.0), vec2(4.0))) {
        col = c_blue;
    }

    C = vec4(col, 1.0);
}
