in vec2 uv;

out vec4 C;

uniform float u_t;
uniform int tex_typo;

#include scene_jyrevis25/common.glsl

const int ANUNCIO1[8*5] = {
    _R, _E, _V, _I, _S, _I, _O, _N,
    -1, -1, _2, _0, _2, _5, -1, -1, 
    -1, _C, _I, _O, _S, _A, _I, -1,
    _P, _R, _E, _S, _E, _N, _T, _S,
    _C, _H, _U, -1, _L, _I, _A, _U,
};

vec2 melt(vec2 p, float amount) {
    return p+vec2(0,pow(sin(cos(p.x*4.9)*8.9+p.x-u_t)*0.5+0.7,.4))*amount;
}

float coin(vec2 p) {
    vec2 q = abs(p)-1.0;
    return 
        step(length(p),1.0)*
        step(length(q),1.0)
    ;
}

void main() {
    vec2 UV=vec2(uv.x*R.x/R.y, uv.y);

    vec3 col = c_blue;
    
    float musicT = u_t/BEAT_DUR;

    float segRevi = musicT/7.0/4.0 - 7.0;
    float segYear = musicT/7.0/4.0 - 7.0 - 0.75/7.0;
    float segCIOSAI = musicT/7.0/4.0 - 7.0 - 1.75/7.0;
    float segPresents = musicT/7.0/4.0 - 7.0 - 2.5/7.0;
    float segChuliau = musicT/7.0/4.0 - 7.0 - 3.5/7.0;
    float segZoom = musicT/7.0/4.0 - 7.0 - 4.25/7.0;
    float segGateStart = musicT/7.0/4.0 - 7.0 - 5.25/7.0;
    float segLastBass = musicT/7.0/4.0 - 7.0 - 6.75/7.0;

    float timeKick = expease(fract(musicT/7.0)*7.0,4.0)+
                     expease(max(0.0,fract(musicT/7.0)*7.0-2.5),4.0)+
                     expease(max(0.0,fract(musicT/7.0)*7.0-4.0),4.0)+
                     expease(max(0.0,fract(musicT/7.0)*7.0-6.5),4.0);
    float deltaKick = (
        step(0.0,fract(musicT/7.0)*7.0)+
        step(2.5,fract(musicT/7.0)*7.0)+
        step(4.0,fract(musicT/7.0)*7.0)+
        step(6.5,fract(musicT/7.0)*7.0)
    )-timeKick;
    timeKick += floor(musicT/7.0)*4.0;

    float timeSnare = expease(max(0.0,fract(musicT/7.0)*7.0-1.0),4.0)+
                      expease(max(0.0,fract(musicT/7.0)*7.0-3.0),4.0)+
                      expease(max(0.0,fract(musicT/7.0)*7.0-5.0),4.0);
    float deltaSnare = (
        step(1.0,fract(musicT/7.0)*7.0)+
        step(3.0,fract(musicT/7.0)*7.0)+
        step(5.0,fract(musicT/7.0)*7.0)
    )-timeSnare;
    timeSnare += floor(musicT/7.0 - 7.0*4.0)*3.0;

    float timeBass;
    for(float i=0.0; i<6.0; i+=0.75){ timeBass += expease(max(0.0,fract(musicT/7.0)*7.0-i),8.0); }
    float deltaBass;
    for(float i=0.0; i<6.0; i+=0.75){ deltaBass += step(i,fract(musicT/7.0)*7.0); }
    deltaBass -= timeBass;
    timeBass += floor(musicT/3.5)*4.0;
    
    float timeKnock;
    for(float i=0.25; i<6.0; i+=1.25){ timeKnock += expease(max(0.0,fract(musicT/7.0)*7.0-i),8.0); }
    float deltaKnock;
    for(float i=0.25; i<6.0; i+=1.25){ deltaKnock += step(i,fract(musicT/7.0)*7.0); }
    deltaKnock -= timeKnock;
    timeKnock += floor(musicT/7.0)*5.0;

    UV *= mix(1.0,0.65,smoothstep(0.0,0.02,segZoom));

    // camera shake
    UV += sin(u_t*99.9)*pow(deltaKick,3.0)*0.05;

    vec2 polar = vec2((atan(UV.y,UV.x)+PI)/TAU, log(length(UV))/4.0);
    polar.y -= timeKick*0.25;
    polar.x += sign(step(0.5,fract(musicT/7.0/2.0))-0.5) * (timeKick*0.1-polar.y*0.5);

    vec2 i_pol = floor(polar*5.0),
         f_pol = fract(polar*5.0);

    vec3 c1 = c_blue;
    vec3 c2 = c_red;
    if (segLastBass>0.0) {
        c1 = c_beige;
        c2 = c_yellow;
    }
    col = mix(c1, c2, step(0.4, abs(dot(f_pol, vec2(cos(u_t), sin(u_t))))));

    col = mix(col, c_yellow, 
        coin(vec2(abs(UV.x*6.0)-8.0, fract(UV.y*3.0 - sign(UV.x)*timeSnare*2.0)*2.0-1.0))*
        step(1.0-timeSnare/1.5, -sign(UV.x)*UV.y)
    );
    
    vec2 i_uv = floor(UV*4.0);

    if (step(abs(i_uv.x+0.5),3.5)>0.5 && abs(UV.y)<0.125) {
        int ind = 0;
        if (segYear>0.0) ind = 1;
        if (segCIOSAI>0.0) ind = 2;
        if (segPresents>0.0) ind = 3;
        if (segChuliau>0.0) ind = 4;

        vec2 p = fract(vec2(UV.x*4.0, UV.y*4.0+0.5))*2.0-1.0;
        p *= mix(1.0,0.8,deltaSnare);
        p = melt(p, max(0.0,segZoom*16.0));

        int ch = ANUNCIO1[int(4.0+i_uv.x)+ind*8];
        if (ch >= 0) {
            col = mix(col, c_yellow, ascii(textures[tex_typo],
                p*0.3, ch));
        }
    }

    if (segGateStart > 0.0){
        vec2 p = UV*2.0*expease(segGateStart, 144.0);
        p = mix(p, floor(p*8.0)/8.0, deltaBass);
        p *= rot(timeKnock);
        p *= 1.0-deltaKnock*0.1;
        col = mix(col, mix(c_yellow, c_red, step(0.0,segLastBass)), coin(p));
    }

    C = vec4(col, 1.0);
}
