struct Vert{
//    vec4 outline;
    vec3 pos;
    int trans_id;
    vec4 bg_col;
    vec4 v;
    vec4 col;
    vec3 wspos;
    bool const_size;
};
uniform Vert* vertsb;

layout(std430, binding = 0) buffer afffsdg {
    Vert[] verts;
};


uniform mat4* buff_transforms;

out vec2 uv;
out vec4 col;
//out vec4 outline;
out vec4 bg_col;

void main() {
    Vert vert = verts[gl_VertexID];
    
    vec2 uv_pos = vert.pos.xy;
    vec3 ws_pos = vert.wspos.xyz;
    uv = vert.v.zw;
    col = vert.col;
//    outline = vec4(verts[gl_VertexID].outline);
    bg_col = vec4(vert.bg_col);

    
    mat4 trans = mat4(1);
    if(vert.trans_id >= 0){
        trans = buff_transforms[vert.trans_id];
        if(gl_VertexID / 6 == 95){
            print(uv);
        }
//        print(vert.trans_id);
//        print(int(buff_transforms));
    }

    vec4 curr_vert_proj = V * trans * vec4(ws_pos,1);
    float depth = curr_vert_proj.z;
    curr_vert_proj = P * curr_vert_proj;
    vec3 curr_vert_ndc = curr_vert_proj.xyz / curr_vert_proj.w;

    vec2 offs = uv_pos;
    //    vec2 offs = 
    //        gl_VertexID%3 == 0 ? vec2(0) : 
    //        circleVertices[sub_tri_id - (max(int(gl_VertexID)%3 - 0, 0))]*sz*w;
//    bool is_const_size = vert.const_size;
    bool is_const_size = true;
    
    if(!is_const_size){
        offs /= depth;
        offs *= 10.0;
    }
    
    vec2 vert_ndc = curr_vert_ndc.xy + offs;

    vec4 pp = vec4(vert_ndc * curr_vert_proj.w, curr_vert_proj.zw);
//    vec3 ws_pos = vert_buff[tri_id].pos_and_sz.xyz;
    gl_Position = vec4(pp);

//    gl_Position = vec4(uv_pos,0.5,1.0);
}
